/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching;

import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.launching.IExecutable;
import org.eclipse.rcptt.launching.IExecutionSession;
import org.eclipse.rcptt.launching.ILaunchListener;
import org.eclipse.rcptt.launching.Q7Launcher;

public class LaunchTimer
extends Thread
implements ILaunchListener {
    private Timer timer;

    @Override
    public void finished() {
        this.cancel();
    }

    @Override
    public void launchStatusChanged(IExecutable ... executables) {
        this.cancel();
        IExecutable[] iExecutableArray = executables;
        int n = executables.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutable executable = iExecutableArray[n2];
            if (executable.getStatus() == IExecutable.State.RUNNING && !executable.isDebug()) {
                this.timer = new Timer(true);
                int timeout = Q7Launcher.getLaunchTimeout();
                this.timer.schedule((TimerTask)new StopTask((Executable)executable, timeout), timeout * 1000);
            }
            ++n2;
        }
    }

    private void cancel() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    @Override
    public void started(IExecutionSession session) {
    }

    private static class StopTask
    extends TimerTask {
        private Executable executable;
        private int timeout;

        public StopTask(Executable executable, int timeout) {
            this.executable = executable;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            this.executable.cancel((IStatus)new Status(4, "org.eclipse.rcptt.launching", "Execution timed out after " + this.timeout + " seconds"));
        }
    }
}

