/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jetty;

import java.util.Objects;
import java.util.function.Supplier;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.passage.lic.internal.jetty.JettyException;
import org.eclipse.passage.lic.internal.jetty.JettyHandler;
import org.eclipse.passage.lic.internal.jetty.i18n.Messages;
import org.eclipse.passage.lic.internal.net.connect.Port;

public final class JettyServer {
    private final Logger logger = Log.getLogger(JettyServer.class);
    private final Supplier<JettyHandler> handler;
    private Server server;

    public JettyServer(Supplier<JettyHandler> handler) {
        Objects.requireNonNull(handler, "JettyServer::handler");
        this.handler = handler;
    }

    public void launch(Port port) throws JettyException {
        try {
            this.server = new Server(((Integer)port.get().get()).intValue());
            this.server.setHandler((Handler)this.handler.get());
            this.server.start();
            this.logger.info(String.format(Messages.started, port.get()), new Object[0]);
        }
        catch (Exception exception) {
            throw new JettyException(String.format(Messages.error_onstart, exception.getClass(), exception.getMessage()), exception);
        }
    }

    public void terminate() throws JettyException {
        try {
            this.server.stop();
            this.logger.info(String.format(Messages.stopped, new Object[0]), new Object[0]);
        }
        catch (Exception exception) {
            throw new JettyException(String.format(Messages.error_onstop, exception.getClass(), exception.getMessage()), exception);
        }
    }
}

