/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.linux;

import com.sun.jna.Native;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.jna.platform.linux.Libc;
import oshi.util.FileUtil;
import oshi.util.ParseUtil;

public class LinuxGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(LinuxGlobalMemory.class);
    private long memFree = 0L;
    private long activeFile = 0L;
    private long inactiveFile = 0L;
    private long sReclaimable = 0L;
    private long swapFree = 0L;
    private long lastUpdate = 0L;

    public LinuxGlobalMemory() {
        try {
            Libc.Sysinfo info = new Libc.Sysinfo();
            if (0 == Libc.INSTANCE.sysinfo(info)) {
                this.pageSize = info.mem_unit;
            } else {
                LOG.error("Failed to get sysinfo. Error code: {}", (Object)Native.getLastError());
            }
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            LOG.error("Failed to get mem_unit from sysinfo. {}", (Throwable)e);
        }
    }

    @Override
    protected void updateMeminfo() {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdate > 100L) {
            String[] memorySplit;
            List<String> memInfo = FileUtil.readFile("/proc/meminfo");
            boolean found = false;
            for (String checkLine : memInfo) {
                memorySplit = ParseUtil.whitespaces.split(checkLine);
                if (memorySplit.length <= 1) continue;
                switch (memorySplit[0]) {
                    case "MemTotal:": {
                        this.memTotal = this.parseMeminfo(memorySplit);
                        break;
                    }
                    case "MemFree:": {
                        this.memFree = this.parseMeminfo(memorySplit);
                        break;
                    }
                    case "MemAvailable:": {
                        this.memAvailable = this.parseMeminfo(memorySplit);
                        found = true;
                        break;
                    }
                    case "Active(file):": {
                        this.activeFile = this.parseMeminfo(memorySplit);
                        break;
                    }
                    case "Inactive(file):": {
                        this.inactiveFile = this.parseMeminfo(memorySplit);
                        break;
                    }
                    case "SReclaimable:": {
                        this.sReclaimable = this.parseMeminfo(memorySplit);
                        break;
                    }
                    case "SwapTotal:": {
                        this.swapTotal = this.parseMeminfo(memorySplit);
                        break;
                    }
                    case "SwapFree:": {
                        this.swapFree = this.parseMeminfo(memorySplit);
                        break;
                    }
                }
            }
            this.swapUsed = this.swapTotal - this.swapFree;
            if (!found) {
                this.memAvailable = this.memFree + this.activeFile + this.inactiveFile + this.sReclaimable;
            }
            memInfo = FileUtil.readFile("/proc/vmstat");
            for (String checkLine : memInfo) {
                memorySplit = ParseUtil.whitespaces.split(checkLine);
                if (memorySplit.length <= 1) continue;
                switch (memorySplit[0]) {
                    case "pgpgin": {
                        this.swapPagesIn = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
                        break;
                    }
                    case "pgpgout": {
                        this.swapPagesOut = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
                        break;
                    }
                }
            }
            this.lastUpdate = now;
        }
    }

    @Override
    protected void updateSwap() {
        this.updateMeminfo();
    }

    private long parseMeminfo(String[] memorySplit) {
        if (memorySplit.length < 2) {
            return 0L;
        }
        long memory = ParseUtil.parseLongOrDefault(memorySplit[1], 0L);
        if (memorySplit.length > 2 && "kB".equals(memorySplit[2])) {
            memory *= 1024L;
        }
        return memory;
    }
}

