/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.mine;

import java.nio.file.Path;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.passage.lbc.internal.api.FloatingResponse;
import org.eclipse.passage.lbc.internal.base.EObjectTransfer;
import org.eclipse.passage.lbc.internal.base.Failure;
import org.eclipse.passage.lbc.internal.base.ProductUserRequest;
import org.eclipse.passage.lbc.internal.base.mine.PersonalLicenseGenerated;
import org.eclipse.passage.lbc.internal.base.mine.ReassemblingMiningEquipment;
import org.eclipse.passage.lic.floating.FloatingFileExtensions;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.conditions.ConditionAction;
import org.eclipse.passage.lic.internal.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.internal.api.conditions.ConditionPack;
import org.eclipse.passage.lic.internal.api.conditions.mining.MiningEquipment;
import org.eclipse.passage.lic.internal.base.conditions.mining.LocalConditions;
import org.eclipse.passage.lic.internal.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.internal.base.diagnostic.NoErrors;
import org.eclipse.passage.lic.internal.base.io.LicensingFolder;
import org.eclipse.passage.lic.internal.base.io.PassageFileExtension;
import org.eclipse.passage.lic.internal.base.io.PathFromLicensedProduct;
import org.eclipse.passage.lic.internal.base.io.UserHomePath;
import org.eclipse.passage.lic.licenses.model.api.LicensePack;

public final class Conditions
implements Supplier<FloatingResponse> {
    private final ProductUserRequest data;
    private final Supplier<Path> source;
    private final Logger log = LogManager.getLogger(this.getClass());

    public Conditions(ProductUserRequest data, Supplier<Path> base) {
        this.data = data;
        this.source = base;
    }

    public Conditions(ProductUserRequest data) {
        this(data, (Supplier<Path>)new LicensingFolder((Supplier)new UserHomePath()));
    }

    @Override
    public FloatingResponse get() {
        this.log.debug(String.format("Mining conditions for product %s", this.data.product().get()));
        ServiceInvocationResult conditions = new Miner(this.source, this.data.user().get()).all(this.data.product().get());
        if (!conditions.data().isPresent()) {
            return new Failure.OperationFailed(new ConditionAction.Mine().name(), new DiagnosticExplained(conditions.diagnostic()).get());
        }
        if (!new NoErrors().test(conditions.diagnostic())) {
            this.log.error(new DiagnosticExplained(conditions.diagnostic()).get());
        }
        return new EObjectTransfer((EObject)this.pack((Collection)conditions.data().get()));
    }

    private LicensePack pack(Collection<ConditionPack> conditions) {
        return new PersonalLicenseGenerated(this.data.product().get(), this.data.user().get(), conditions.stream().flatMap(pack -> pack.conditions().stream()).collect(Collectors.toList())).get();
    }

    private final class Miner
    extends LocalConditions {
        private final Supplier<Path> base;

        Miner(Supplier<Path> base, String user) {
            super(new ConditionMiningTarget.Local().child("floating-server"), (MiningEquipment)new ReassemblingMiningEquipment(user, base), (PassageFileExtension)new FloatingFileExtensions.FloatingLicenseEncrypted());
            this.base = base;
        }

        protected Supplier<Path> base(LicensedProduct product) {
            return new PathFromLicensedProduct(this.base, product);
        }
    }
}

