/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.requirements;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.internal.api.registry.StringServiceId;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.requirements.ResolvedRequirements;
import org.eclipse.passage.lic.internal.base.requirements.UnsatisfiableRequirement;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;
import org.eclipse.passage.lic.internal.equinox.requirements.BundleRequirements;
import org.eclipse.passage.lic.internal.equinox.requirements.RequirementFromComponent;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public final class ComponentRequirements
implements ResolvedRequirements {
    private final Logger logger = LoggerFactory.getLogger(BundleRequirements.class);
    private Optional<BundleContext> context = Optional.empty();
    private Optional<ServiceComponentRuntime> runtime = Optional.empty();

    public StringServiceId id() {
        return new StringServiceId("OSGi component");
    }

    @Activate
    public void activate(BundleContext bundle) {
        this.context = Optional.ofNullable(bundle);
    }

    @Deactivate
    public void deactivate() {
        this.context = Optional.empty();
    }

    @Reference
    public void bindRuntime(ServiceComponentRuntime input) {
        this.runtime = Optional.ofNullable(input);
    }

    public void unbindRuntime(ServiceComponentRuntime input) {
        if (!this.runtime.isPresent()) {
            return;
        }
        if (this.runtime.get() == input) {
            this.runtime = Optional.empty();
        }
    }

    public Collection<Requirement> all() {
        if (!this.runtime.isPresent()) {
            return this.unsafisifiable(ServiceComponentRuntime.class.getSimpleName());
        }
        if (!this.context.isPresent()) {
            return this.unsafisifiable(BundleContext.class.getSimpleName());
        }
        return this.resolve();
    }

    private Collection<Requirement> unsafisifiable(String resource) {
        this.logger.error(NLS.bind((String)EquinoxMessages.ComponentRequirements_error_no_resource, (Object)resource));
        return Collections.singleton(new UnsatisfiableRequirement(NLS.bind((String)EquinoxMessages.ComponentRequirements_requirement_for_resource, (Object)resource, (Object)this.getClass().getName()), this.getClass()).get());
    }

    private Collection<Requirement> resolve() {
        return this.runtime.get().getComponentDescriptionDTOs(this.context.get().getBundles()).stream().map(component -> new RequirementFromComponent((ComponentDescriptionDTO)component, this.context.get())).map(RequirementFromComponent::get).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }
}

