/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util.lists;

import com.sun.messaging.jmq.util.lists.EventBroadcastHelper;
import com.sun.messaging.jmq.util.lists.EventBroadcaster;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import com.sun.messaging.jmq.util.lists.Filter;
import com.sun.messaging.jmq.util.lists.FilterableSet;
import com.sun.messaging.jmq.util.lists.Limitable;
import com.sun.messaging.jmq.util.lists.Ordered;
import com.sun.messaging.jmq.util.lists.OutOfLimitsException;
import com.sun.messaging.jmq.util.lists.Prioritized;
import com.sun.messaging.jmq.util.lists.PriorityFifoSet;
import com.sun.messaging.jmq.util.lists.PrioritySetEntry;
import com.sun.messaging.jmq.util.lists.QueuingOrder;
import com.sun.messaging.jmq.util.lists.Reason;
import com.sun.messaging.jmq.util.lists.SetEntry;
import com.sun.messaging.jmq.util.lists.Sized;
import com.sun.messaging.jmq.util.lists.SubSet;
import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class NFLPriorityFifoSet<E>
extends PriorityFifoSet<E>
implements FilterableSet<E>,
EventBroadcaster,
Limitable {
    private static boolean DEBUG = false;
    Set<NotifyInfo> gni = new HashSet<NotifyInfo>();
    Object filterSetLock = new Object();
    Map<Object, FilterSet> filterSets = null;
    Map<Object, ComparatorSet<E>> comparatorSets = null;
    EventBroadcastHelper ebh = new EventBroadcastHelper();
    private boolean enforceLimits = true;
    private int highWaterCnt = 0;
    private long highWaterBytes = 0L;
    private long largestMessageHighWater = 0L;
    private float averageCount = 0.0f;
    private double averageBytes = 0.0;
    private double messageAverage = 0.0;
    private long numberSamples = 0L;
    protected int maxCapacity = -1;
    protected long maxByteCapacity = -1L;
    protected long bytes = 0L;
    protected long maxBytePerObject = -1L;
    protected boolean orderMaintained = true;
    private long queuePosition = 0L;
    long currentID = 1L;

    public NFLPriorityFifoSet() {
        this(10, false);
    }

    public NFLPriorityFifoSet(int levels) {
        this(levels, false);
    }

    public NFLPriorityFifoSet(int levels, boolean maintainOrder) {
        super(levels);
        this.orderMaintained = maintainOrder;
        this.ebh.setOrderMaintained(maintainOrder);
        this.setLock(this);
        this.lookup = Collections.synchronizedMap(this.lookup);
    }

    public void enforceLimits(boolean enforce) {
        this.enforceLimits = enforce;
    }

    public boolean getEnforceLimits() {
        return this.enforceLimits;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean cleanupEntry(SetEntry<E> e) {
        Object object = this.lock;
        synchronized (object) {
            return super.cleanupEntry(e);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean ok = false;
        Iterator<E> itr = c.iterator();
        while (itr.hasNext()) {
            ok |= this.add(itr.next());
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            Iterator<E> itr = this.iterator();
            while (itr.hasNext()) {
                itr.next();
                itr.remove();
            }
            this.bytes = 0L;
            super.clear();
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public boolean add(E o) {
        return this.add(this.defaultPriority, o, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return super.size();
        }
    }

    @Override
    public void addAllToFront(Collection<E> c, int pri) {
        this.addAllToFront(c, pri, null);
    }

    @Override
    public void addAllOrdered(Collection<E> c) {
        this.addAllOrdered(c, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addAllOrdered(Collection<E> c, Reason reason) {
        if (c.isEmpty()) {
            return;
        }
        HashSet<Object> notify = null;
        boolean notifyTop = false;
        boolean wasEmpty = this.isEmpty();
        Iterator<E> itr = c.iterator();
        while (itr.hasNext()) {
            void var7_7;
            Object var7_8 = null;
            boolean found = false;
            int pri = 0;
            Object o = null;
            Object object = this.lock;
            synchronized (object) {
                o = itr.next();
                if (!(o instanceof Ordered)) {
                    throw new RuntimeException("Can not order unordered items");
                }
                Ordered oo = (Ordered)o;
                QueuingOrder orderobj = (QueuingOrder)oo.getOrder();
                pri = orderobj.priority;
                if (this.lookup.get(o) != null) {
                    this.remove(o);
                }
                SetEntry setEntry = this.priorities[pri];
                found = false;
                if (this.tail != null && orderobj.greaterThan((QueuingOrder)((Ordered)this.tail.getData()).getOrder())) {
                    Object var7_10 = null;
                }
                if (pri < this.levels - 2 && this.priorities[pri + 1] != null) {
                    SetEntry back = this.priorities[pri + 1].getPrevious();
                    if (back == null) {
                        Object var7_12 = null;
                    } else if (back.getData() == null) {
                        Object var7_13 = null;
                    } else if (orderobj.greaterThan((QueuingOrder)((Ordered)back.getData()).getOrder())) {
                        Object var7_14 = null;
                    }
                }
                while (!found && var7_7 != null) {
                    Object io = var7_7.getData();
                    if (!(io instanceof Ordered)) {
                        throw new RuntimeException("Can not order unordered items");
                    }
                    Ordered so = (Ordered)io;
                    if (orderobj.greaterThan((QueuingOrder)so.getOrder())) {
                        if (var7_7.getNext() == null) break;
                        SetEntry setEntry2 = var7_7.getNext();
                        continue;
                    }
                    found = true;
                }
                if (var7_7 != null) {
                    SetEntry startOfList;
                    SetEntry<Object> e = this.createSetEntry(o, pri);
                    this.lookup.put(o, e);
                    if (found) {
                        var7_7.insertEntryBefore(e);
                        if (var7_7 == this.priorities[pri]) {
                            this.priorities[pri] = e;
                        }
                        if (var7_7 == this.head) {
                            this.head = e;
                        }
                    } else {
                        var7_7.insertEntryAfter(e);
                        if (var7_7 == this.tail) {
                            this.tail = e;
                        }
                    }
                    if (wasEmpty != this.isEmpty()) {
                        notifyTop = true;
                    }
                    if ((startOfList = this.head) != null && this.filterSets != null) {
                        for (FilterSet s : this.filterSets.values()) {
                            if (s == null) continue;
                            boolean wasFilterEmpty = s.isEmpty();
                            s.addItem(startOfList.getData(), true);
                            if (!wasFilterEmpty && !notifyTop) continue;
                            if (notify == null) {
                                notify = new HashSet<Object>();
                            }
                            notify.add(s.getUID());
                        }
                    }
                }
            }
            if (var7_7 != null) continue;
            this.add(pri, o);
            if (wasEmpty == this.isEmpty()) continue;
            notifyTop = true;
        }
        if (notify != null || notifyTop) {
            if (notifyTop && this.hasListeners(EventType.EMPTY)) {
                this.notifyChange(EventType.EMPTY, Boolean.TRUE, Boolean.FALSE, reason);
            }
            if (notify != null) {
                Object var7_16 = null;
                SubSet subSet = null;
                for (Object e : notify) {
                    if (e == null) continue;
                    Object object = this.filterSetLock;
                    synchronized (object) {
                        subSet = this.filterSets.get(e);
                    }
                    if (subSet == null) continue;
                    if (FilterSet.class.isInstance(subSet)) {
                        ((FilterSet)subSet).notifyEmptyChanged(!((FilterSet)subSet).isEmpty(), reason);
                        continue;
                    }
                    assert (subSet instanceof ComparatorSet);
                    ((ComparatorSet)subSet).notifyEmptyChanged(!((ComparatorSet)subSet).isEmpty(), reason);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAllToFront(Collection<E> c, int pri, Reason reason) {
        if (c.isEmpty()) {
            return;
        }
        HashSet<Object> notify = null;
        boolean notifyTop = false;
        boolean wasEmpty = false;
        Object object = this.lock;
        synchronized (object) {
            wasEmpty = this.isEmpty();
            SetEntry<E> startOfList = null;
            if (this.priorities[pri] == null) {
                for (E o : c) {
                    super.add(pri, o);
                    if (startOfList != null) continue;
                    startOfList = (SetEntry<E>)this.lookup.get(o);
                }
            } else {
                Object endEntry = this.priorities[pri];
                for (E o : c) {
                    SetEntry dup = null;
                    dup = (SetEntry)this.lookup.get(o);
                    if (dup != null) {
                        this.remove(o);
                        if (endEntry == dup) {
                            endEntry = null;
                        }
                        if (dup == startOfList) {
                            startOfList = this.priorities[pri];
                        }
                    }
                    if (endEntry == null) {
                        super.add(pri, o);
                        if (startOfList != null) continue;
                        startOfList = (SetEntry)this.lookup.get(o);
                        continue;
                    }
                    SetEntry<E> e = this.createSetEntry(o, pri);
                    this.lookup.put(o, e);
                    ((SetEntry)endEntry).insertEntryBefore(e);
                    if (startOfList != null) continue;
                    this.priorities[pri] = startOfList = e;
                    if (endEntry != this.head) continue;
                    this.head = startOfList;
                }
            }
            if (wasEmpty != this.isEmpty()) {
                notifyTop = true;
            }
            if (this.filterSets != null) {
                for (FilterSet s : this.filterSets.values()) {
                    if (s == null) continue;
                    boolean wasFilterEmpty = s.isEmpty();
                    s.addItem(startOfList.getData(), true);
                    if (!wasFilterEmpty && !notifyTop) continue;
                    if (notify == null) {
                        notify = new HashSet<Object>();
                    }
                    notify.add(s.getUID());
                }
            }
        }
        if (notify != null || notifyTop) {
            if (notifyTop && this.hasListeners(EventType.EMPTY)) {
                this.notifyChange(EventType.EMPTY, Boolean.TRUE, Boolean.FALSE, reason);
            }
            if (notify != null) {
                Object var7_8 = null;
                SubSet subSet = null;
                for (Object e : notify) {
                    if (e == null) continue;
                    Object object2 = this.filterSetLock;
                    synchronized (object2) {
                        subSet = this.filterSets.get(e);
                    }
                    if (subSet == null) continue;
                    if (FilterSet.class.isInstance(subSet)) {
                        ((FilterSet)subSet).notifyEmptyChanged(!((FilterSet)subSet).isEmpty(), reason);
                        continue;
                    }
                    assert (subSet instanceof ComparatorSet);
                    ((ComparatorSet)subSet).notifyEmptyChanged(!((ComparatorSet)subSet).isEmpty(), reason);
                }
            }
        }
    }

    @Override
    public boolean add(E o, Reason r) {
        return this.add(this.defaultPriority, o, r);
    }

    @Override
    public boolean add(int pri, E o) {
        return this.add(pri, o, null);
    }

    private void preAdd(Object o, Reason reason) {
        if (this.hasListeners(EventType.SET_CHANGED_REQUEST)) {
            this.notifyChange(EventType.SET_CHANGED_REQUEST, null, o, reason);
        }
        if (o == null) {
            throw new NullPointerException("Unable to support null  values");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NotifyInfo internalAdd(int pri, E o) {
        assert (Thread.holdsLock(this));
        NotifyInfo ni = null;
        long objsize = 0L;
        if (this.maxByteCapacity != -1L && !(o instanceof Sized)) {
            throw new ClassCastException("Unable to add object not of type Sized when byteCapacity has been set");
        }
        if (this.maxBytePerObject != -1L && !(o instanceof Sized)) {
            throw new ClassCastException("Unable to add object not of type Sized when maxByteSize has been set");
        }
        if (this.enforceLimits && this.maxCapacity != -1 && this.maxCapacity - this.size() <= 0) {
            throw new OutOfLimitsException(0, this.size(), this.maxCapacity);
        }
        if (this.enforceLimits && this.maxByteCapacity != -1L && this.maxByteCapacity - this.bytes <= 0L) {
            throw new OutOfLimitsException(1, this.bytes, this.maxByteCapacity);
        }
        if (o instanceof Sized) {
            objsize = ((Sized)o).byteSize();
        }
        if (this.maxBytePerObject != -1L && objsize > this.maxBytePerObject) {
            throw new OutOfLimitsException(2, objsize, this.maxByteCapacity);
        }
        int oldsize = this.size();
        long oldbytes = this.bytes;
        boolean added = super.add(pri, o);
        if (o instanceof Ordered && ((Ordered)o).getOrder() == null) {
            QueuingOrder orderobj = new QueuingOrder();
            orderobj.priority = pri;
            orderobj.position = this.queuePosition++;
            ((Ordered)o).setOrder(orderobj);
        }
        this.bytes += objsize;
        this.averageCount = ((float)this.numberSamples * this.averageCount + (float)this.size()) / ((float)this.numberSamples + 1.0f);
        this.averageBytes = ((double)this.numberSamples * this.averageBytes + (double)this.bytes) / ((double)this.numberSamples + 1.0);
        this.messageAverage = ((double)this.numberSamples * this.messageAverage + (double)objsize) / ((double)this.numberSamples + 1.0);
        ++this.numberSamples;
        if (added) {
            if (this.size() > this.highWaterCnt) {
                this.highWaterCnt = this.size();
            }
            if (objsize > this.largestMessageHighWater) {
                this.largestMessageHighWater = objsize;
            }
            if (this.bytes > this.highWaterBytes) {
                this.highWaterBytes = this.bytes;
            }
            if (this.hasListeners() || this.filterSets != null && !this.filterSets.isEmpty() || this.comparatorSets != null && !this.comparatorSets.isEmpty()) {
                ni = this.getNI();
                ni.oldsize = oldsize;
                ni.oldbytes = oldbytes;
                ni.objsize = objsize;
                ni.newbytes = oldbytes + objsize;
                ni.newsize = this.size();
                ni.curMaxCapacity = this.maxCapacity;
                ni.curMaxBytesCapacity = this.maxByteCapacity;
                int cnt = 0;
                Object object = this.lock;
                synchronized (object) {
                    boolean wasEmpty;
                    if (this.filterSets != null) {
                        for (FilterSet filterSet : this.filterSets.values()) {
                            if (filterSet == null) continue;
                            wasEmpty = filterSet.isEmpty();
                            filterSet.addItem(o);
                            if (wasEmpty == filterSet.isEmpty()) continue;
                            if (ni.filters[cnt] == null) {
                                ni.filters[cnt] = new EmptyChanged();
                            }
                            ni.filters[cnt].f = filterSet;
                            ni.filters[cnt].isEmpty = !wasEmpty;
                            ++cnt;
                        }
                    }
                    if (this.comparatorSets != null) {
                        for (ComparatorSet<E> comparatorSet : this.comparatorSets.values()) {
                            if (comparatorSet == null) continue;
                            wasEmpty = comparatorSet.isEmpty();
                            comparatorSet.addItem(o);
                            if (wasEmpty == comparatorSet.isEmpty()) continue;
                            if (ni.filters[cnt] == null) {
                                ni.filters[cnt] = new EmptyChanged();
                            }
                            ni.filters[cnt].f = comparatorSet;
                            ni.filters[cnt].isEmpty = !wasEmpty;
                            ++cnt;
                        }
                    }
                }
                if (cnt < ni.filters.length && ni.filters[cnt] != null) {
                    ni.filters[cnt].f = null;
                }
            }
        }
        return ni;
    }

    private void postAdd(Object o, NotifyInfo ni, Reason reason) {
        if (this.hasListeners(EventType.SIZE_CHANGED) && ni.oldsize != ni.newsize) {
            this.notifyChange(EventType.SIZE_CHANGED, ni.oldsize, ni.newsize, reason);
        }
        if (this.hasListeners(EventType.BYTES_CHANGED) && ni.oldbytes != ni.newbytes) {
            this.notifyChange(EventType.BYTES_CHANGED, ni.oldbytes, ni.newbytes, reason);
        }
        if (this.hasListeners(EventType.SET_CHANGED)) {
            this.notifyChange(EventType.SET_CHANGED, null, o, reason);
        }
        if (ni.oldsize == 0 && ni.newsize != 0 && this.hasListeners(EventType.EMPTY)) {
            this.notifyChange(EventType.EMPTY, Boolean.TRUE, Boolean.FALSE, reason);
        }
        if (this.hasListeners(EventType.FULL) && ni.curMaxBytesCapacity != -1L && ni.curMaxBytesCapacity - ni.newbytes <= 0L || (long)ni.curMaxCapacity != -1L && ni.curMaxCapacity - ni.newsize <= 0) {
            this.notifyChange(EventType.FULL, Boolean.FALSE, Boolean.TRUE, reason);
        }
        for (EmptyChanged filter : ni.filters) {
            if (filter == null || filter.f == null) break;
            SubSet subSet = filter.f;
            if (FilterSet.class.isInstance(subSet)) {
                ((FilterSet)subSet).notifyEmptyChanged(filter.isEmpty, reason);
                continue;
            }
            assert (subSet instanceof ComparatorSet);
            ((ComparatorSet)subSet).notifyEmptyChanged(filter.isEmpty, reason);
        }
        this.putNI(ni);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(int pri, E o, Reason reason) {
        NotifyInfo ni = null;
        this.preAdd(o, reason);
        Object object = this.lock;
        synchronized (object) {
            ni = this.internalAdd(pri, o);
        }
        if (ni != null) {
            this.postAdd(o, ni, reason);
        }
        return ni != null;
    }

    public boolean removeAll(Collection<E> c, Reason r) {
        boolean removed = false;
        Iterator<E> itr = c.iterator();
        while (itr.hasNext()) {
            removed |= this.remove(itr.next(), r);
        }
        return removed;
    }

    @Override
    public boolean remove(Object o) {
        return this.remove(o, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NotifyInfo getNI() {
        NotifyInfo ni = null;
        Object object = this.lock;
        synchronized (object) {
            int size;
            if (this.gni.isEmpty()) {
                ni = new NotifyInfo();
            } else {
                Iterator<NotifyInfo> itr = this.gni.iterator();
                ni = itr.next();
                itr.remove();
            }
            int n = size = this.filterSets == null ? 0 : this.filterSets.size();
            if (ni.filters == null || ni.filters.length < size) {
                ni.filters = new EmptyChanged[size];
            }
        }
        return ni;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putNI(NotifyInfo ni) {
        if (ni == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.gni.add(ni);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NotifyInfo internalRemove(E o, Reason r, Iterator pitr, boolean hasListeners) {
        Object object = this.lock;
        synchronized (object) {
            boolean empty;
            nSetEntry nse;
            assert (Thread.holdsLock(this.lock));
            long objsize = 0L;
            int oldsize = this.size();
            long oldbytes = this.bytes;
            if (o instanceof Sized) {
                objsize = ((Sized)o).byteSize();
            }
            if ((nse = (nSetEntry)this.lookup.get(o)) == null) {
                return null;
            }
            boolean removed = true;
            if (pitr != null) {
                pitr.remove();
            } else {
                assert (Thread.holdsLock(this.lock));
                removed = super.remove(o);
            }
            if (!removed) {
                return null;
            }
            if (!(this.hasListeners() || this.filterSets != null && !this.filterSets.isEmpty() || this.comparatorSets != null && !this.comparatorSets.isEmpty())) {
                return null;
            }
            NotifyInfo ni = this.getNI();
            ni.oldbytes = oldbytes;
            ni.oldsize = oldsize;
            ni.objsize = objsize;
            ni.newsize = this.size();
            ni.newbytes = this.bytes;
            ni.curMaxCapacity = this.maxCapacity;
            ni.curMaxBytesCapacity = this.maxByteCapacity;
            int cnt = 0;
            if (this.filterSets != null) {
                for (FilterSet filterSet : this.filterSets.values()) {
                    if (filterSet == null) continue;
                    empty = filterSet.isEmpty();
                    filterSet.removeItem(o);
                    if (empty == filterSet.isEmpty()) continue;
                    if (ni.filters[cnt] == null) {
                        ni.filters[cnt] = new EmptyChanged();
                    }
                    ni.filters[cnt].f = filterSet;
                    ni.filters[cnt].isEmpty = empty;
                    ++cnt;
                }
            }
            if (this.comparatorSets != null) {
                for (ComparatorSet comparatorSet : this.comparatorSets.values()) {
                    if (comparatorSet == null) continue;
                    empty = comparatorSet.isEmpty();
                    comparatorSet.removeItem(o);
                    if (empty == comparatorSet.isEmpty()) continue;
                    if (ni.filters[cnt] == null) {
                        ni.filters[cnt] = new EmptyChanged();
                    }
                    ni.filters[cnt].f = comparatorSet;
                    ni.filters[cnt].isEmpty = !empty;
                    ++cnt;
                }
            }
            if (cnt < ni.filters.length && ni.filters[cnt] != null) {
                ni.filters[cnt].f = null;
            }
            if (pitr == null) {
                nse.clear();
            }
            return ni;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(E o, Reason r) {
        if (o == null) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.contains(o)) {
                return false;
            }
        }
        this.preRemoveNotify(o, r);
        NotifyInfo ni = this.internalRemove(o, r, null, this.hasListeners());
        if (ni != null) {
            this.postRemoveNotify(o, ni, r);
        }
        Object object2 = this.lock;
        synchronized (object2) {
            return !this.contains(o);
        }
    }

    public E removeNext() {
        return this.removeNext(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E removeNext(Reason r) {
        E o = null;
        NotifyInfo ni = null;
        Object object = this.lock;
        synchronized (object) {
            o = this.first();
            if (o == null) {
                return null;
            }
            ni = this.internalRemove(o, r, null, this.hasListeners());
        }
        this.preRemoveNotify(o, r);
        if (ni != null) {
            this.postRemoveNotify(o, ni, r);
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E peekNext() {
        Object object = this.lock;
        synchronized (object) {
            return this.first();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        Object object = this.lock;
        synchronized (object) {
            return new wrapIterator(super.iterator());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubSet<E> subSet(Filter f) {
        Object object = this.lock;
        synchronized (object) {
            Object uid = new Object();
            FilterSet fs = new FilterSet(uid, f);
            if (this.filterSets == null) {
                this.filterSets = new WeakValueHashMap<Object, FilterSet>("FilterSet");
            }
            Object object2 = this.filterSetLock;
            synchronized (object2) {
                this.filterSets.put(uid, fs);
            }
            return fs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubSet<E> subSet(Comparator<E> c) {
        Object object = this.lock;
        synchronized (object) {
            Object uid = new Object();
            ComparatorSet<E> cs = new ComparatorSet<E>(uid, c, this);
            if (this.comparatorSets == null) {
                this.comparatorSets = new WeakValueHashMap<Object, ComparatorSet<E>>("ComparatorSet");
            }
            this.comparatorSets.put(uid, cs);
            return cs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<E> getAll(Filter f) {
        Object object = this.lock;
        synchronized (object) {
            LinkedHashSet<E> s = new LinkedHashSet<E>();
            for (E o : this) {
                if (f != null && !f.matches(o)) continue;
                s.add(o);
            }
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyFilterSet(Object uid) {
        assert (this.filterSets != null);
        Object object = this.lock;
        synchronized (object) {
            if (this.filterSets != null) {
                Object object2 = this.filterSetLock;
                synchronized (object2) {
                    this.filterSets.remove(uid);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyComparatorSet(Object uid) {
        assert (this.comparatorSets != null);
        Object object = this.lock;
        synchronized (object) {
            if (this.comparatorSets != null) {
                this.comparatorSets.remove(uid);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.ebh.clear();
        super.clear();
        Object object = this.lock;
        synchronized (object) {
            if (this.filterSets != null) {
                Object object2 = this.filterSetLock;
                synchronized (object2) {
                    this.filterSets.clear();
                }
            }
            if (this.comparatorSets != null) {
                this.comparatorSets.clear();
            }
            this.gni.clear();
        }
    }

    @Override
    protected SetEntry<E> createSetEntry(E o, int p) {
        return new nSetEntry(o, p);
    }

    @Override
    public synchronized String toDebugString() {
        StringBuilder str = new StringBuilder();
        str.append("NFLPriorityFifoSet: \n");
        if (this.filterSets != null) {
            str.append("\tfilterSets: ").append(this.filterSets.size()).append('\n');
            for (FilterSet filterSet : this.filterSets.values()) {
                if (filterSet == null) continue;
                str.append("\t\tFilterSet ").append(filterSet.hashCode()).append(" filter[").append(filterSet.f).append("]\n");
            }
        }
        if (this.comparatorSets != null) {
            str.append("\tComparatorSets: ").append(this.comparatorSets.size()).append('\n');
            for (ComparatorSet comparatorSet : this.comparatorSets.values()) {
                if (comparatorSet == null) continue;
                str.append("\t\tComparatorSet ").append(comparatorSet.hashCode()).append(" filter[").append(comparatorSet.comparator()).append("]\n");
            }
        }
        str.append('\t').append(this.ebh);
        str.append("\n\nSUBCLASS INFO\n");
        str.append(super.toDebugString());
        return str.toString();
    }

    protected void preRemoveNotify(E o, Reason reason) {
        if (this.hasListeners(EventType.SET_CHANGED_REQUEST)) {
            this.notifyChange(EventType.SET_CHANGED_REQUEST, o, null, reason);
        }
    }

    protected void postRemoveNotify(E o, NotifyInfo ni, Reason reason) {
        if (!this.hasListeners()) {
            return;
        }
        if (ni.oldsize != ni.newsize && this.hasListeners(EventType.SIZE_CHANGED)) {
            this.notifyChange(EventType.SIZE_CHANGED, ni.oldsize, ni.newsize, reason);
        }
        if (ni.newbytes != ni.oldbytes && this.hasListeners(EventType.BYTES_CHANGED)) {
            this.notifyChange(EventType.BYTES_CHANGED, ni.oldbytes, ni.newbytes, reason);
        }
        if (this.hasListeners(EventType.SET_CHANGED)) {
            this.notifyChange(EventType.SET_CHANGED, o, null, reason);
        }
        if (ni.oldsize != 0 && ni.newsize == 0 && this.hasListeners(EventType.EMPTY)) {
            this.notifyChange(EventType.EMPTY, Boolean.FALSE, Boolean.TRUE, reason);
        }
        if (this.hasListeners(EventType.FULL) && ni.curMaxBytesCapacity != -1L && ni.curMaxBytesCapacity - ni.oldbytes <= 0L && ni.curMaxBytesCapacity - ni.newbytes > 0L || ni.curMaxCapacity != -1 && ni.curMaxCapacity - ni.oldsize <= 0 && ni.curMaxCapacity - ni.newsize > 0) {
            this.notifyChange(EventType.FULL, Boolean.TRUE, Boolean.FALSE, reason);
        }
        for (EmptyChanged filter : ni.filters) {
            if (filter == null || filter.f == null) break;
            SubSet s = filter.f;
            if (FilterSet.class.isInstance(s)) {
                ((FilterSet)s).notifyEmptyChanged(filter.isEmpty, reason);
                continue;
            }
            assert (s instanceof ComparatorSet);
            ((ComparatorSet)s).notifyEmptyChanged(filter.isEmpty, reason);
        }
        this.putNI(ni);
    }

    @Override
    public int highWaterCount() {
        return this.highWaterCnt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long highWaterBytes() {
        Object object = this.lock;
        synchronized (object) {
            return this.highWaterBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long highWaterLargestMessageBytes() {
        Object object = this.lock;
        synchronized (object) {
            return this.largestMessageHighWater;
        }
    }

    @Override
    public float averageCount() {
        return this.averageCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double averageBytes() {
        Object object = this.lock;
        synchronized (object) {
            return this.averageBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double averageMessageBytes() {
        Object object = this.lock;
        synchronized (object) {
            return this.messageAverage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxByteSize(long bytes) {
        if (bytes < -1L) {
            bytes = -1L;
        }
        Object object = this.lock;
        synchronized (object) {
            this.maxBytePerObject = bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long maxByteSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.maxBytePerObject;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCapacity(int cnt) {
        if (cnt < -1) {
            cnt = -1;
        }
        boolean nowFull = false;
        boolean nowNotFull = false;
        Object object = this.lock;
        synchronized (object) {
            nowFull = !this.isFull() && cnt != -1 && cnt <= this.size();
            nowNotFull = this.isFull() && (cnt == -1 || cnt > this.size());
            this.maxCapacity = cnt;
        }
        if (nowFull) {
            this.notifyChange(EventType.FULL, Boolean.FALSE, Boolean.TRUE, null);
        } else if (nowNotFull) {
            this.notifyChange(EventType.FULL, Boolean.TRUE, Boolean.FALSE, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByteCapacity(long size) {
        boolean nowFull = false;
        boolean nowNotFull = false;
        if (size < -1L) {
            size = -1L;
        }
        Object object = this.lock;
        synchronized (object) {
            nowFull = !this.isFull() && size != -1L && size <= this.byteSize();
            nowNotFull = this.isFull() && (size == -1L || size > this.byteSize());
            this.maxByteCapacity = size;
        }
        if (nowFull) {
            this.notifyChange(EventType.FULL, Boolean.FALSE, Boolean.TRUE, null);
        } else if (nowNotFull) {
            this.notifyChange(EventType.FULL, Boolean.TRUE, Boolean.FALSE, null);
        }
    }

    @Override
    public int capacity() {
        return this.maxCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long byteCapacity() {
        Object object = this.lock;
        synchronized (object) {
            return this.maxByteCapacity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFull() {
        Object object = this.lock;
        synchronized (object) {
            return this.freeSpace() == 0 || this.freeBytes() == 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int freeSpace() {
        Object object = this.lock;
        synchronized (object) {
            if (this.maxCapacity == -1) {
                return -1;
            }
            int sz = this.maxCapacity - this.size();
            if (sz < 0) {
                return 0;
            }
            return sz;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long freeBytes() {
        Object object = this.lock;
        synchronized (object) {
            if (this.maxByteCapacity == -1L) {
                return -1L;
            }
            long retval = this.maxByteCapacity - this.bytes;
            if (retval < 0L) {
                return 0L;
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long byteSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.bytes;
        }
    }

    @Override
    public Object addEventListener(EventListener listener, EventType type, Object userData) {
        return this.ebh.addEventListener(listener, type, userData);
    }

    @Override
    public Object addEventListener(EventListener listener, EventType type, Reason reason, Object userData) {
        return this.ebh.addEventListener(listener, type, reason, userData);
    }

    @Override
    public Object removeEventListener(Object id) {
        return this.ebh.removeEventListener(id);
    }

    protected boolean hasListeners(EventType e) {
        return this.ebh.hasListeners(e);
    }

    protected boolean hasListeners() {
        return this.ebh.hasListeners();
    }

    protected void notifyChange(EventType e, Object oldval, Object newval, Reason r) {
        if (!this.hasListeners()) {
            return;
        }
        this.ebh.notifyChange(e, r, this, oldval, newval);
    }

    @Override
    public void sort(Comparator<SetEntry<E>> c) {
        super.sort(c);
        if (this.filterSets != null) {
            for (FilterSet s : this.filterSets.values()) {
                if (s == null) continue;
                s.resetFilterSet((nSetEntry)this.head);
            }
        }
    }

    class FilterSet
    extends AbstractSet<E>
    implements SubSet<E>,
    Prioritized<E> {
        EventBroadcastHelper ebh = new EventBroadcastHelper();
        Object uid;
        Filter f = null;
        int currentPriority;
        nSetEntry nextEntry = null;
        nSetEntry currentEntry = null;

        @Override
        public String toString() {
            return "FilterSet[" + this.f + "]" + super.toString() + "(uid=" + this.uid + ")";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetFilterSet(nSetEntry top) {
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                this.nextEntry = top;
                this.currentEntry = null;
            }
        }

        @Override
        public String toDebugString() {
            StringBuilder str = new StringBuilder();
            str.append("FilterSet[").append(this.f).append("]\n");
            str.append("\tDumping FilterSet\n");
            Iterator itr = this.iterator();
            while (itr.hasNext()) {
                str.append("\t\t").append(itr.next()).append('\n');
            }
            str.append("\tcurrentPriority ").append(this.currentPriority).append('\n');
            str.append("\tnextEntry ").append(this.nextEntry).append('\n');
            str.append("\tcurrentEntry ").append(this.currentEntry).append('\n');
            str.append('\t').append(this.ebh);
            str.append("NFLPriorityFifoSet.this.head=").append(NFLPriorityFifoSet.this.head).append('\n');
            str.append("NFLPriorityFifoSet.this.tail=").append(NFLPriorityFifoSet.this.tail).append('\n');
            str.append(NFLPriorityFifoSet.this.toDebugString());
            return str.toString();
        }

        @Override
        public void addAllToFront(Collection<E> c, int pri) {
            NFLPriorityFifoSet.this.addAllToFront(c, pri);
        }

        @Override
        public void addAllOrdered(Collection<E> c) {
            NFLPriorityFifoSet.this.addAllOrdered(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        FilterSet(Object uid, Filter f) {
            this.ebh.setOrderMaintained(NFLPriorityFifoSet.this.orderMaintained);
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                this.uid = uid;
                this.f = f;
                this.nextEntry = (nSetEntry)(NFLPriorityFifoSet.this.start == null ? NFLPriorityFifoSet.this.head : NFLPriorityFifoSet.this.start);
            }
        }

        public Object getUID() {
            return this.uid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean skipToNext() {
            assert (Thread.holdsLock(NFLPriorityFifoSet.this.lock));
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                nSetEntry se;
                if (this.currentEntry != null) {
                    if (!this.currentEntry.isValid()) {
                        this.nextEntry = (nSetEntry)this.currentEntry.getNext();
                        this.currentEntry = null;
                    } else {
                        return true;
                    }
                }
                if (this.nextEntry == null) {
                    return false;
                }
                for (se = this.nextEntry; se != null && !se.isValid(); se = (nSetEntry)se.getNext()) {
                }
                while (se != null && this.f != null && !this.f.matches(se.getData())) {
                    this.currentPriority = se.getPriority();
                    se = (nSetEntry)se.getNext();
                }
                this.currentEntry = se;
                this.nextEntry = null;
                if (this.currentEntry != null) {
                    this.currentPriority = this.currentEntry.getPriority();
                }
                return this.currentEntry != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void removeItem(E o) {
            assert (Thread.holdsLock(NFLPriorityFifoSet.this.lock));
            assert (o != null);
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                if (this.nextEntry != null && this.nextEntry.getData() == o) {
                    this.nextEntry = (nSetEntry)this.nextEntry.getNext();
                }
                if (this.currentEntry != null && this.currentEntry.getData() == o) {
                    this.nextEntry = (nSetEntry)this.currentEntry.getNext();
                    this.currentEntry = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addItem(E o) {
            assert (Thread.holdsLock(NFLPriorityFifoSet.this.lock));
            nSetEntry pe = (nSetEntry)NFLPriorityFifoSet.this.lookup.get(o);
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                if (this.currentEntry == null && this.nextEntry == null) {
                    this.nextEntry = pe;
                    this.currentPriority = pe.priority;
                } else if (pe.getPriority() == this.currentPriority && (this.currentEntry != null && !this.currentEntry.isValid() || this.nextEntry != null && !this.nextEntry.isValid())) {
                    this.nextEntry = pe;
                    this.currentEntry = null;
                } else if (pe.getPriority() < this.currentPriority) {
                    this.currentPriority = pe.getPriority();
                    this.nextEntry = pe;
                    this.currentEntry = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addItem(E o, boolean toFront) {
            assert (NFLPriorityFifoSet.this.lock == null || Thread.holdsLock(NFLPriorityFifoSet.this.lock));
            nSetEntry pe = (nSetEntry)NFLPriorityFifoSet.this.lookup.get(o);
            if (toFront) {
                Object object = NFLPriorityFifoSet.this.lock;
                synchronized (object) {
                    this.nextEntry = pe;
                    this.currentEntry = null;
                    this.currentPriority = 0;
                }
            } else {
                this.addItem(o);
            }
        }

        @Override
        public boolean add(E o) {
            return this.add(o, null);
        }

        @Override
        public boolean add(int p, E o) {
            return this.add(p, o, null);
        }

        @Override
        public boolean add(E o, Reason r) {
            if (this.f != null && !this.f.matches(o)) {
                throw new IllegalArgumentException("not part of set");
            }
            return NFLPriorityFifoSet.this.add(o, r);
        }

        public boolean add(int p, E o, Reason r) {
            if (this.f != null && !this.f.matches(o)) {
                throw new IllegalArgumentException("not part of set");
            }
            return NFLPriorityFifoSet.this.add(p, o, r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            HashSet s = new HashSet();
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                Iterator itr = this.iterator();
                while (itr.hasNext()) {
                    s.add(itr.next());
                }
            }
            this.removeAll(s);
        }

        @Override
        public boolean remove(Object o) {
            return this.remove(o, null);
        }

        @Override
        public boolean remove(E o, Reason r) {
            if (this.f != null && !this.f.matches(o)) {
                return false;
            }
            return NFLPriorityFifoSet.this.remove(o, r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                nSetEntry pse = (nSetEntry)NFLPriorityFifoSet.this.lookup.get(o);
                if (pse == null) {
                    return false;
                }
                if (this.f == null) {
                    return true;
                }
                return this.f.matches(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                int cnt = 0;
                Iterator itr = this.iterator();
                while (itr.hasNext()) {
                    itr.next();
                    ++cnt;
                }
                return cnt;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            HashSet s = new HashSet();
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                for (Object o : NFLPriorityFifoSet.this) {
                    if (c.contains(o)) continue;
                    s.add(o);
                }
            }
            return NFLPriorityFifoSet.this.removeAll(s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                boolean state = !this.skipToNext();
                return state;
            }
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return NFLPriorityFifoSet.this.removeAll(c);
        }

        @Override
        public void destroy() {
            NFLPriorityFifoSet.this.destroyFilterSet(this.uid);
        }

        @Override
        public Iterator<E> iterator() {
            return new filterIterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E removeNext() {
            Object currentData = null;
            NotifyInfo ni = null;
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                if (!this.skipToNext()) {
                    return null;
                }
                if (this.currentEntry == null) {
                    if (DEBUG && this.f == null && this.nextEntry == null && NFLPriorityFifoSet.this.lookup.size() != 0) {
                        throw new RuntimeException("Corruption noticed in removeNext  lookup.size is not 0 " + NFLPriorityFifoSet.this.lookup);
                    }
                    return null;
                }
                currentData = this.currentEntry.getData();
                this.nextEntry = (nSetEntry)this.currentEntry.getNext();
                this.currentEntry = null;
                ni = NFLPriorityFifoSet.this.internalRemove(currentData, null, null, NFLPriorityFifoSet.this.hasListeners());
                if (DEBUG && this.f == null && this.currentEntry == null && this.nextEntry == null && !NFLPriorityFifoSet.this.lookup.isEmpty()) {
                    throw new RuntimeException("Corruption noticed in removeNext  lookup.size is not 0 " + NFLPriorityFifoSet.this.lookup);
                }
            }
            NFLPriorityFifoSet.this.preRemoveNotify(currentData, null);
            if (ni != null) {
                NFLPriorityFifoSet.this.postRemoveNotify(currentData, ni, null);
            }
            return currentData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E peekNext() {
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                if (!this.skipToNext()) {
                    return null;
                }
                if (this.currentEntry == null) {
                    return null;
                }
                return this.currentEntry.getData();
            }
        }

        @Override
        public Object addEventListener(EventListener listener, EventType type, Object userData) {
            if (type != EventType.EMPTY) {
                throw new UnsupportedOperationException("Event " + type + " not supported");
            }
            return this.ebh.addEventListener(listener, type, userData);
        }

        @Override
        public Object addEventListener(EventListener listener, EventType type, Reason r, Object userData) {
            if (type != EventType.EMPTY) {
                throw new UnsupportedOperationException("Event " + type + " not supported");
            }
            return this.ebh.addEventListener(listener, type, r, userData);
        }

        @Override
        public Object removeEventListener(Object id) {
            return this.ebh.removeEventListener(id);
        }

        public void notifyEmptyChanged(boolean empty, Reason r) {
            if (this.ebh.hasListeners(EventType.EMPTY)) {
                this.ebh.notifyChange(EventType.EMPTY, r, this, empty ? Boolean.TRUE : Boolean.FALSE, empty ? Boolean.FALSE : Boolean.TRUE);
            }
        }

        class filterIterator
        implements Iterator<E> {
            nSetEntry current = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            filterIterator() {
                Object object = NFLPriorityFifoSet.this.lock;
                synchronized (object) {
                    this.current = FilterSet.this.currentEntry;
                    if (this.current == null) {
                        this.current = FilterSet.this.nextEntry;
                        this.findNext();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            void findNext() {
                Object object = NFLPriorityFifoSet.this.lock;
                synchronized (object) {
                    while (this.current != null && (!this.current.isValid() || FilterSet.this.f != null && !FilterSet.this.f.matches(this.current.getData()))) {
                        this.current = (nSetEntry)this.current.getNext();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasNext() {
                Object object = NFLPriorityFifoSet.this.lock;
                synchronized (object) {
                    return this.current != null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public E next() {
                Object object = NFLPriorityFifoSet.this.lock;
                synchronized (object) {
                    Object n = this.current.getData();
                    this.current = (nSetEntry)this.current.getNext();
                    this.findNext();
                    return n;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove is not supported on this iterator");
            }
        }
    }

    static class ComparatorSet<C>
    extends TreeSet<C>
    implements SubSet<C> {
        private static final long serialVersionUID = -2212313455661614252L;
        transient EventBroadcastHelper ebh = new EventBroadcastHelper();
        Object uid;
        transient NFLPriorityFifoSet<C> parent = null;

        ComparatorSet(Object uid, Comparator<? super C> c, NFLPriorityFifoSet<C> p) {
            super(c);
            this.uid = uid;
            this.parent = p;
        }

        @Override
        public String toDebugString() {
            return "ComparatorSet [" + this.comparator() + "]" + this.parent.toDebugString();
        }

        @Override
        public void destroy() {
            this.parent.destroyComparatorSet(this.uid);
        }

        void addItem(C o) {
            super.add(o);
        }

        void removeItem(C o) {
            super.remove(o);
        }

        @Override
        public boolean add(C o) {
            return this.add(o, (Reason)null);
        }

        @Override
        public boolean add(C o, Reason r) {
            boolean ok = super.add(o);
            this.parent.add(o, r);
            return ok;
        }

        @Override
        public boolean remove(Object o) {
            return this.remove((C)o, (Reason)null);
        }

        @Override
        public boolean remove(C o, Reason r) {
            boolean ok = super.remove(o);
            this.parent.remove(o, r);
            return ok;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public C removeNext() {
            C o = null;
            Object object = this.parent.lock;
            synchronized (object) {
                o = (C)this.first();
            }
            if (o != null) {
                this.parent.remove(o);
            }
            return o;
        }

        @Override
        public C peekNext() {
            return (C)this.first();
        }

        public Object getUID() {
            return this.uid;
        }

        @Override
        public Object addEventListener(EventListener listener, EventType type, Object userData) {
            if (type != EventType.EMPTY) {
                throw new UnsupportedOperationException("Event " + type + " not supported");
            }
            return this.ebh.addEventListener(listener, type, userData);
        }

        @Override
        public Object addEventListener(EventListener listener, EventType type, Reason r, Object userData) {
            if (type != EventType.EMPTY) {
                throw new UnsupportedOperationException("Event " + type + " not supported");
            }
            return this.ebh.addEventListener(listener, type, r, userData);
        }

        @Override
        public Object removeEventListener(Object id) {
            return this.ebh.removeEventListener(id);
        }

        public void notifyEmptyChanged(boolean empty, Reason r) {
            if (this.ebh.hasListeners(EventType.EMPTY)) {
                this.ebh.notifyChange(EventType.EMPTY, r, this, empty ? Boolean.TRUE : Boolean.FALSE, empty ? Boolean.FALSE : Boolean.TRUE);
            }
        }
    }

    static class NotifyInfo {
        long oldbytes = 0L;
        long newbytes = 0L;
        int oldsize = 0;
        int newsize = 0;
        long objsize = 0L;
        int curMaxCapacity = 0;
        long curMaxBytesCapacity = 0L;
        EmptyChanged[] filters = new EmptyChanged[0];

        NotifyInfo() {
        }

        public String toString() {
            StringBuilder str = new StringBuilder();
            str.append("NotifyInfo:");
            for (int i = 0; i < this.filters.length; ++i) {
                str.append('[').append(i).append(']').append(this.filters[i]);
            }
            return str.toString();
        }
    }

    static class EmptyChanged {
        SubSet f;
        boolean isEmpty = false;

        EmptyChanged() {
        }

        public String toString() {
            return "EmptyChanged:isEmpty=" + this.isEmpty + "f={" + (this.f == null ? "null" : this.f.toString()) + "}";
        }
    }

    class nSetEntry
    extends PrioritySetEntry<E> {
        long uid;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        nSetEntry(E o, int p) {
            super(o, p);
            this.uid = 0L;
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                this.uid = NFLPriorityFifoSet.this.currentID++;
            }
        }

        public long getUID() {
            return this.uid;
        }

        @Override
        public boolean remove() {
            assert (Thread.holdsLock(NFLPriorityFifoSet.this.lock));
            Object data = this.getData();
            assert (this.isValid());
            this.valid = false;
            boolean ok = super.remove();
            if (data instanceof Sized) {
                long removedBytes = ((Sized)data).byteSize();
                NFLPriorityFifoSet.this.bytes -= removedBytes;
            }
            NFLPriorityFifoSet.this.averageCount = ((float)NFLPriorityFifoSet.this.numberSamples * NFLPriorityFifoSet.this.averageCount + (float)NFLPriorityFifoSet.this.size()) / ((float)NFLPriorityFifoSet.this.numberSamples + 1.0f);
            NFLPriorityFifoSet.this.averageBytes = ((double)NFLPriorityFifoSet.this.numberSamples * NFLPriorityFifoSet.this.averageBytes + (double)NFLPriorityFifoSet.this.bytes) / ((double)NFLPriorityFifoSet.this.numberSamples + 1.0);
            ++NFLPriorityFifoSet.this.numberSamples;
            return ok;
        }
    }

    class wrapIterator
    implements Iterator<E> {
        Iterator<E> parentIterator;
        E next = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        wrapIterator(Iterator<E> itr) {
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                this.parentIterator = itr;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                return this.parentIterator.hasNext();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            Object object = NFLPriorityFifoSet.this.lock;
            synchronized (object) {
                this.next = this.parentIterator.next();
                return this.next;
            }
        }

        @Override
        public void remove() {
            NFLPriorityFifoSet.this.preRemoveNotify(this.next, null);
            NotifyInfo ni = NFLPriorityFifoSet.this.internalRemove(this.next, null, this.parentIterator, NFLPriorityFifoSet.this.hasListeners());
            if (ni != null) {
                NFLPriorityFifoSet.this.postRemoveNotify(this.next, ni, null);
            }
            this.next = null;
        }
    }
}

