/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.JMQByteBufferInputStream;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.io.disk.VRFile;
import com.sun.messaging.jmq.io.disk.VRFileRAF;
import com.sun.messaging.jmq.io.disk.VRecordRAF;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class MessageInfo {
    private static boolean DEBUG = false;
    static final short PENDING = -1;
    static final short DONE = 0;
    private static final int INT_SIZE = 4;
    private static final int LONG_SIZE = 8;
    private static final int ENTRY_SIZE = 12;
    private Logger logger = Globals.getLogger();
    private BrokerResources br = Globals.getBrokerResources();
    private Packet msg;
    private WeakReference msgBytes = null;
    private SysMessageID mid;
    private int packetSize;
    private DstMsgStore parent = null;
    private VRecordRAF vrecord = null;
    private HashMap iidMap = null;
    private int[] statearray = null;

    MessageInfo(DstMsgStore p, byte[] data, byte[] ilist) throws IOException {
        this.parent = p;
        try {
            Packet pkt;
            this.msg = pkt = this.parseMessage(data);
            this.mid = (SysMessageID)pkt.getSysMessageID().clone();
            this.parseInterestList(ilist);
        }
        catch (IOException e) {
            this.logger.log(32, this.parent.myDestination + ":failed to parse message from byte array", e);
            throw e;
        }
    }

    MessageInfo(DstMsgStore p, VRecordRAF r) throws IOException {
        this.parent = p;
        this.vrecord = r;
        try {
            Packet pkt;
            this.msg = pkt = this.parseMessage(r);
            this.mid = (SysMessageID)pkt.getSysMessageID().clone();
            this.parseInterestList(r);
        }
        catch (IOException e) {
            this.parent.getVRFile().free(this.vrecord);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MessageInfo(DstMsgStore p, VRFileRAF vrfile, Packet message, ConsumerUID[] iids, int[] states, boolean sync) throws IOException {
        this.parent = p;
        this.mid = (SysMessageID)message.getSysMessageID().clone();
        this.packetSize = message.getPacketSize();
        int bufsize = 4 + this.packetSize + 4 + iids.length * 12;
        if (sync && (Store.getDEBUG_SYNC() || DEBUG)) {
            Globals.getLogger().log(8, "sync new MessageInfo " + this.mid + " with VRFileRAF[" + vrfile + "]");
        }
        if (!Globals.isMinimumWritesFileStore()) {
            VRFileRAF vRFileRAF = vrfile;
            synchronized (vRFileRAF) {
                this.vrecord = (VRecordRAF)vrfile.allocate(bufsize);
                this.vrecord.setCookie((short)-1);
                this.vrecord.writeInt(this.packetSize);
                if (DstMsgStore.useFileChannel) {
                    message.writePacket(this.vrecord.getChannel(), false);
                } else {
                    byte[] databuf = message.getBytes();
                    this.vrecord.write(databuf);
                    if (Globals.txnLogEnabled()) {
                        this.msgBytes = new WeakReference<byte[]>(databuf);
                    }
                }
                this.storeStatesInternal(this.vrecord, iids, states);
                this.vrecord.setCookie((short)0);
                if (sync) {
                    if (Store.getDEBUG_SYNC() || DEBUG) {
                        Globals.getLogger().log(8, "sync storeMessage mid=" + this.mid);
                    }
                    this.vrecord.force();
                }
            }
        }
        VRFileRAF vRFileRAF = vrfile;
        synchronized (vRFileRAF) {
            ByteBuffer bbuf = ByteBuffer.allocate(bufsize + 4);
            bbuf.putShort((short)2);
            bbuf.putShort((short)0);
            bbuf.putInt(this.packetSize);
            byte[] databuf = message.getBytes();
            bbuf.put(databuf);
            if (Globals.txnLogEnabled()) {
                this.msgBytes = new WeakReference<byte[]>(databuf);
            }
            ByteBuffer buf = this.serializeStates(iids, states);
            buf.rewind();
            bbuf.put(buf);
            byte[] data = bbuf.array();
            this.vrecord = (VRecordRAF)vrfile.allocateAndWrite(bufsize, data);
            if (sync) {
                if (Store.getDEBUG_SYNC() || DEBUG) {
                    Globals.getLogger().log(8, "sync storeMessage mid=" + this.mid);
                }
                this.vrecord.force();
            }
        }
    }

    MessageInfo(DstMsgStore p, Packet msg, ConsumerUID[] iids, int[] states, boolean sync) throws IOException {
        this.parent = p;
        this.mid = (SysMessageID)msg.getSysMessageID().clone();
        this.packetSize = msg.getPacketSize();
        ByteBuffer bbuf = this.serializeStates(iids, states);
        bbuf.rewind();
        if (sync && (Store.getDEBUG_SYNC() || DEBUG)) {
            String logmsg = "sync new MessageInfo msg id " + this.mid + " with individual files";
            Globals.getLogger().log(8, logmsg);
        }
        if (DstMsgStore.useFileChannel) {
            RandomAccessFile raf = this.parent.getRAF(this.mid);
            DstMsgStore.markWriting(raf);
            raf.writeLong(this.packetSize);
            msg.writePacket(raf.getChannel(), false);
            long endofdata = raf.getFilePointer();
            raf.writeLong(bbuf.remaining());
            raf.getChannel().write(bbuf);
            long endoffile = raf.getFilePointer();
            DstMsgStore.markGood(raf);
            if (sync) {
                raf.getChannel().force(false);
            }
            this.parent.releaseRAF(this.mid, raf, endofdata, endoffile);
        } else {
            byte[] attachment = bbuf.array();
            byte[] databuf = msg.getBytes();
            if (Globals.txnLogEnabled()) {
                this.msgBytes = new WeakReference<byte[]>(databuf);
            }
            this.parent.writeData(this.mid, databuf, attachment, sync);
        }
    }

    synchronized Packet getMessage() throws IOException {
        if (this.msg == null) {
            if (this.vrecord != null) {
                try {
                    return this.parseMessage(this.vrecord);
                }
                catch (IOException e) {
                    this.logger.log(32, this.parent.myDestination + ":failed to parse message from vrecord(" + this.vrecord + ")", e);
                    throw e;
                }
            }
            try {
                byte[] data = this.parent.loadData(this.mid);
                return this.parseMessage(data);
            }
            catch (IOException e) {
                this.logger.log(32, this.parent.myDestination + ":failed to parse message from byte array", e);
                throw e;
            }
        }
        Packet pkt = this.msg;
        this.msg = null;
        return pkt;
    }

    byte[] getCachedMessageBytes() {
        byte[] data = null;
        if (this.msgBytes != null) {
            data = (byte[])this.msgBytes.get();
            this.msgBytes = null;
        }
        return data;
    }

    int getSize() {
        return this.packetSize;
    }

    synchronized SysMessageID getID() {
        return this.mid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(boolean sync) throws IOException {
        if (sync && (Store.getDEBUG_SYNC() || DEBUG)) {
            String msg = "sync free msg " + this.getID();
            Globals.getLogger().log(8, msg);
        }
        VRFileRAF vrfile = null;
        MessageInfo messageInfo = this;
        synchronized (messageInfo) {
            if (this.vrecord != null) {
                vrfile = this.parent.getVRFile();
                vrfile.free(this.vrecord);
                this.vrecord = null;
            } else {
                this.parent.removeData(this.mid, sync);
            }
            this.mid = null;
            this.statearray = null;
            if (this.iidMap != null) {
                this.iidMap.clear();
                this.iidMap = null;
            }
        }
        if (sync && vrfile != null) {
            ((VRFile)vrfile).force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeStates(ConsumerUID[] iids, int[] states, boolean sync) throws IOException, BrokerException {
        VRecordRAF myvrec = null;
        MessageInfo messageInfo = this;
        synchronized (messageInfo) {
            if (!this.iidMap.isEmpty()) {
                this.logger.log(16, "B3084", this.mid.toString());
                throw new BrokerException(this.br.getString("B3084", this.mid.toString()));
            }
            if (this.vrecord != null) {
                VRFileRAF vrfile;
                myvrec = this.vrecord;
                int total = 4 + this.packetSize + 4 + iids.length * 12;
                VRFileRAF vRFileRAF = vrfile = this.parent.getVRFile();
                synchronized (vRFileRAF) {
                    if (this.vrecord.getDataCapacity() < total) {
                        this.vrecord.rewind();
                        byte[] data = new byte[4 + this.packetSize];
                        this.vrecord.read(data);
                        VRecordRAF newrecord = (VRecordRAF)vrfile.allocate(total);
                        newrecord.write(data);
                        vrfile.free(this.vrecord);
                        this.vrecord = newrecord;
                    }
                    this.storeStatesInternal(this.vrecord, iids, states);
                }
            } else {
                byte[] data = this.serializeStates(iids, states).array();
                if (Store.getDEBUG_SYNC() || DEBUG) {
                    String msg = "MessageInfo storeState writeAttachment with sync " + this.mid;
                    this.logger.log(8, msg);
                }
                if (!this.parent.writeAttachment(this.mid, data, sync)) {
                    this.iidMap = null;
                    this.statearray = null;
                    this.logger.log(32, "B3007", (Object)this.mid, this.parent.myDestination);
                    throw new BrokerException(this.br.getString("B3007", this.mid, this.parent.myDestination));
                }
            }
        }
        if (myvrec != null && sync) {
            if (Store.getDEBUG_SYNC() || DEBUG) {
                Globals.getLogger().log(8, "sync storeStates mid=" + this.getID());
            }
            myvrec.force();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateState(ConsumerUID iid, int state, boolean sync) throws IOException, BrokerException {
        VRecordRAF myvrec = null;
        MessageInfo messageInfo = this;
        synchronized (messageInfo) {
            Integer indexObj = null;
            if (this.iidMap == null || (indexObj = (Integer)this.iidMap.get(iid)) == null) {
                this.logger.log(32, "B3014", (Object)iid.toString(), this.mid.toString());
                throw new BrokerException(this.br.getString("B3014", iid.toString(), this.mid.toString()));
            }
            int index = indexObj;
            if (this.statearray[index] != state) {
                this.statearray[index] = state;
                if (state == 1 && Globals.isDeliveryStateNotPersisted()) {
                    return;
                }
                if (this.vrecord != null) {
                    myvrec = this.vrecord;
                    long offset = 4 + this.packetSize + 4 + index * 12 + 8;
                    this.vrecord.writeInt((int)offset, state);
                } else {
                    long offset = 4 + index * 12 + 8;
                    if (!this.parent.writeAttachmentData(this.mid, offset, state, sync)) {
                        this.logger.log(32, "B3007", (Object)this.mid, this.parent.myDestination);
                        throw new BrokerException(this.br.getString("B3007", this.mid, this.parent.myDestination));
                    }
                }
            }
        }
        if (myvrec != null && sync) {
            if (Store.getDEBUG_SYNC() || DEBUG) {
                String msg = "MessageInfo updateState sync called for msg id " + this.getID() + "consumer " + iid;
                Globals.getLogger().log(8, msg);
            }
            myvrec.force();
        }
    }

    synchronized int getInterestState(ConsumerUID iid) throws BrokerException {
        Integer indexobj = null;
        if (this.iidMap == null || (indexobj = (Integer)this.iidMap.get(iid)) == null) {
            this.logger.log(32, "B3014", (Object)iid.toString(), this.mid.toString());
            throw new BrokerException(this.br.getString("B3014", iid.toString(), this.mid.toString()));
        }
        return this.statearray[indexobj];
    }

    synchronized HashMap getInterestStates() {
        HashMap states = new HashMap();
        if (this.iidMap != null) {
            Set entries = this.iidMap.entrySet();
            for (Map.Entry entry : entries) {
                int index = (Integer)entry.getValue();
                states.put(entry.getKey(), this.statearray[index]);
            }
        }
        return states;
    }

    synchronized ConsumerUID[] getConsumerUIDs() {
        ConsumerUID[] ids = new ConsumerUID[]{};
        if (this.iidMap != null) {
            ArrayList list = new ArrayList();
            Set entries = this.iidMap.entrySet();
            for (Map.Entry entry : entries) {
                Integer index = (Integer)entry.getValue();
                if (this.statearray[index] == 2) continue;
                list.add(entry.getKey());
            }
            ids = list.toArray(ids);
        }
        return ids;
    }

    synchronized boolean hasMessageBeenAck() {
        if (this.statearray != null && this.statearray.length > 0) {
            int len = this.statearray.length;
            for (int i = 0; i < len; ++i) {
                if (this.statearray[i] == 2) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void parseInterestList(VRecordRAF r) throws IOException {
        int size = 0;
        try {
            r.position(4 + this.packetSize);
            size = r.readInt();
            long endofrec = (long)(4 + this.packetSize + 4) + (long)size * 12L;
            if (endofrec > (long)r.getDataCapacity()) {
                throw new Exception("size of interest list is corrupted");
            }
            this.iidMap = new HashMap(size);
            this.statearray = new int[size];
            for (int i = 0; i < size; ++i) {
                ConsumerUID iid = new ConsumerUID(r.readLong());
                this.statearray[i] = r.readInt();
                this.iidMap.put(iid, i);
            }
            if (Store.getDEBUG() && DEBUG) {
                this.logger.log(8, "loaded " + size + " interest states");
            }
        }
        catch (Throwable t) {
            this.logger.log(32, "failed to parse interest list(size=" + size + ") for msg(size=" + this.packetSize + ") from vrecord(" + r + ")", t);
            IOException e = new IOException(t.toString());
            e.setStackTrace(t.getStackTrace());
            throw e;
        }
    }

    private void parseInterestList(byte[] buf) throws IOException {
        if (buf == null || buf.length == 0) {
            if (Store.getDEBUG() && DEBUG) {
                this.logger.log(8, "No interest list to load");
            }
            return;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(bis);
        int size = dis.readInt();
        this.iidMap = new HashMap(size);
        this.statearray = new int[size];
        for (int i = 0; i < size; ++i) {
            ConsumerUID iid = new ConsumerUID(dis.readLong());
            this.statearray[i] = dis.readInt();
            this.iidMap.put(iid, i);
        }
        dis.close();
        bis.close();
        if (Store.getDEBUG() && DEBUG) {
            this.logger.log(8, "loaded " + size + " interest states");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet parseMessage(byte[] data) throws IOException {
        this.packetSize = data.length;
        ByteBuffer databuf = ByteBuffer.wrap(data);
        try (JMQByteBufferInputStream bis = new JMQByteBufferInputStream(databuf);){
            Packet msg = new Packet(false);
            msg.generateTimestamp(false);
            msg.generateSequenceNumber(false);
            msg.readPacket(bis);
            Packet packet = msg;
            return packet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Packet parseMessage(VRecordRAF r) throws IOException {
        try {
            r.rewind();
            this.packetSize = r.readInt();
            Packet pkt = new Packet();
            pkt.generateTimestamp(false);
            pkt.generateSequenceNumber(false);
            if (DstMsgStore.useFileChannel) {
                pkt.readPacket(r.getChannel(), false);
            } else {
                ByteBuffer buf = ByteBuffer.wrap(new byte[this.packetSize]);
                r.read(buf.array());
                try (JMQByteBufferInputStream bis = new JMQByteBufferInputStream(buf);){
                    pkt.readPacket(bis);
                }
            }
            return pkt;
        }
        catch (Throwable t) {
            this.logger.log(32, this.parent.myDestination + ":failed to parse message(size=" + this.packetSize + ") from vrecord(" + r + ")", t);
            IOException e = new IOException(t.toString());
            e.setStackTrace(t.getStackTrace());
            throw e;
        }
    }

    private void storeStatesInternal(VRecordRAF rec, ConsumerUID[] iids, int[] states) throws IOException {
        ByteBuffer buf = this.serializeStates(iids, states);
        buf.rewind();
        rec.position(4 + this.packetSize);
        rec.write(buf);
    }

    private ByteBuffer serializeStates(ConsumerUID[] iids, int[] states) {
        int size = iids.length;
        this.iidMap = new HashMap(size);
        int buflen = 4 + size * 12;
        ByteBuffer buf = ByteBuffer.wrap(new byte[buflen]);
        buf.putInt(size);
        this.statearray = Arrays.copyOf(states, size);
        for (int i = 0; i < size; ++i) {
            buf.putLong(iids[i].longValue());
            buf.putInt(states[i]);
            this.iidMap.put(iids[i], i);
        }
        return buf;
    }
}

