/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.date;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Locale;
import java.util.TimeZone;

public class Dates {
    public static final ZoneId UTC_ZONE_ID = ZoneId.of("UTC");
    public static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    public static final DateTimeFormatter RFC_7231_DATE_TIME = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH).withZone(ZoneId.of("GMT"));
    private static final DateTimeFormatter DATE_TOSTRING_DEFAULT_LOCALE = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss z yyyy");
    public static final DateTimeFormatter DATE_TOSTRING = DATE_TOSTRING_DEFAULT_LOCALE.withLocale(Locale.ROOT);
    private static final DateTimeFormatter[] DATE_TIME_FORMATTERS = new DateTimeFormatter[]{DateTimeFormatter.ofPattern("yyyyMMddHHmmss.SSSZ", Locale.ROOT), DateTimeFormatter.ISO_OFFSET_DATE.withLocale(Locale.ROOT), DateTimeFormatter.ISO_LOCAL_DATE_TIME.withLocale(Locale.ROOT), DateTimeFormatter.ISO_LOCAL_DATE.withLocale(Locale.ROOT), DateTimeFormatter.ISO_OFFSET_DATE_TIME.withLocale(Locale.ROOT), DateTimeFormatter.ISO_ORDINAL_DATE.withLocale(Locale.ROOT), DateTimeFormatter.ISO_ZONED_DATE_TIME.withLocale(Locale.ROOT), DateTimeFormatter.ISO_WEEK_DATE.withLocale(Locale.ROOT), RFC_7231_DATE_TIME, DateTimeFormatter.RFC_1123_DATE_TIME.withLocale(Locale.ROOT), DATE_TOSTRING, DATE_TOSTRING_DEFAULT_LOCALE, DateTimeFormatter.ofPattern("yyyy[-][/][ ]MM[-][/][ ]dd[ ][HH[:]mm[[:]ss][.SSS]][X]", Locale.ROOT), DateTimeFormatter.ofPattern("dd[-][/][ ]MM[-][/][ ]yyyy[ HH[:]mm[[:]ss[.SSS]][X]", Locale.ROOT), DateTimeFormatter.ofPattern("dd[-][/][ ]MMM[-][/][ ]yyyy[ HH[:]mm[[:]ss[.SSS]][X]", Locale.ROOT), DateTimeFormatter.ofPattern("dd[-][/][ ]MMMM[-][/][ ]yyyy[ HH[:]mm[[:]ss[.SSS]][X]", Locale.US), DateTimeFormatter.ofPattern("yyyyMMdd[X]", Locale.ROOT), DateTimeFormatter.ofPattern("yyyyMMddHHmm[X]", Locale.ROOT), DateTimeFormatter.ofPattern("yyyyMMdd[ ][/][-]HHmm[X]", Locale.ROOT), DateTimeFormatter.ofPattern("yyyyMMddHHmmss[.SSS][X]", Locale.ROOT), DateTimeFormatter.ofPattern("yyyyMMdd[ ][/][-]HHmmss[.SSS][X]", Locale.ROOT)};

    private Dates() {
    }

    public static ZonedDateTime parse(String dateString) {
        for (DateTimeFormatter df : DATE_TIME_FORMATTERS) {
            try {
                return Dates.toZonedDateTime(df.parse(dateString));
            }
            catch (DateTimeParseException dte) {
            }
        }
        try {
            long epochMilli = Long.parseLong(dateString);
            return Dates.toZonedDateTime(epochMilli);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static ZonedDateTime toZonedDateTime(TemporalAccessor temporal) {
        if (temporal instanceof ZonedDateTime) {
            return (ZonedDateTime)temporal;
        }
        LocalDate date = temporal.query(TemporalQueries.localDate());
        LocalTime time = temporal.query(TemporalQueries.localTime());
        ZoneId zone = temporal.query(TemporalQueries.zone());
        return Dates.toZonedDateTime(date, time, zone);
    }

    public static ZonedDateTime toZonedDateTime(LocalDate date, LocalTime time, ZoneId zone) {
        if (date == null) {
            date = LocalDate.now();
        }
        if (time == null) {
            time = LocalTime.MIN;
        }
        if (zone == null) {
            zone = UTC_ZONE_ID;
        }
        return ZonedDateTime.of(date, time, zone);
    }

    public static ZonedDateTime toZonedDateTime(long epochMilli) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMilli), UTC_ZONE_ID);
    }

    public static long parseMillis(DateTimeFormatter formatter, String time) {
        TemporalAccessor temporal = formatter.parse(time);
        return Dates.toZonedDateTime(temporal).toInstant().toEpochMilli();
    }

    public static String formatMillis(DateTimeFormatter formatter, long epochMilli) {
        Comparable<ChronoZonedDateTime<?>> temporal = formatter.getZone() == null ? Dates.toZonedDateTime(epochMilli) : Instant.ofEpochMilli(epochMilli);
        return formatter.format((TemporalAccessor)((Object)temporal));
    }
}

