/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BUTTON_IMAGELIST;
import org.eclipse.swt.internal.win32.DRAWITEMSTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TypedListener;

public class Button
extends Control {
    String text = "";
    String message = "";
    Image image;
    Image disabledImage;
    ImageList imageList;
    boolean ignoreMouse;
    boolean grayed;
    boolean useDarkModeExplorerTheme;
    static final int MARGIN = 4;
    static final int CHECK_WIDTH;
    static final int CHECK_HEIGHT;
    static final int ICON_WIDTH = 128;
    static final int ICON_HEIGHT = 128;
    static boolean COMMAND_LINK;
    static final char[] STRING_WITH_ZERO_CHAR;
    static final long ButtonProc;
    static final TCHAR ButtonClass;

    static {
        COMMAND_LINK = false;
        STRING_WITH_ZERO_CHAR = new char[]{'0'};
        ButtonClass = new TCHAR(0, "BUTTON", true);
        long hBitmap = OS.LoadBitmap(0L, 32759L);
        if (hBitmap == 0L) {
            CHECK_WIDTH = OS.GetSystemMetrics(2);
            CHECK_HEIGHT = OS.GetSystemMetrics(20);
        } else {
            BITMAP bitmap = new BITMAP();
            OS.GetObject(hBitmap, BITMAP.sizeof, bitmap);
            OS.DeleteObject(hBitmap);
            CHECK_WIDTH = bitmap.bmWidth / 4;
            CHECK_HEIGHT = bitmap.bmHeight / 3;
        }
        WNDCLASS lpWndClass = new WNDCLASS();
        OS.GetClassInfo(0L, ButtonClass, lpWndClass);
        ButtonProc = lpWndClass.lpfnWndProc;
    }

    public Button(Composite parent, int style) {
        super(parent, Button.checkStyle(style));
    }

    void _setImage(Image image) {
        if ((this.style & 0x400000) != 0) {
            return;
        }
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (image != null) {
            int oldBits;
            this.imageList = new ImageList(this.style & 0x4000000);
            if (OS.IsWindowEnabled(this.handle)) {
                this.imageList.add(image);
            } else {
                if (this.disabledImage != null) {
                    this.disabledImage.dispose();
                }
                this.disabledImage = new Image((Device)this.display, image, 1);
                this.imageList.add(this.disabledImage);
            }
            BUTTON_IMAGELIST buttonImageList = new BUTTON_IMAGELIST();
            buttonImageList.himl = this.imageList.getHandle();
            int newBits = oldBits = OS.GetWindowLong(this.handle, -16);
            newBits &= 0xFFFFFCFF;
            if ((this.style & 0x4000) != 0) {
                newBits |= 0x100;
            }
            if ((this.style & 0x1000000) != 0) {
                newBits |= 0x300;
            }
            if ((this.style & 0x20000) != 0) {
                newBits |= 0x200;
            }
            if (this.text.length() == 0) {
                if ((this.style & 0x4000) != 0) {
                    buttonImageList.uAlign = 0;
                }
                if ((this.style & 0x1000000) != 0) {
                    buttonImageList.uAlign = 4;
                }
                if ((this.style & 0x20000) != 0) {
                    buttonImageList.uAlign = 1;
                }
            } else {
                buttonImageList.uAlign = 0;
                buttonImageList.margin_left = this.computeLeftMargin();
                buttonImageList.margin_right = 4;
                newBits &= 0xFFFFFCFF;
                newBits |= 0x100;
            }
            if (newBits != oldBits) {
                OS.SetWindowLong(this.handle, -16, newBits);
                OS.InvalidateRect(this.handle, null, true);
            }
            OS.SendMessage(this.handle, 5634, 0L, buttonImageList);
        } else {
            OS.SendMessage(this.handle, 5634, 0L, 0L);
        }
        OS.InvalidateRect(this.handle, null, true);
    }

    void _setText(String text) {
        int oldBits;
        int newBits = oldBits = OS.GetWindowLong(this.handle, -16);
        newBits &= 0xFFFFFCFF;
        if ((this.style & 0x4000) != 0) {
            newBits |= 0x100;
        }
        if ((this.style & 0x1000000) != 0) {
            newBits |= 0x300;
        }
        if ((this.style & 0x20000) != 0) {
            newBits |= 0x200;
        }
        if (this.imageList != null) {
            BUTTON_IMAGELIST buttonImageList = new BUTTON_IMAGELIST();
            buttonImageList.himl = this.imageList.getHandle();
            if (text.length() == 0) {
                if ((this.style & 0x4000) != 0) {
                    buttonImageList.uAlign = 0;
                }
                if ((this.style & 0x1000000) != 0) {
                    buttonImageList.uAlign = 4;
                }
                if ((this.style & 0x20000) != 0) {
                    buttonImageList.uAlign = 1;
                }
            } else {
                buttonImageList.uAlign = 0;
                buttonImageList.margin_left = this.computeLeftMargin();
                buttonImageList.margin_right = 4;
                newBits &= 0xFFFFFCFF;
                newBits |= 0x100;
            }
            OS.SendMessage(this.handle, 5634, 0L, buttonImageList);
        }
        if (newBits != oldBits) {
            OS.SetWindowLong(this.handle, -16, newBits);
            OS.InvalidateRect(this.handle, null, true);
        }
        if ((this.style & 0x4000000) != 0 && !OS.IsAppThemed()) {
            text = OS.IsWindowEnabled(this.handle) ? text : String.valueOf(text) + " ";
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), text, true);
        OS.SetWindowText(this.handle, buffer);
        if ((this.state & 0x400000) != 0) {
            this.updateTextDirection(0x6000000);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    @Override
    long callWindowProc(long hwnd, int msg, long wParam, long lParam) {
        if (this.handle == 0L) {
            return 0L;
        }
        return OS.CallWindowProc(ButtonProc, hwnd, msg, wParam, lParam);
    }

    static int checkStyle(int style) {
        if (((style = Button.checkBits(style, 8, 4, 32, 16, 2, COMMAND_LINK ? 0x400000 : 0)) & 0xA) != 0) {
            return Button.checkBits(style, 0x1000000, 16384, 131072, 0, 0, 0);
        }
        if ((style & 0x30) != 0) {
            return Button.checkBits(style, 16384, 131072, 0x1000000, 0, 0, 0);
        }
        if ((style & 4) != 0) {
            return Button.checkBits(style |= 0x80000, 128, 1024, 16384, 131072, 0, 0);
        }
        return style;
    }

    void click() {
        this.ignoreMouse = true;
        OS.SendMessage(this.handle, 245, 0L, 0L);
        this.ignoreMouse = false;
    }

    int computeLeftMargin() {
        if ((this.style & 0xA) == 0) {
            return 4;
        }
        int margin = 0;
        if (this.image != null && this.text.length() != 0) {
            Rectangle bounds = this.image.getBoundsInPixels();
            margin += bounds.width + 8;
            long oldFont = 0L;
            long hDC = OS.GetDC(this.handle);
            long newFont = OS.SendMessage(this.handle, 49, 0L, 0L);
            if (newFont != 0L) {
                oldFont = OS.SelectObject(hDC, newFont);
            }
            char[] buffer = this.text.toCharArray();
            RECT rect = new RECT();
            int flags = 1056;
            OS.DrawText(hDC, buffer, buffer.length, rect, flags);
            margin += rect.right - rect.left;
            if (newFont != 0L) {
                OS.SelectObject(hDC, oldFont);
            }
            OS.ReleaseDC(this.handle, hDC);
            OS.GetClientRect(this.handle, rect);
            margin = Math.max(4, (rect.right - rect.left - margin) / 2);
        }
        return margin;
    }

    @Override
    Point computeSizeInPixels(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        int border = this.getBorderWidthInPixels();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x480) != 0) {
                width += OS.GetSystemMetrics(2);
                height += OS.GetSystemMetrics(20);
            } else {
                width += OS.GetSystemMetrics(21);
                height += OS.GetSystemMetrics(3);
            }
        } else if ((this.style & 0x400000) != 0) {
            SIZE size = new SIZE();
            if (wHint != -1) {
                size.cx = wHint;
                OS.SendMessage(this.handle, 5633, 0L, size);
                width = size.cx;
                height = size.cy;
            } else {
                OS.SendMessage(this.handle, 5633, 0L, size);
                width = size.cy;
                height = size.cy;
                size.cy = 0;
                while (size.cy != height) {
                    size.cx = width++;
                    size.cy = 0;
                    OS.SendMessage(this.handle, 5633, 0L, size);
                }
            }
        } else {
            int extra = 0;
            boolean hasImage = this.image != null;
            boolean hasText = true;
            if (hasImage && this.image != null) {
                Rectangle rect = this.image.getBoundsInPixels();
                width = rect.width;
                if (hasText && this.text.length() != 0) {
                    width += 8;
                }
                height = rect.height;
                extra = 8;
            }
            if (hasText) {
                long oldFont = 0L;
                long hDC = OS.GetDC(this.handle);
                long newFont = OS.SendMessage(this.handle, 49, 0L, 0L);
                if (newFont != 0L) {
                    oldFont = OS.SelectObject(hDC, newFont);
                }
                TEXTMETRIC lptm = new TEXTMETRIC();
                OS.GetTextMetrics(hDC, lptm);
                int length = this.text.length();
                if (length == 0) {
                    height = Math.max(height, lptm.tmHeight);
                } else {
                    extra = Math.max(8, lptm.tmAveCharWidth);
                    char[] buffer = this.text.toCharArray();
                    RECT rect = new RECT();
                    int flags = 1056;
                    if ((this.style & 0x40) != 0 && wHint != -1) {
                        flags = 1040;
                        rect.right = wHint - width - 2 * border;
                        rect.right = this.isRadioOrCheck() ? (rect.right -= CHECK_WIDTH + 3) : (rect.right -= 6);
                        if (!OS.IsAppThemed()) {
                            rect.right -= 2;
                            if (this.isRadioOrCheck()) {
                                rect.right -= 2;
                            }
                        }
                    }
                    OS.DrawText(hDC, buffer, buffer.length, rect, flags);
                    width += rect.right - rect.left;
                    height = Math.max(height, rect.bottom - rect.top);
                }
                if (newFont != 0L) {
                    OS.SelectObject(hDC, oldFont);
                }
                OS.ReleaseDC(this.handle, hDC);
            }
            if (this.isRadioOrCheck()) {
                width += CHECK_WIDTH + extra;
                height = Math.max(height, CHECK_HEIGHT + 3);
            }
            if ((this.style & 0xA) != 0) {
                width += 12;
                height += 10;
            }
        }
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        return new Point(width += border * 2, height += border * 2);
    }

    @Override
    void createHandle() {
        this.parent.state |= 0x100000;
        super.createHandle();
        this.parent.state &= 0xFFEFFFFF;
        if (OS.IsAppThemed()) {
            if ((this.style & 0xA) == 0) {
                this.state |= 0x100;
            }
            if ((this.style & 0x10) != 0) {
                this.state |= 0x200;
            }
            this.useDarkModeExplorerTheme = this.display.useDarkModeExplorerTheme;
            this.maybeEnableDarkSystemTheme();
        }
    }

    private boolean customBackgroundDrawing() {
        return this.background != -1 && !this.isRadioOrCheck();
    }

    private boolean customDrawing() {
        return this.customBackgroundDrawing() || this.customForegroundDrawing();
    }

    private boolean customForegroundDrawing() {
        return this.foreground != -1 && !this.text.isEmpty() && OS.IsWindowEnabled(this.handle);
    }

    @Override
    int defaultBackground() {
        if ((this.style & 0xA) != 0) {
            return OS.GetSysColor(15);
        }
        return super.defaultBackground();
    }

    @Override
    int defaultForeground() {
        return OS.GetSysColor(18);
    }

    @Override
    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        if ((this.style & 0x4000000) != 0 && !OS.IsAppThemed()) {
            boolean hasImage;
            int bits = OS.GetWindowLong(this.handle, -16);
            boolean bl = hasImage = (bits & 0xC0) != 0;
            if (!hasImage) {
                String string = enabled ? this.text : String.valueOf(this.text) + " ";
                TCHAR buffer = new TCHAR(this.getCodePage(), string, true);
                OS.SetWindowText(this.handle, buffer);
            }
        }
        this.updateImageList();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x80) != 0) {
                return 128;
            }
            if ((this.style & 0x400) != 0) {
                return 1024;
            }
            if ((this.style & 0x4000) != 0) {
                return 16384;
            }
            if ((this.style & 0x20000) != 0) {
                return 131072;
            }
            return 128;
        }
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    boolean getDefault() {
        if ((this.style & 8) == 0) {
            return false;
        }
        int bits = OS.GetWindowLong(this.handle, -16);
        return (bits & 1) != 0;
    }

    public boolean getGrayed() {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    String getMessage() {
        this.checkWidget();
        return this.message;
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return this.isChecked();
    }

    public String getText() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return "";
        }
        return this.text;
    }

    private boolean isChecked() {
        long flags = OS.SendMessage(this.handle, 240, 0L, 0L);
        return flags != 0L;
    }

    private boolean isRadioOrCheck() {
        return (this.style & 0x30) != 0;
    }

    @Override
    boolean isTabItem() {
        if ((this.style & 8) != 0) {
            return this.isTabGroup();
        }
        return super.isTabItem();
    }

    @Override
    boolean mnemonicHit(char ch) {
        if ((this.style & 0x10) == 0 && !this.setFocus()) {
            return false;
        }
        this.click();
        return true;
    }

    @Override
    boolean mnemonicMatch(char key) {
        char mnemonic = this.findMnemonic(this.getText());
        if (mnemonic == '\u0000') {
            return false;
        }
        return Character.toUpperCase(key) == Character.toUpperCase(mnemonic);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
        if (this.disabledImage != null) {
            this.disabledImage.dispose();
        }
        this.disabledImage = null;
        this.text = null;
        this.image = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    @Override
    int resolveTextDirection() {
        return (this.style & 4) != 0 ? 0 : BidiUtil.resolveTextDirection(this.text);
    }

    void selectRadio() {
        Control[] controlArray = this.parent._getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (this != child) {
                child.setRadioSelection(false);
            }
            ++n2;
        }
        this.setSelection(true);
    }

    public void setAlignment(int alignment) {
        int oldBits;
        this.checkWidget();
        if ((this.style & 4) != 0) {
            if ((this.style & 0x24480) == 0) {
                return;
            }
            this.style &= 0xFFFDBB7F;
            this.style |= alignment & 0x24480;
            OS.InvalidateRect(this.handle, null, true);
            return;
        }
        if ((alignment & 0x1024000) == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= alignment & 0x1024000;
        int newBits = oldBits = OS.GetWindowLong(this.handle, -16);
        newBits &= 0xFFFFFCFF;
        if ((this.style & 0x4000) != 0) {
            newBits |= 0x100;
        }
        if ((this.style & 0x1000000) != 0) {
            newBits |= 0x300;
        }
        if ((this.style & 0x20000) != 0) {
            newBits |= 0x200;
        }
        if (this.imageList != null) {
            BUTTON_IMAGELIST buttonImageList = new BUTTON_IMAGELIST();
            buttonImageList.himl = this.imageList.getHandle();
            if (this.text.length() == 0) {
                if ((this.style & 0x4000) != 0) {
                    buttonImageList.uAlign = 0;
                }
                if ((this.style & 0x1000000) != 0) {
                    buttonImageList.uAlign = 4;
                }
                if ((this.style & 0x20000) != 0) {
                    buttonImageList.uAlign = 1;
                }
            } else {
                buttonImageList.uAlign = 0;
                buttonImageList.margin_left = this.computeLeftMargin();
                buttonImageList.margin_right = 4;
                newBits &= 0xFFFFFCFF;
                newBits |= 0x100;
            }
            OS.SendMessage(this.handle, 5634, 0L, buttonImageList);
        }
        if (newBits != oldBits) {
            OS.SetWindowLong(this.handle, -16, newBits);
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
    }

    void setDefault(boolean value) {
        if ((this.style & 8) == 0) {
            return;
        }
        long hwndShell = this.menuShell().handle;
        int bits = OS.GetWindowLong(this.handle, -16);
        if (value) {
            bits |= 1;
            OS.SendMessage(hwndShell, 1025, this.handle, 0L);
        } else {
            bits &= 0xFFFFFFFE;
            OS.SendMessage(hwndShell, 1025, 0L, 0L);
        }
        OS.SendMessage(this.handle, 244, (long)bits, 1L);
    }

    @Override
    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x10) != 0 && !this.isChecked()) {
            return false;
        }
        return super.setFocus();
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.image = image;
        this._setImage(image);
    }

    public void setGrayed(boolean grayed) {
        this.checkWidget();
        if ((this.style & 0x20) == 0) {
            return;
        }
        this.grayed = grayed;
        long flags = OS.SendMessage(this.handle, 240, 0L, 0L);
        if (grayed) {
            if (flags == 1L) {
                this.updateSelection(2);
            }
        } else if (flags == 2L) {
            this.updateSelection(1);
        }
    }

    void setMessage(String message) {
        this.checkWidget();
        if (message == null) {
            this.error(4);
        }
        this.message = message;
        if ((this.style & 0x400000) != 0) {
            int length = message.length();
            char[] chars = new char[length + 1];
            message.getChars(0, length, chars, 0);
            OS.SendMessage(this.handle, 5641, 0L, chars);
        }
    }

    @Override
    boolean setRadioFocus(boolean tabbing) {
        if ((this.style & 0x10) == 0 || !this.getSelection()) {
            return false;
        }
        return tabbing ? this.setTabItemFocus() : this.setFocus();
    }

    @Override
    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        int flags;
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        int n = flags = selected ? 1 : 0;
        if ((this.style & 0x20) != 0 && selected && this.grayed) {
            flags = 2;
        }
        this.updateSelection(flags);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 4) != 0) {
            return;
        }
        this.text = string;
        this._setText(string);
    }

    @Override
    boolean updateTextDirection(int textDirection) {
        return super.updateTextDirection(textDirection);
    }

    void updateImageList() {
        if (this.imageList != null) {
            BUTTON_IMAGELIST buttonImageList = new BUTTON_IMAGELIST();
            OS.SendMessage(this.handle, 5635, 0L, buttonImageList);
            if (this.imageList != null) {
                this.imageList.dispose();
            }
            this.imageList = new ImageList(this.style & 0x4000000);
            if (OS.IsWindowEnabled(this.handle)) {
                this.imageList.add(this.image);
            } else {
                if (this.disabledImage != null) {
                    this.disabledImage.dispose();
                }
                this.disabledImage = new Image((Device)this.display, this.image, 1);
                this.imageList.add(this.disabledImage);
            }
            buttonImageList.himl = this.imageList.getHandle();
            OS.SendMessage(this.handle, 5634, 0L, buttonImageList);
            OS.InvalidateRect(this.handle, null, true);
        }
    }

    @Override
    void updateOrientation() {
        super.updateOrientation();
        this.updateImageList();
    }

    void updateSelection(int flags) {
        if ((long)flags != OS.SendMessage(this.handle, 240, 0L, 0L)) {
            int bits = OS.GetWindowLong(this.handle, -16);
            if ((this.style & 0x20) != 0) {
                if (flags == 2) {
                    bits &= 0xFFFFFFFD;
                    bits |= 5;
                } else {
                    bits |= 2;
                    bits &= 0xFFFFFFFA;
                }
                if (bits != OS.GetWindowLong(this.handle, -16)) {
                    OS.SetWindowLong(this.handle, -16, bits);
                }
            }
            OS.SendMessage(this.handle, 241, (long)flags, 0L);
            if (bits != OS.GetWindowLong(this.handle, -16)) {
                OS.SetWindowLong(this.handle, -16, bits);
            }
        }
    }

    @Override
    int widgetStyle() {
        int bits = super.widgetStyle();
        if ((this.style & 0x800000) != 0) {
            bits |= 0x8000;
        }
        if ((this.style & 4) != 0) {
            return bits | 0xB;
        }
        if ((this.style & 0x4000) != 0) {
            bits |= 0x100;
        }
        if ((this.style & 0x1000000) != 0) {
            bits |= 0x300;
        }
        if ((this.style & 0x20000) != 0) {
            bits |= 0x200;
        }
        if ((this.style & 0x40) != 0) {
            bits |= 0x2000;
        }
        if ((this.style & 8) != 0) {
            return bits | 0x10000;
        }
        if ((this.style & 0x20) != 0) {
            return bits | 2 | 0x10000;
        }
        if ((this.style & 0x10) != 0) {
            return bits | 4;
        }
        if ((this.style & 2) != 0) {
            return bits | 0x1000 | 2 | 0x10000;
        }
        if ((this.style & 0x400000) != 0) {
            return bits | 0xE | 0x10000;
        }
        return bits | 0x10000;
    }

    @Override
    TCHAR windowClass() {
        return ButtonClass;
    }

    @Override
    long windowProc() {
        return ButtonProc;
    }

    @Override
    LRESULT wmColorChild(long wParam, long lParam) {
        if (this.isRadioOrCheck()) {
            return super.wmColorChild(wParam, lParam);
        }
        return this.parent.wmColorChild(wParam, lParam);
    }

    @Override
    LRESULT WM_GETDLGCODE(long wParam, long lParam) {
        LRESULT result = super.WM_GETDLGCODE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 4) != 0) {
            return new LRESULT(256L);
        }
        return result;
    }

    @Override
    LRESULT WM_GETOBJECT(long wParam, long lParam) {
        if ((this.style & 0x10) != 0 && this.accessible == null) {
            this.accessible = this.new_Accessible(this);
        }
        return super.WM_GETOBJECT(wParam, lParam);
    }

    @Override
    LRESULT WM_KILLFOCUS(long wParam, long lParam) {
        LRESULT result = super.WM_KILLFOCUS(wParam, lParam);
        if ((this.style & 8) != 0 && this.getDefault()) {
            this.menuShell().setDefaultButton(null, false);
        }
        return result;
    }

    @Override
    LRESULT WM_LBUTTONDOWN(long wParam, long lParam) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONDOWN(wParam, lParam);
    }

    @Override
    LRESULT WM_LBUTTONUP(long wParam, long lParam) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONUP(wParam, lParam);
    }

    @Override
    LRESULT WM_SETFOCUS(long wParam, long lParam) {
        int bits = 0;
        if ((this.style & 0x10) != 0) {
            bits = OS.GetWindowLong(this.handle, -16);
        }
        LRESULT result = super.WM_SETFOCUS(wParam, lParam);
        if ((this.style & 0x10) != 0) {
            OS.SetWindowLong(this.handle, -16, bits);
        }
        if ((this.style & 8) != 0) {
            this.menuShell().setDefaultButton(this, false);
        }
        return result;
    }

    @Override
    LRESULT WM_SIZE(long wParam, long lParam) {
        LRESULT result = super.WM_SIZE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 0xA) != 0 && this.imageList != null && this.text.length() != 0) {
            BUTTON_IMAGELIST buttonImageList = new BUTTON_IMAGELIST();
            OS.SendMessage(this.handle, 5635, 0L, buttonImageList);
            buttonImageList.uAlign = 0;
            buttonImageList.margin_left = this.computeLeftMargin();
            buttonImageList.margin_right = 4;
            OS.SendMessage(this.handle, 5634, 0L, buttonImageList);
        }
        return result;
    }

    @Override
    LRESULT WM_SYSCOLORCHANGE(long wParam, long lParam) {
        LRESULT result = super.WM_SYSCOLORCHANGE(wParam, lParam);
        if (result != null) {
            return result;
        }
        return result;
    }

    @Override
    LRESULT WM_UPDATEUISTATE(long wParam, long lParam) {
        LRESULT result = super.WM_UPDATEUISTATE(wParam, lParam);
        if (result != null) {
            return result;
        }
        if ((this.style & 0x32) != 0) {
            boolean redraw;
            boolean bl = redraw = this.findImageControl() != null;
            if (!redraw) {
                if ((this.state & 0x100) != 0 && OS.IsAppThemed()) {
                    boolean bl2 = redraw = this.findThemeControl() != null;
                }
                if (!redraw) {
                    boolean bl3 = redraw = this.findBackgroundControl() != null;
                }
            }
            if (redraw) {
                OS.InvalidateRect(this.handle, null, false);
                long code = OS.DefWindowProc(this.handle, 296, wParam, lParam);
                return new LRESULT(code);
            }
        }
        if ((this.style & 0xA) != 0 && (this.hooks(9) || this.filters(9) || this.customDrawing())) {
            OS.InvalidateRect(this.handle, null, true);
        }
        return result;
    }

    @Override
    LRESULT wmCommandChild(long wParam, long lParam) {
        int code = OS.HIWORD(wParam);
        switch (code) {
            case 0: 
            case 5: {
                if ((this.style & 0x22) != 0) {
                    this.setSelection(!this.getSelection());
                } else if ((this.style & 0x10) != 0) {
                    if ((this.parent.getStyle() & 0x400000) != 0) {
                        this.setSelection(!this.getSelection());
                    } else {
                        this.selectRadio();
                    }
                }
                this.sendSelectionEvent(13);
            }
        }
        return super.wmCommandChild(wParam, lParam);
    }

    private int getCheckboxTextOffset(long hdc) {
        int result = 0;
        SIZE size = new SIZE();
        if (OS.IsAppThemed()) {
            OS.GetThemePartSize(this.display.hButtonTheme(), hdc, 3, 1, null, 1, size);
            result += size.cx;
        } else {
            result += DPIUtil.autoScaleUpUsingNativeDPI(13);
        }
        OS.GetTextExtentPoint32(hdc, STRING_WITH_ZERO_CHAR, 1, size);
        return result += size.cx / 2;
    }

    @Override
    LRESULT wmNotifyChild(NMHDR hdr, long wParam, long lParam) {
        switch (hdr.code) {
            case -12: {
                NMCUSTOMDRAW nmcd = new NMCUSTOMDRAW();
                OS.MoveMemory(nmcd, lParam, NMCUSTOMDRAW.sizeof);
                switch (nmcd.dwDrawStage) {
                    case 1: {
                        if (this.customBackgroundDrawing()) {
                            int pixel = this.background;
                            if ((nmcd.uItemState & 1) != 0) {
                                pixel = this.getDifferentColor(this.background);
                            } else if ((nmcd.uItemState & 0x40) != 0) {
                                pixel = this.getSlightlyDifferentColor(this.background);
                            }
                            if ((this.style & 2) != 0 && this.isChecked()) {
                                pixel = this.getDifferentColor(this.background);
                            }
                            long brush = OS.CreateSolidBrush(pixel);
                            int inset = 2;
                            int radius = 3;
                            if (this.useDarkModeExplorerTheme && OS.WIN32_BUILD >= 22000) {
                                inset = 1;
                                radius = 4;
                            }
                            int l = nmcd.left + inset;
                            int t = nmcd.top + inset;
                            int r = nmcd.right - inset;
                            int b = nmcd.bottom - inset;
                            if (OS.WIN32_BUILD >= 22000) {
                                ++l;
                                ++t;
                                OS.SaveDC(nmcd.hdc);
                                OS.SelectObject(nmcd.hdc, brush);
                                OS.SelectObject(nmcd.hdc, OS.GetStockObject(8));
                                OS.RoundRect(nmcd.hdc, l, t, r, b, radius, radius);
                                OS.RestoreDC(nmcd.hdc, -1);
                            } else {
                                RECT rect = new RECT(l, t, r, b);
                                OS.FillRect(nmcd.hdc, rect, brush);
                            }
                            OS.DeleteObject(brush);
                        }
                        if (this.customForegroundDrawing()) {
                            int radioOrCheckTextPadding = this.getCheckboxTextOffset(nmcd.hdc);
                            int border = this.isRadioOrCheck() ? 0 : 3;
                            int left = nmcd.left + border;
                            int right = nmcd.right - border;
                            if (this.image != null) {
                                GCData data = new GCData();
                                data.device = this.display;
                                GC gc = GC.win32_new(nmcd.hdc, data);
                                int margin = this.computeLeftMargin();
                                int imageWidth = this.image.getBoundsInPixels().width;
                                left += imageWidth + (this.isRadioOrCheck() ? 8 : 4);
                                int x = margin + (this.isRadioOrCheck() ? radioOrCheckTextPadding : 3);
                                int y = Math.max(0, (nmcd.bottom - this.image.getBoundsInPixels().height) / 2);
                                gc.drawImage(this.image, DPIUtil.autoScaleDown(x), DPIUtil.autoScaleDown(y));
                                gc.dispose();
                            }
                            int n = this.isRadioOrCheck() ? radioOrCheckTextPadding : 0;
                            RECT textRect = new RECT();
                            OS.SetRect(textRect, left += n, nmcd.top + border, right, nmcd.bottom - border);
                            char[] buffer = this.text.toCharArray();
                            int flags = 0;
                            if ((this.style & 0x40) != 0) {
                                flags |= 0x10;
                                if (!this.isRadioOrCheck() && this.image != null) {
                                    textRect.right -= 4;
                                }
                            } else {
                                flags |= 0x20;
                            }
                            OS.DrawText(nmcd.hdc, buffer, buffer.length, textRect, flags | 0x400);
                            OS.OffsetRect(textRect, 0, Math.max(0, (nmcd.bottom - textRect.bottom - border) / 2));
                            if (this.image != null) {
                                flags |= 0;
                                if (!this.isRadioOrCheck()) {
                                    OS.OffsetRect(textRect, Math.max(4, (right - textRect.right) / 2 + 1), 0);
                                }
                            } else if ((this.style & 0x4000) != 0) {
                                flags |= 0;
                            } else if ((this.style & 0x20000) != 0) {
                                flags |= 2;
                                OS.OffsetRect(textRect, right - textRect.right, 0);
                            } else {
                                flags |= 1;
                                OS.OffsetRect(textRect, (right - textRect.right) / 2, 0);
                            }
                            OS.SetBkMode(nmcd.hdc, 1);
                            OS.SetTextColor(nmcd.hdc, this.foreground);
                            OS.DrawText(nmcd.hdc, buffer, buffer.length, textRect, flags);
                            if ((nmcd.uItemState & 0x10) != 0) {
                                RECT focusRect = new RECT();
                                if (this.isRadioOrCheck()) {
                                    if (this.text.length() > 0) {
                                        OS.SetRect(focusRect, textRect.left - 1, textRect.top, Math.min(nmcd.right, textRect.right + 1), Math.min(nmcd.bottom, textRect.bottom + 1));
                                    } else {
                                        OS.SetRect(focusRect, nmcd.left + 1 + radioOrCheckTextPadding, nmcd.top, nmcd.right - 2, nmcd.bottom - 1);
                                    }
                                } else {
                                    OS.SetRect(focusRect, nmcd.left + 4, nmcd.top + 4, nmcd.right - 4, nmcd.bottom - 4);
                                }
                                OS.DrawFocusRect(nmcd.hdc, focusRect);
                            }
                            return new LRESULT(4L);
                        }
                        return new LRESULT(0L);
                    }
                }
            }
        }
        return super.wmNotifyChild(hdr, wParam, lParam);
    }

    static int getThemeStateId(int style, boolean pressed, boolean enabled) {
        int direction = style & 0x24480;
        if ((style & 0x8000000) != 0) {
            if (direction == 16384) {
                direction = 131072;
            } else if (direction == 131072) {
                direction = 16384;
            }
        }
        boolean hot = false;
        if (OS.WIN32_BUILD >= 22000 && !pressed && enabled) {
            hot = true;
        }
        if (hot) {
            switch (direction) {
                case 128: {
                    return 2;
                }
                case 1024: {
                    return 6;
                }
                case 16384: {
                    return 10;
                }
                case 131072: {
                    return 14;
                }
            }
        }
        if (pressed) {
            switch (direction) {
                case 128: {
                    return 3;
                }
                case 1024: {
                    return 7;
                }
                case 16384: {
                    return 11;
                }
                case 131072: {
                    return 15;
                }
            }
        }
        if (!enabled) {
            switch (direction) {
                case 128: {
                    return 4;
                }
                case 1024: {
                    return 8;
                }
                case 16384: {
                    return 12;
                }
                case 131072: {
                    return 16;
                }
            }
        }
        switch (direction) {
            case 128: {
                return 1;
            }
            case 1024: {
                return 5;
            }
            case 16384: {
                return 9;
            }
            case 131072: {
                return 13;
            }
        }
        return 9;
    }

    @Override
    LRESULT wmDrawChild(long wParam, long lParam) {
        if ((this.style & 4) == 0) {
            return super.wmDrawChild(wParam, lParam);
        }
        DRAWITEMSTRUCT struct = new DRAWITEMSTRUCT();
        OS.MoveMemory(struct, lParam, DRAWITEMSTRUCT.sizeof);
        RECT rect = new RECT();
        OS.SetRect(rect, struct.left, struct.top, struct.right, struct.bottom);
        if (OS.IsAppThemed()) {
            boolean pressed = (struct.itemState & 1) != 0;
            boolean enabled = this.getEnabled();
            int iStateId = Button.getThemeStateId(this.style, pressed, enabled);
            OS.DrawThemeBackground(this.display.hScrollBarThemeAuto(), struct.hDC, 1, iStateId, rect, null);
        } else {
            int uState = 2;
            switch (this.style & 0x24480) {
                case 128: {
                    uState = 0;
                    break;
                }
                case 1024: {
                    uState = 1;
                    break;
                }
                case 16384: {
                    uState = 2;
                    break;
                }
                case 131072: {
                    uState = 3;
                }
            }
            if (!this.getEnabled()) {
                uState |= 0x100;
            }
            if ((this.style & 0x800000) == 0x800000) {
                uState |= 0x4000;
            }
            if ((struct.itemState & 1) != 0) {
                uState |= 0x200;
            }
            OS.DrawFrameControl(struct.hDC, rect, 3, uState);
        }
        return null;
    }
}

