/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.Collator;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.ui.viewer.IStyledLabelDecorator;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DelegatingStyledCellLabelProvider;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.emf.edit.ui.util.StructuredViewerTreeIterator;
import org.eclipse.emf.edit.ui.view.ExtendedPropertySheetPage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FindAndReplaceTarget
implements IFindReplaceTarget,
IFindReplaceTargetExtension,
IFindReplaceTargetExtension3 {
    private static final Map<IWorkbenchPart, FindAndReplaceTarget> FIND_AND_REPLACE_TARGETS = new HashMap<IWorkbenchPart, FindAndReplaceTarget>();
    private static final StyledString.Styler MATCH_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.borderStyle = 1;
        }
    };
    private static final Field F_IS_REGEX_CHECK_BOX_FIELD;
    private static final Field F_SELECTED_RANGE_RADIO_BUTTON_FIELD;
    private static final Field F_TARGET_FIELD;
    private static final Map<Font, Font> TINY_FONT;
    private static final IPartListener PART_LISTENER;
    private final IWorkbenchPart workbenchPart;
    private final AbstractUIPlugin plugin;
    Collator collator = Collator.getInstance();
    private Runnable propertiesCleanup;
    private Runnable sessionCleanup;
    private Runnable disposeCleanup;
    private Runnable filterChangeCleanup;
    private Runnable categoriesChangeCleanup;
    private List<?> selectionScope;
    private Set<Object> selectionScopeObjects;
    private String selectionText;
    private Data.Item selectedItem;
    private int selectedItemStart;
    private Pattern selectedItemPattern;
    private CompoundCommand replaceAllCommand;
    private int pendingReplacements = -1;
    private boolean findReplaceable;
    private SearchType searchType;
    private TreeItem specialTreeItem;
    private int specialStart;
    private boolean suspendScopeChanges;

    static {
        Field fIsRegExCheckBoxField = null;
        Field fSelectedRangeRadioButtonField = null;
        Field fTarget = null;
        try {
            Class findReplaceDialogClass = CommonPlugin.loadClass((String)"org.eclipse.ui.workbench.texteditor", (String)"org.eclipse.ui.texteditor.FindReplaceDialog");
            fIsRegExCheckBoxField = findReplaceDialogClass.getDeclaredField("fIsRegExCheckBox");
            fIsRegExCheckBoxField.setAccessible(true);
            fSelectedRangeRadioButtonField = findReplaceDialogClass.getDeclaredField("fSelectedRangeRadioButton");
            fSelectedRangeRadioButtonField.setAccessible(true);
            fTarget = findReplaceDialogClass.getDeclaredField("fTarget");
            fTarget.setAccessible(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        F_IS_REGEX_CHECK_BOX_FIELD = fIsRegExCheckBoxField;
        F_SELECTED_RANGE_RADIO_BUTTON_FIELD = fSelectedRangeRadioButtonField;
        F_TARGET_FIELD = fTarget;
        TINY_FONT = new HashMap<Font, Font>();
        PART_LISTENER = new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void partClosed(IWorkbenchPart part) {
                Map map = FIND_AND_REPLACE_TARGETS;
                synchronized (map) {
                    FindAndReplaceTarget findAndReplaceTarget = (FindAndReplaceTarget)FIND_AND_REPLACE_TARGETS.remove(part);
                    if (findAndReplaceTarget != null) {
                        findAndReplaceTarget.dispose();
                    }
                }
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }

            public void partActivated(IWorkbenchPart part) {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getAdapter(Class<T> adapter, IWorkbenchPart workbenchPart, AbstractUIPlugin plugin) {
        if (adapter == IFindReplaceTarget.class) {
            Map<IWorkbenchPart, FindAndReplaceTarget> map = FIND_AND_REPLACE_TARGETS;
            synchronized (map) {
                FindAndReplaceTarget findAndReplaceTarget = FIND_AND_REPLACE_TARGETS.get(workbenchPart);
                if (findAndReplaceTarget == null) {
                    workbenchPart.getSite().getPage().addPartListener(PART_LISTENER);
                    findAndReplaceTarget = new FindAndReplaceTarget(workbenchPart, plugin);
                    FIND_AND_REPLACE_TARGETS.put(workbenchPart, findAndReplaceTarget);
                }
                return adapter.cast(findAndReplaceTarget);
            }
        }
        return null;
    }

    private FindAndReplaceTarget(IWorkbenchPart workbenchPart, AbstractUIPlugin plugin) {
        this.workbenchPart = workbenchPart;
        this.plugin = plugin;
    }

    public Collator getCollator() {
        return this.collator;
    }

    public void setCollator(Collator collator) {
        this.collator = collator;
    }

    protected StructuredViewer getViewer() {
        IViewerProvider viewerProvider;
        Viewer viewer;
        if (this.workbenchPart instanceof IViewerProvider && (viewer = (viewerProvider = (IViewerProvider)this.workbenchPart).getViewer()) instanceof StructuredViewer) {
            return (StructuredViewer)viewer;
        }
        return null;
    }

    protected ExtendedPropertySheetPage getActivePropertySheetPage() {
        PropertySheet propertySheet;
        IPage currentPage;
        IWorkbenchPart activePart = this.workbenchPart.getSite().getPage().getActivePart();
        if (activePart instanceof PropertySheet && (currentPage = (propertySheet = (PropertySheet)activePart).getCurrentPage()) instanceof ExtendedPropertySheetPage) {
            ExtendedPropertySheetPage propertySheetPage = (ExtendedPropertySheetPage)currentPage;
            return propertySheetPage;
        }
        return null;
    }

    protected Tree getActivePropertySheetTree() {
        Control control;
        ExtendedPropertySheetPage propertySheetPage = this.getActivePropertySheetPage();
        if (propertySheetPage != null && (control = propertySheetPage.getControl()) instanceof Tree) {
            Tree tree = (Tree)control;
            return tree;
        }
        return null;
    }

    public boolean isEditable() {
        return true;
    }

    public boolean canPerformFind() {
        StructuredViewer viewer = this.getViewer();
        return viewer != null && viewer.getLabelProvider() instanceof ILabelProvider && viewer.getContentProvider() instanceof IStructuredContentProvider;
    }

    protected void initialize(IWorkbenchPart workbenchPart) {
        StructuredViewer viewer = this.getViewer();
        Tree propertySheetTree = this.getActivePropertySheetTree();
        if (propertySheetTree != null) {
            TreeItem[] treeItemArray = propertySheetTree.getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                Set<? extends PropertyDescriptor> propertyDescriptors = FindAndReplaceTarget.getPropertyDescriptors(treeItem).keySet();
                block1: for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    Object object = propertyDescriptor.getObject();
                    for (Data data : new TextData(viewer, this.collator)) {
                        if (data.object != object) continue;
                        Object feature = FindAndReplaceTarget.getFeature(propertyDescriptor);
                        for (Data.Item item : data.items) {
                            Object itemFeature = item.getFeature();
                            if (itemFeature != feature) continue;
                            Control control = workbenchPart.getSite().getShell().getDisplay().getFocusControl();
                            if (control instanceof Text) {
                                Text text = (Text)control;
                                this.selectionText = text.getSelectionText();
                                if (this.selectionText.length() > 0) {
                                    Point selection = text.getSelection();
                                    this.setSelection(true, viewer, item, selection.x, Pattern.compile(Pattern.quote(this.selectionText)));
                                    return;
                                }
                            }
                            this.setSelection(true, viewer, item, 0, Pattern.compile(Pattern.quote(item.value)));
                            return;
                        }
                        continue block1;
                    }
                }
                ++n2;
            }
        } else {
            List list = ((IStructuredSelection)viewer.getSelection()).toList();
            for (Data data : new TextData(viewer, this.collator)) {
                if (!list.contains(data.object)) continue;
                Data.Item item = data.items.get(0);
                this.setSelection(true, viewer, item, 0, Pattern.compile(Pattern.quote(item.value)));
                return;
            }
        }
    }

    public void beginSession() {
        this.initialize(this.workbenchPart);
        this.addSearchTypeControl();
    }

    private static Object getFieldValue(Dialog dialog, Field field) {
        try {
            return field.get(dialog);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void addSearchTypeControl() {
        Shell[] shells;
        Shell workbenchShell = this.workbenchPart.getSite().getShell();
        Shell[] shellArray = shells = workbenchShell.getShells();
        int n = shells.length;
        int n2 = 0;
        while (n2 < n) {
            Button checkBoxButton;
            Object layoutData;
            Dialog dialog;
            Object checkBox;
            final Shell shell = shellArray[n2];
            Object data = shell.getData();
            if (data instanceof Dialog && "org.eclipse.ui.texteditor.FindReplaceDialog".equals(data.getClass().getName()) && (checkBox = FindAndReplaceTarget.getFieldValue(dialog = (Dialog)data, F_IS_REGEX_CHECK_BOX_FIELD)) instanceof Button && (layoutData = (checkBoxButton = (Button)checkBox).getLayoutData()) instanceof GridData) {
                String label;
                IDialogSettings pluginDialogSettings;
                final GridData checkBoxGridData = (GridData)layoutData;
                if (checkBoxGridData.horizontalSpan == 2) {
                    checkBoxGridData.verticalAlignment = 128;
                    checkBoxGridData.horizontalSpan = 1;
                }
                final IDialogSettings dialogSettings = (pluginDialogSettings = this.plugin.getDialogSettings()).getSection("org.eclipse.ui.texteditor.FindReplaceDialog") == null ? pluginDialogSettings.addNewSection("org.eclipse.ui.texteditor.FindReplaceDialog") : pluginDialogSettings.getSection("org.eclipse.ui.texteditor.FindReplaceDialog");
                final Composite group = checkBoxButton.getParent();
                final Combo combo = new Combo(group, 12);
                combo.setItems(SearchType.getLabels());
                GridData gridData = new GridData(16384, 128, false, false, 1, 1);
                combo.setLayoutData((Object)gridData);
                this.searchType = SearchType.getSearchType(dialogSettings.get("search-type"));
                combo.select(this.searchType.ordinal());
                combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FindAndReplaceTarget.this.searchType = SearchType.values()[combo.getSelectionIndex()];
                        dialogSettings.put("search-type", FindAndReplaceTarget.this.searchType.key());
                    }
                });
                String oldLabel = null;
                Button selectedRangeButton = null;
                Object selectedRange = FindAndReplaceTarget.getFieldValue(dialog, F_SELECTED_RANGE_RADIO_BUTTON_FIELD);
                if (selectedRange instanceof Button && (label = (selectedRangeButton = (Button)selectedRange).getText()).endsWith("lines")) {
                    oldLabel = label;
                    selectedRangeButton.setText(String.valueOf(label.substring(0, label.length() - 5)) + " elements");
                }
                shell.layout(true, true);
                if (!dialogSettings.getBoolean("resized")) {
                    Rectangle comboBounds = combo.getBounds();
                    Point comboBottomRightLocation = group.toDisplay(comboBounds.x + comboBounds.width, comboBounds.y + comboBounds.height);
                    Rectangle groupBounds = group.getBounds();
                    Point groupBottomRightLocation = group.getParent().toDisplay(groupBounds.x + groupBounds.width, groupBounds.y + groupBounds.height);
                    int widthDelta = groupBottomRightLocation.x - comboBottomRightLocation.x;
                    int heightDelta = groupBottomRightLocation.y - comboBottomRightLocation.y;
                    if (widthDelta < 8 || heightDelta < 8) {
                        Point shellSize = shell.getSize();
                        if (widthDelta < 8) {
                            shellSize.x -= widthDelta - 8;
                        }
                        if (heightDelta < 8) {
                            shellSize.y -= heightDelta - 8;
                        }
                        shell.setSize(shellSize);
                    }
                    dialogSettings.put("resized", true);
                }
                final String finalOldLabel = oldLabel;
                final Button finalSelectRangeButton = selectedRangeButton;
                this.sessionCleanup = new Runnable(){

                    public void run() {
                        checkBoxGridData.horizontalSpan = 2;
                        checkBoxGridData.verticalAlignment = 0x1000000;
                        combo.dispose();
                        if (finalOldLabel != null) {
                            finalSelectRangeButton.setText(finalOldLabel);
                        }
                        group.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (!group.isDisposed() && !shell.isDisposed()) {
                                    shell.layout(true, true);
                                }
                            }
                        });
                        if (FindAndReplaceTarget.this.filterChangeCleanup != null) {
                            FindAndReplaceTarget.this.filterChangeCleanup.run();
                        }
                        if (FindAndReplaceTarget.this.categoriesChangeCleanup != null) {
                            FindAndReplaceTarget.this.categoriesChangeCleanup.run();
                        }
                        FindAndReplaceTarget.this.sessionCleanup = null;
                    }
                };
                this.disposeCleanup = new Runnable(){

                    public void run() {
                        Object fieldValue = FindAndReplaceTarget.getFieldValue(dialog, F_TARGET_FIELD);
                        if (fieldValue == FindAndReplaceTarget.this) {
                            try {
                                Method method = dialog.getClass().getMethod("updateTarget", IFindReplaceTarget.class, Boolean.TYPE, Boolean.TYPE);
                                method.setAccessible(true);
                                method.invoke((Object)dialog, null, false, false);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        FindAndReplaceTarget.this.disposeCleanup = null;
                    }
                };
            }
            ++n2;
        }
    }

    private void dispose() {
        if (this.disposeCleanup != null) {
            this.disposeCleanup.run();
        }
    }

    public void endSession() {
        if (this.sessionCleanup != null) {
            this.sessionCleanup.run();
        }
        this.setScope(null);
    }

    public Point getLineSelection() {
        StructuredViewer viewer = this.getViewer();
        this.selectionScope = ((IStructuredSelection)viewer.getSelection()).toList();
        return new Point(0, 0);
    }

    public IRegion getScope() {
        return new Region(0, 0);
    }

    public void setScope(IRegion scope) {
        if (this.suspendScopeChanges) {
            return;
        }
        StructuredViewer viewer = this.getViewer();
        if (scope == null) {
            Object[] selectionScopeObjectsToUpdate = this.selectionScopeObjects == null ? null : this.selectionScopeObjects.toArray();
            Object selectionToUpdate = this.selectedItem != null && this.selectedItem.itemPropertyDescriptor == null ? this.selectedItem.data.object : null;
            this.selectionText = null;
            this.selectedItem = null;
            this.findReplaceable = false;
            this.selectionScopeObjects = null;
            this.propertiesCleanup();
            if (selectionScopeObjectsToUpdate != null) {
                viewer.update(selectionScopeObjectsToUpdate, null);
            }
            if (selectionToUpdate != null) {
                viewer.update(selectionToUpdate, null);
            }
        } else {
            this.selectionScopeObjects = new HashSet<Object>();
            int depth = -1;
            for (Data data : new TextData(viewer, this.collator)) {
                if (data.depth == depth) {
                    depth = -1;
                }
                if (this.selectionScope.contains(data.object) && depth == -1) {
                    depth = data.depth;
                }
                if (depth == -1) continue;
                this.selectionScopeObjects.add(data.object);
            }
            this.hookLabelProvider();
            viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    protected void propertiesCleanup() {
        if (this.propertiesCleanup != null) {
            this.propertiesCleanup.run();
        }
    }

    public void setScopeHighlightColor(Color color) {
    }

    public String getSelectionText() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        if ("updateButtonState".equals(stackTrace[2].getMethodName()) && (this.selectedItem == null || this.selectedItem.itemPropertyDescriptor == null || !this.selectedItem.itemPropertyDescriptor.canSetProperty(this.selectedItem.data.object))) {
            return "";
        }
        if (this.selectionText != null) {
            return this.selectionText;
        }
        if (this.selectedItem != null) {
            return this.selectedItem.value;
        }
        return "";
    }

    public Point getSelection() {
        if (this.pendingReplacements >= 0) {
            return new Point(this.pendingReplacements, 0);
        }
        if (this.selectedItem != null) {
            Matcher matcher = this.selectedItemPattern.matcher(this.selectedItem.value);
            int size = 0;
            if (this.selectedItem.value.length() >= this.selectedItemStart && matcher.find(this.selectedItemStart)) {
                size = matcher.group().length();
            }
            Point point = new Point(this.selectedItem.index + this.selectedItemStart, size);
            return point;
        }
        StructuredViewer viewer = this.getViewer();
        Tree propertySheetTree = this.getActivePropertySheetTree();
        if (propertySheetTree != null) {
            TreeItem[] treeItemArray = propertySheetTree.getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem treeItem = treeItemArray[n2];
                Set<? extends PropertyDescriptor> propertyDescriptors = FindAndReplaceTarget.getPropertyDescriptors(treeItem).keySet();
                block1: for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                    Object object = propertyDescriptor.getObject();
                    for (Data data : new TextData(viewer, this.collator)) {
                        if (data.object != object) continue;
                        Object feature = FindAndReplaceTarget.getFeature(propertyDescriptor);
                        ArrayList<Object> features = new ArrayList<Object>();
                        TreeItem[] treeItemArray2 = propertySheetTree.getItems();
                        int n3 = treeItemArray2.length;
                        int n4 = 0;
                        block3: while (n4 < n3) {
                            TreeItem otherTreeIem = treeItemArray2[n4];
                            Set<? extends PropertyDescriptor> otherPropertyDescriptors = FindAndReplaceTarget.getPropertyDescriptors(otherTreeIem).keySet();
                            for (PropertyDescriptor propertyDescriptor2 : otherPropertyDescriptors) {
                                Object otherFeature = FindAndReplaceTarget.getFeature(propertyDescriptor2);
                                features.add(otherFeature);
                                if (otherFeature == feature) break block3;
                            }
                            ++n4;
                        }
                        Data.Item candidate = null;
                        for (Data.Item item : data.items) {
                            Object itemFeature = item.getFeature();
                            if (itemFeature == feature) {
                                return new Point(item.index, 0);
                            }
                            if (!features.contains(itemFeature)) continue;
                            candidate = item;
                        }
                        if (candidate == null) continue block1;
                        return new Point(candidate.index, 0);
                    }
                }
                ++n2;
            }
        }
        List list = ((IStructuredSelection)viewer.getSelection()).toList();
        for (Data data : new TextData(viewer, this.collator)) {
            if (!list.contains(data.object)) continue;
            return new Point(data.items.get((int)0).index, 0);
        }
        return new Point(0, 0);
    }

    public void setSelection(int offset, int length) {
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.findAndSelect(offset, findString, searchForward, caseSensitive, wholeWord, false);
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        this.selectionText = null;
        if (regExSearch) {
            Pattern.compile(findString);
        }
        String impliedPattern = findString;
        if (!regExSearch) {
            impliedPattern = Pattern.quote(impliedPattern);
        }
        if (!caseSensitive) {
            impliedPattern = "(?i)" + impliedPattern;
        }
        if (wholeWord) {
            impliedPattern = "\\b" + impliedPattern + "\\b";
        }
        Pattern pattern = Pattern.compile(impliedPattern);
        if (this.pendingReplacements >= 0) {
            this.selectedItemPattern = pattern;
            return --this.pendingReplacements;
        }
        StructuredViewer viewer = this.getViewer();
        Data.Item candidate = null;
        int candidateStart = -1;
        block0: for (Data data : new TextData(viewer, this.collator)) {
            if (this.selectionScopeObjects != null && !this.selectionScopeObjects.contains(data.object)) continue;
            for (Data.Item item : data.items) {
                if (searchForward ? item.index >= offset || item.index + item.value.length() > offset : offset == -1 || item.index < offset) {
                    Matcher matcher;
                    if (this.findReplaceable ? !SearchType.MODIFIABLE_ATTRIBUTE.isIncluded(item) : this.searchType != null && !this.searchType.isIncluded(item)) continue;
                    int begin = 0;
                    if (searchForward && item.index < offset) {
                        begin = offset - item.index;
                    }
                    if (!(matcher = pattern.matcher(item.value)).find(begin)) continue;
                    int start = matcher.start();
                    if (searchForward) {
                        this.setSelection(false, viewer, item, start, pattern);
                        this.findReplaceable = false;
                        return item.index + start;
                    }
                    if (offset != -1 && item.index + start > offset) continue;
                    candidate = item;
                    candidateStart = start;
                    while (matcher.find()) {
                        start = matcher.start();
                        if (offset != -1 && item.index + start > offset) continue;
                        candidate = item;
                        candidateStart = start;
                    }
                    continue;
                }
                if (!searchForward && item.index > offset) break block0;
            }
        }
        if (candidate != null) {
            this.setSelection(false, viewer, candidate, candidateStart, pattern);
            this.findReplaceable = false;
            return candidate.index + candidateStart;
        }
        return -1;
    }

    protected void setSelection(boolean preserve, StructuredViewer viewer, Data.Item item, final int start, Pattern pattern) {
        Object selectedObjectToUpdate = this.selectedItem != null && this.selectedItem.itemPropertyDescriptor == null ? this.selectedItem.data.object : null;
        this.selectedItem = item;
        this.selectedItemPattern = pattern;
        this.selectedItemStart = start;
        if (selectedObjectToUpdate != null) {
            viewer.update(selectedObjectToUpdate, null);
        }
        this.specialTreeItem = null;
        this.hookLabelProvider();
        this.propertiesCleanup();
        if (this.replaceAllCommand == null) {
            Control control;
            PropertySheet propertySheet;
            IPage currentPage;
            IViewPart viewPart;
            block23: {
                StructuredSelection selection = new StructuredSelection((Object)new TreePath(item.data.getPath()));
                if (!preserve) {
                    viewer.setSelection((ISelection)selection, true);
                    selection = viewer.getSelection();
                    ExtendedPropertySheetPage activePropertySheetPage = this.getActivePropertySheetPage();
                    if (activePropertySheetPage != null) {
                        activePropertySheetPage.selectionChanged(this.workbenchPart, (ISelection)selection);
                    }
                }
                IWorkbenchPartSite site = this.workbenchPart.getSite();
                IWorkbenchPage page = site.getPage();
                viewPart = page.findView("org.eclipse.ui.views.PropertySheet");
                Display display = site.getShell().getDisplay();
                Control oldFocusControl = display.getFocusControl();
                try {
                    try {
                        Control newFocusControl;
                        this.suspendScopeChanges = true;
                        if (item.itemPropertyDescriptor != null && (viewPart = page.showView("org.eclipse.ui.views.PropertySheet", null, 2)) == null) {
                            viewPart = page.showView("org.eclipse.ui.views.PropertySheet", null, 3);
                        }
                        if (oldFocusControl != (newFocusControl = display.getFocusControl())) {
                            oldFocusControl.setFocus();
                        }
                    }
                    catch (PartInitException exception) {
                        this.plugin.getLog().log((IStatus)new Status(2, this.plugin.getBundle().getSymbolicName(), 0, exception.getLocalizedMessage(), null));
                        this.suspendScopeChanges = false;
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    this.suspendScopeChanges = false;
                    throw throwable;
                }
                this.suspendScopeChanges = false;
            }
            if (viewPart instanceof PropertySheet && (currentPage = (propertySheet = (PropertySheet)viewPart).getCurrentPage()) instanceof ExtendedPropertySheetPage && (control = currentPage.getControl()) instanceof Tree) {
                final Tree tree = (Tree)control;
                if (item.itemPropertyDescriptor != null) {
                    IAction categoriesAction;
                    int n;
                    String[] filterFlags = item.itemPropertyDescriptor.getFilterFlags(item.data.object);
                    if (filterFlags != null) {
                        String[] stringArray = filterFlags;
                        n = filterFlags.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IAction action;
                            String filterFlag = stringArray[n2];
                            if ("org.eclipse.ui.views.properties.expert".equals(filterFlag) && !(action = ((ExtendedPropertySheetPage)currentPage).getFilterAction()).isChecked()) {
                                action.setChecked(true);
                                action.run();
                                this.filterChangeCleanup = new Runnable(){

                                    public void run() {
                                        action.setChecked(false);
                                        action.run();
                                        FindAndReplaceTarget.this.filterChangeCleanup = null;
                                    }
                                };
                            }
                            ++n2;
                        }
                    }
                    if (!(categoriesAction = ((ExtendedPropertySheetPage)currentPage).getCategoriesAction()).isChecked()) {
                        categoriesAction.setChecked(true);
                        categoriesAction.run();
                        this.categoriesChangeCleanup = new Runnable(){

                            public void run() {
                                categoriesAction.setChecked(false);
                                categoriesAction.run();
                                FindAndReplaceTarget.this.categoriesChangeCleanup = null;
                            }
                        };
                    }
                    TreeItem[] treeItemArray = tree.getItems();
                    int n3 = treeItemArray.length;
                    n = 0;
                    while (n < n3) {
                        TreeItem rootTreeItem = treeItemArray[n];
                        Map<? extends PropertyDescriptor, TreeItem> propertyDescriptors = FindAndReplaceTarget.getPropertyDescriptors(rootTreeItem);
                        for (Map.Entry<? extends PropertyDescriptor, TreeItem> entry : propertyDescriptors.entrySet()) {
                            Matcher matcher;
                            PropertyDescriptor propertyDescriptor = entry.getKey();
                            final TreeItem propertyDescriptorTreeItem = entry.getValue();
                            if (propertyDescriptor.getFeature() != item.getFeature()) continue;
                            String treeItemText = propertyDescriptorTreeItem.getText(1);
                            String itemValue = item.value;
                            this.specialStart = -1;
                            if (!treeItemText.equals(itemValue) && (matcher = pattern.matcher(itemValue)).find(start)) {
                                this.specialTreeItem = propertyDescriptorTreeItem;
                                int end = matcher.end();
                                if (treeItemText.length() < end || !treeItemText.substring(0, end).equals(itemValue.substring(0, end))) {
                                    int begin = matcher.start();
                                    this.specialStart = 2;
                                    while (begin >= 0 && this.specialStart < 20 && !Character.isISOControl(itemValue.charAt(begin))) {
                                        ++this.specialStart;
                                        --begin;
                                    }
                                    int itemValueLength = itemValue.length();
                                    while (end < itemValueLength && !Character.isISOControl(itemValue.charAt(end))) {
                                        ++end;
                                    }
                                    String specialText = "..." + itemValue.substring(begin + 1, end) + "...";
                                    propertyDescriptorTreeItem.setText(1, specialText);
                                    tree.redraw();
                                }
                            }
                            final Listener paintItemListener = new Listener(){

                                private void paintItem(Event event, TreeItem item, int matchStart) {
                                    String text = item.getText(1);
                                    Matcher matcher = FindAndReplaceTarget.this.selectedItemPattern.matcher(text);
                                    if (matchStart < text.length() && matcher.find(matchStart)) {
                                        int start2 = matcher.start();
                                        int x = event.gc.textExtent((String)text.substring((int)0, (int)start2)).x + item.getTextBounds((int)1).x - propertyDescriptorTreeItem.getBounds((int)1).x;
                                        int width = event.gc.textExtent((String)matcher.group()).x;
                                        event.gc.drawRectangle(event.x + x + 1, event.y, width + 1, event.height - 1);
                                    } else if (text.endsWith("...")) {
                                        int x = event.gc.textExtent((String)text.substring((int)0, (int)(text.length() - 3))).x + propertyDescriptorTreeItem.getTextBounds((int)1).x - propertyDescriptorTreeItem.getBounds((int)1).x;
                                        int width = event.gc.textExtent((String)"...").x;
                                        event.gc.drawRectangle(event.x + x + 1, event.y, width + 1, event.height - 1);
                                    }
                                }

                                public void handleEvent(Event event) {
                                    TreeItem item = (TreeItem)event.item;
                                    if (item == propertyDescriptorTreeItem && event.index == 1) {
                                        this.paintItem(event, item, FindAndReplaceTarget.this.specialStart == -1 ? start : FindAndReplaceTarget.this.specialStart);
                                    }
                                }
                            };
                            tree.addListener(42, paintItemListener);
                            final ExtendedPropertySheetPage propertySheetPage = (ExtendedPropertySheetPage)currentPage;
                            this.propertiesCleanup = new Runnable(){

                                public void run() {
                                    tree.removeListener(42, paintItemListener);
                                    propertySheetPage.refreshLabels();
                                    FindAndReplaceTarget.this.propertiesCleanup = null;
                                }
                            };
                            tree.setSelection(propertyDescriptorTreeItem);
                            tree.redraw();
                            return;
                        }
                        ++n;
                    }
                }
                tree.setSelection(new TreeItem[0]);
            }
        }
    }

    protected void hookLabelProvider() {
        ILabelProvider labelProvider;
        StructuredViewer viewer = this.getViewer();
        Font font = viewer.getControl().getFont();
        Font tinyFont = TINY_FONT.get(font);
        if (tinyFont == null) {
            FontData[] fontData;
            FontData[] fontDataArray = fontData = font.getFontData();
            int n = fontData.length;
            int n2 = 0;
            while (n2 < n) {
                FontData data = fontDataArray[n2];
                data.setHeight(data.getHeight() / 4);
                ++n2;
            }
            tinyFont = new Font(font.getDevice(), fontData);
            TINY_FONT.put(font, tinyFont);
        }
        if ((labelProvider = (ILabelProvider)viewer.getLabelProvider()) instanceof DecoratingLabelProvider) {
            if (this.selectionScopeObjects != null) {
                viewer.update(this.selectionScopeObjects.toArray(), null);
            }
            if (this.selectedItem != null && this.selectedItem.itemPropertyDescriptor == null) {
                viewer.update(this.selectedItem.data.object, null);
            }
        } else {
            final Font finalTinyFont = tinyFont;
            StyledString.Styler tinyFontStyler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.font = finalTinyFont;
                }
            };
            DecoratingColumLabelProvider.StyledLabelProvider styledProvider = new DecoratingColumLabelProvider.StyledLabelProvider(labelProvider, (ILabelDecorator)new StyledLabelDecorator(labelProvider, tinyFontStyler)){
                {
                    if (this.labelProvider instanceof CellLabelProvider) {
                        this.cellLabelProvider = (CellLabelProvider)this.labelProvider;
                    }
                }
            };
            DecoratingLabelProvider delegatingLabelProvider = new DecoratingLabelProvider(styledProvider);
            viewer.setLabelProvider((IBaseLabelProvider)delegatingLabelProvider);
        }
    }

    public void replaceSelection(String text) {
        this.replaceSelection(text, false);
    }

    public void replaceSelection(String text, boolean regExReplace) {
        Command setCommand;
        String specialText;
        Matcher specialMatcher;
        Object value;
        if (this.replaceAllCommand != null) {
            if (this.pendingReplacements == 0x7FFFFFFE) {
                this.pendingReplacements = this.replaceSelectionAll(text, regExReplace) - 1;
            }
            return;
        }
        if (!SearchType.MODIFIABLE_ATTRIBUTE.isIncluded(this.selectedItem)) {
            return;
        }
        Matcher matcher = this.selectedItemPattern.matcher(this.selectedItem.value);
        if (!matcher.find(this.selectedItemStart)) {
            return;
        }
        StringBuffer result = new StringBuffer();
        int start = matcher.start();
        String replacement = regExReplace ? text : text.replace("$", "\\$");
        matcher.appendReplacement(result, replacement);
        String actualReplacement = result.substring(start);
        matcher.appendTail(result);
        EditingDomain domain = ((IEditingDomainProvider)this.workbenchPart).getEditingDomain();
        EAttribute eAttribute = (EAttribute)this.selectedItem.getFeature();
        try {
            value = EcoreUtil.createFromString((EDataType)eAttribute.getEAttributeType(), (String)result.toString());
        }
        catch (RuntimeException exception) {
            return;
        }
        String replacementSpecialText = null;
        if (this.specialTreeItem != null && !this.specialTreeItem.isDisposed() && (specialMatcher = this.selectedItemPattern.matcher(specialText = this.specialTreeItem.getText(1))).find(this.specialStart)) {
            StringBuffer specialResult = new StringBuffer();
            specialMatcher.appendReplacement(specialResult, replacement);
            specialMatcher.appendTail(specialResult);
            replacementSpecialText = specialResult.toString();
        }
        this.selectedItemPattern = Pattern.compile(Pattern.quote(actualReplacement));
        if (eAttribute.isMany()) {
            Object propertyValue = this.selectedItem.itemPropertyDescriptor.getPropertyValue(this.selectedItem.data.object);
            if (propertyValue instanceof IItemPropertySource) {
                propertyValue = ((IItemPropertySource)propertyValue).getEditableValue(this.selectedItem.data.object);
            }
            ArrayList<Object> values = new ArrayList<Object>((List)propertyValue);
            values.set(this.selectedItem.itemIndex, value);
            setCommand = SetCommand.create((EditingDomain)domain, (Object)this.selectedItem.data.object, (Object)eAttribute, values);
        } else {
            setCommand = SetCommand.create((EditingDomain)domain, (Object)this.selectedItem.data.object, (Object)eAttribute, (Object)value);
        }
        CompoundCommand wrapper = new CompoundCommand(Integer.MAX_VALUE){
            boolean isFirst;
            {
                this.isFirst = true;
            }

            public Collection<?> getAffectedObjects() {
                if (this.isFirst) {
                    this.isFirst = false;
                    return Collections.emptyList();
                }
                return super.getAffectedObjects();
            }
        };
        wrapper.append(setCommand);
        domain.getCommandStack().execute((Command)wrapper);
        Display display = this.getViewer().getControl().getShell().getDisplay();
        final boolean[] run = new boolean[]{true};
        display.asyncExec(new Runnable(){

            public void run() {
                run[0] = false;
            }
        });
        while (run[0] && display.readAndDispatch()) {
            display.sleep();
        }
        if (this.specialTreeItem != null) {
            if (!this.specialTreeItem.isDisposed() && replacementSpecialText != null) {
                this.specialTreeItem.setText(1, replacementSpecialText);
                this.specialTreeItem.getParent().redraw();
            }
            this.specialTreeItem = null;
        }
        for (Data data : new TextData(this.getViewer(), this.collator)) {
            if (data.object != this.selectedItem.data.object) continue;
            for (Data.Item item : data.items) {
                if (this.selectedItem.itemPropertyDescriptor != item.itemPropertyDescriptor || this.selectedItem.itemIndex != item.itemIndex) continue;
                this.selectedItem = item;
            }
        }
        this.findReplaceable = true;
    }

    protected int replaceSelectionAll(String text, boolean regExReplace) {
        String replacement = regExReplace ? text : text.replace("$", "\\$");
        EditingDomain domain = ((IEditingDomainProvider)this.workbenchPart).getEditingDomain();
        int total = 0;
        for (Data data : new TextData(this.getViewer(), this.collator)) {
            EAttribute currentListAttribute = null;
            ArrayList<Object> currentListValue = null;
            for (Data.Item item : data.items) {
                Object value;
                Matcher matcher;
                if (!SearchType.MODIFIABLE_ATTRIBUTE.isIncluded(item) || !(matcher = this.selectedItemPattern.matcher(item.value)).find()) continue;
                StringBuffer result = new StringBuffer();
                int count = 0;
                do {
                    matcher.appendReplacement(result, replacement);
                    ++count;
                } while (matcher.find());
                matcher.appendTail(result);
                EAttribute eAttribute = (EAttribute)item.getFeature();
                if (currentListAttribute != null && eAttribute != currentListAttribute) {
                    Command setCommand = SetCommand.create((EditingDomain)domain, (Object)data.object, currentListAttribute, currentListValue);
                    this.replaceAllCommand.append(setCommand);
                    currentListAttribute = null;
                    currentListValue = null;
                }
                try {
                    value = EcoreUtil.createFromString((EDataType)eAttribute.getEAttributeType(), (String)result.toString());
                }
                catch (RuntimeException exception) {
                    continue;
                }
                total += count;
                if (eAttribute.isMany()) {
                    if (currentListValue == null) {
                        currentListAttribute = eAttribute;
                        Object propertyValue = item.itemPropertyDescriptor.getPropertyValue(data.object);
                        if (propertyValue instanceof IItemPropertySource) {
                            propertyValue = ((IItemPropertySource)propertyValue).getEditableValue(data.object);
                        }
                        currentListValue = new ArrayList<Object>((List)propertyValue);
                    }
                    currentListValue.set(item.itemIndex, value);
                    continue;
                }
                Command setCommand = SetCommand.create((EditingDomain)domain, (Object)data.object, (Object)eAttribute, (Object)value);
                this.replaceAllCommand.append(setCommand);
            }
            if (currentListAttribute == null) continue;
            Command setCommand = SetCommand.create((EditingDomain)domain, (Object)data.object, currentListAttribute, currentListValue);
            this.replaceAllCommand.append(setCommand);
        }
        return total;
    }

    public void setReplaceAllMode(boolean replaceAll) {
        if (replaceAll) {
            this.findReplaceable = true;
            this.replaceAllCommand = new CompoundCommand(Integer.MAX_VALUE, "Replace All"){};
            this.pendingReplacements = Integer.MAX_VALUE;
        } else {
            try {
                EditingDomain domain = ((IEditingDomainProvider)this.workbenchPart).getEditingDomain();
                domain.getCommandStack().execute((Command)this.replaceAllCommand);
            }
            finally {
                this.findReplaceable = false;
                this.replaceAllCommand = null;
                this.pendingReplacements = -1;
            }
        }
    }

    protected static List<String> getText(IItemPropertyDescriptor itemPropertyDescriptor, Object object) {
        IItemLabelProvider labelProvider;
        EAttribute eAttribute;
        EDataType eDataType;
        Object feature;
        if (itemPropertyDescriptor instanceof ItemPropertyDescriptorDecorator) {
            ItemPropertyDescriptorDecorator itemPropertyDescriptorDecorator = (ItemPropertyDescriptorDecorator)itemPropertyDescriptor;
            return FindAndReplaceTarget.getText(itemPropertyDescriptorDecorator.getDecoratedItemPropertyDescriptor(), itemPropertyDescriptorDecorator.getDecoratedObject());
        }
        ArrayList<String> result = new ArrayList<String>();
        Object propertyValue = itemPropertyDescriptor.getPropertyValue(object);
        if (propertyValue instanceof IItemPropertySource) {
            propertyValue = ((IItemPropertySource)propertyValue).getEditableValue(object);
        }
        if ((feature = itemPropertyDescriptor.getFeature(object)) instanceof EAttribute && (eDataType = (eAttribute = (EAttribute)feature).getEAttributeType()).isSerializable() && propertyValue != null) {
            boolean useLabel = false;
            if (eAttribute.isMany()) {
                for (Object item : (List)propertyValue) {
                    try {
                        result.add(EcoreUtil.convertToString((EDataType)eDataType, item));
                    }
                    catch (Exception exception) {
                        useLabel = true;
                        break;
                    }
                }
            } else {
                try {
                    result.add(EcoreUtil.convertToString((EDataType)eDataType, (Object)propertyValue));
                }
                catch (RuntimeException exception) {
                    useLabel = true;
                }
            }
        }
        if ((labelProvider = itemPropertyDescriptor.getLabelProvider(object)) != null && propertyValue != null) {
            String text = labelProvider.getText(propertyValue);
            for (String otherText : result) {
                if (!otherText.contains(text)) continue;
                return result;
            }
            result.add(text);
        }
        return result;
    }

    protected static Map<? extends PropertyDescriptor, TreeItem> getPropertyDescriptors(TreeItem treeItem) {
        LinkedHashMap<PropertyDescriptor, TreeItem> result;
        block3: {
            block2: {
                result = new LinkedHashMap<PropertyDescriptor, TreeItem>();
                Object data = treeItem.getData();
                if (!(data instanceof ExtendedPropertySheetPage.ExtendedPropertySheetEntry)) break block2;
                ExtendedPropertySheetPage.ExtendedPropertySheetEntry propertySheetEntry = (ExtendedPropertySheetPage.ExtendedPropertySheetEntry)((Object)data);
                IPropertyDescriptor descriptor = propertySheetEntry.getDescriptor();
                if (!(descriptor instanceof PropertyDescriptor)) break block3;
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
                result.put(propertyDescriptor, treeItem);
                if (treeItem.getItemCount() == 0) break block3;
                Event event = new Event();
                event.item = treeItem;
                treeItem.getParent().notifyListeners(17, event);
                TreeItem[] treeItemArray = treeItem.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem childItem = treeItemArray[n2];
                    result.putAll(FindAndReplaceTarget.getPropertyDescriptors(childItem));
                    ++n2;
                }
                break block3;
            }
            TreeItem[] treeItemArray = treeItem.getItems();
            int n = treeItemArray.length;
            int n3 = 0;
            while (n3 < n) {
                TreeItem childTreeItem = treeItemArray[n3];
                result.putAll(FindAndReplaceTarget.getPropertyDescriptors(childTreeItem));
                ++n3;
            }
        }
        return result;
    }

    protected static Object getFeature(PropertyDescriptor propertyDescriptor) {
        Object object = propertyDescriptor.getObject();
        IItemPropertyDescriptor itemPropertyDescriptor = propertyDescriptor.getItemPropertyDescriptor();
        return itemPropertyDescriptor.getFeature(object);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Data {
        public Object object;
        public int depth;
        public Data parent;
        public List<Item> items;

        public Data(int depth, Object object, List<Item> items) {
            this.depth = depth;
            this.object = object;
            this.items = items;
        }

        public Object[] getPath() {
            ArrayList<Object> path = new ArrayList<Object>();
            Data data = this;
            while (data != null) {
                path.add(0, data.object);
                data = data.parent;
            }
            return path.toArray();
        }

        protected static class Item {
            public Data data;
            public int index;
            public IItemPropertyDescriptor itemPropertyDescriptor;
            public int itemIndex;
            public String value;

            public Item(Data data, int index, IItemPropertyDescriptor itemPropertyDescriptor, int itemIndex, String value) {
                this.data = data;
                this.index = index;
                this.itemPropertyDescriptor = itemPropertyDescriptor;
                this.itemIndex = itemIndex;
                this.value = value;
            }

            public Object getFeature() {
                if (this.itemPropertyDescriptor != null) {
                    return this.itemPropertyDescriptor.getFeature(this.data.object);
                }
                return null;
            }
        }
    }

    protected static class DecoratingLabelProvider
    extends DelegatingStyledCellLabelProvider.FontAndColorProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        public DecoratingLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider styledLabelProvider) {
            super(styledLabelProvider);
        }

        public StyledString getStyledText(Object element) {
            return super.getStyledText(element);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SearchType {
        LABEL_AND_PROPERTY{

            public boolean isIncluded(Data.Item item) {
                return item != null;
            }

            public String key() {
                return "label+property";
            }

            public String label() {
                return EMFEditUIPlugin.INSTANCE.getString("_UI_LabelAndProperties_label");
            }
        }
        ,
        LABEL{

            public boolean isIncluded(Data.Item item) {
                return item != null && item.itemPropertyDescriptor == null;
            }

            public String key() {
                return "label";
            }

            public String label() {
                return EMFEditUIPlugin.INSTANCE.getString("_UI_Labels_label");
            }
        }
        ,
        PROPERTY{

            public boolean isIncluded(Data.Item item) {
                return item != null && item.itemPropertyDescriptor != null;
            }

            public String key() {
                return "property";
            }

            public String label() {
                return EMFEditUIPlugin.INSTANCE.getString("_UI_Properties_label");
            }
        }
        ,
        MODIFIABLE_ATTRIBUTE{

            public boolean isIncluded(Data.Item item) {
                return item != null && item.itemPropertyDescriptor != null && item.getFeature() instanceof EAttribute && item.itemPropertyDescriptor.canSetProperty(item.data.object);
            }

            public String key() {
                return "modifiable-attribute";
            }

            public String label() {
                return EMFEditUIPlugin.INSTANCE.getString("_UI_ModifiableAttributes_label");
            }
        };


        public abstract boolean isIncluded(Data.Item var1);

        public abstract String key();

        public abstract String label();

        public static SearchType getSearchType(String key) {
            SearchType[] searchTypeArray = SearchType.values();
            int n = searchTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SearchType searchType = searchTypeArray[n2];
                if (searchType.key().equals(key)) {
                    return searchType;
                }
                ++n2;
            }
            return LABEL_AND_PROPERTY;
        }

        public static String[] getLabels() {
            SearchType[] values = SearchType.values();
            String[] labels = new String[values.length];
            int i = 0;
            while (i < values.length) {
                labels[i] = values[i].label();
                ++i;
            }
            return labels;
        }
    }

    protected final class StyledLabelDecorator
    implements IStyledLabelDecorator {
        private final ILabelProvider labelProvider;
        final Color color;
        final StyledString.Styler scopeStyler;
        private final StyledString.Styler tinyFontStyler;

        private StyledLabelDecorator(ILabelProvider labelProvider, StyledString.Styler tinyFontStyler) {
            this.color = FindAndReplaceTarget.this.workbenchPart.getSite().getWorkbenchWindow().getWorkbench().getThemeManager().getCurrentTheme().getColorRegistry().get("org.eclipse.ui.editors.findScope");
            this.scopeStyler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    textStyle.background = StyledLabelDecorator.this.color;
                }
            };
            this.labelProvider = labelProvider;
            this.tinyFontStyler = tinyFontStyler;
        }

        public void removeListener(ILabelProviderListener listener) {
            this.labelProvider.removeListener(listener);
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.labelProvider.isLabelProperty(element, property);
        }

        public void dispose() {
            this.labelProvider.dispose();
        }

        public void addListener(ILabelProviderListener listener) {
            this.labelProvider.addListener(listener);
        }

        public String decorateText(String text, Object element) {
            if (this.labelProvider instanceof ILabelDecorator) {
                ILabelDecorator labelDecorator = (ILabelDecorator)this.labelProvider;
                return labelDecorator.decorateText(text, element);
            }
            return text;
        }

        public Image decorateImage(Image image, Object element) {
            if (this.labelProvider instanceof ILabelDecorator) {
                ILabelDecorator labelDecorator = (ILabelDecorator)this.labelProvider;
                return labelDecorator.decorateImage(image, element);
            }
            return image;
        }

        public StyledString decorateStyledText(StyledString styledString, Object element) {
            if (this.labelProvider instanceof IStyledLabelDecorator) {
                IStyledLabelDecorator styledLabelDecorator = (IStyledLabelDecorator)this.labelProvider;
                styledString = styledLabelDecorator.decorateStyledText(styledString, element);
            }
            if (FindAndReplaceTarget.this.selectedItem != null && ((FindAndReplaceTarget)FindAndReplaceTarget.this).selectedItem.itemPropertyDescriptor == null && element == ((FindAndReplaceTarget)FindAndReplaceTarget.this).selectedItem.data.object) {
                String string = styledString.getString();
                Matcher matcher = FindAndReplaceTarget.this.selectedItemPattern.matcher(string);
                if (matcher.find(FindAndReplaceTarget.this.selectedItemStart)) {
                    StyledString result = new StyledString();
                    String group = matcher.group();
                    int start = matcher.start();
                    int end = matcher.end();
                    result.append(string.substring(0, start));
                    StyledString.Styler tinyPadding = new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            MATCH_STYLER.applyStyles(textStyle);
                            StyledLabelDecorator.this.tinyFontStyler.applyStyles(textStyle);
                        }
                    };
                    result.append(" ", tinyPadding);
                    result.append(group, MATCH_STYLER);
                    result.append(" ", tinyPadding);
                    result.append(string.substring(end));
                    result.append(" ", this.tinyFontStyler);
                    return result;
                }
            }
            if (FindAndReplaceTarget.this.selectionScopeObjects != null && FindAndReplaceTarget.this.selectionScopeObjects.contains(element)) {
                StyledString result = new StyledString();
                result.append(styledString.getString(), this.scopeStyler);
                result.append(" ", this.tinyFontStyler);
                return result;
            }
            styledString.append(" ", this.tinyFontStyler);
            return styledString;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TextData
    implements Iterable<Data> {
        private final StructuredViewer viewer;
        private final Collator collator;
        private final ILabelProvider labelProvider;
        private final IPropertySourceProvider propertySourceProvider;

        public TextData(StructuredViewer viewer, Collator collator) {
            this.viewer = viewer;
            this.collator = collator;
            this.labelProvider = (ILabelProvider)viewer.getLabelProvider();
            IContentProvider contentProvider = viewer.getContentProvider();
            this.propertySourceProvider = contentProvider instanceof IPropertySourceProvider ? (IPropertySourceProvider)contentProvider : null;
        }

        @Override
        public Iterator<Data> iterator() {
            final StructuredViewerTreeIterator structuredViewerTreeIterator = StructuredViewerTreeIterator.create(this.viewer);
            return new Iterator<Data>(){
                private List<Data> parents = new ArrayList<Data>();
                private int index;

                @Override
                public boolean hasNext() {
                    return structuredViewerTreeIterator.hasNext();
                }

                @Override
                public Data next() {
                    IPropertySource propertySource;
                    int depth = structuredViewerTreeIterator.size();
                    Object object = structuredViewerTreeIterator.next();
                    ArrayList<Data.Item> items = new ArrayList<Data.Item>();
                    Data data = new Data(depth - 1, object, items);
                    if (this.parents.size() < depth) {
                        this.parents.add(data);
                    } else {
                        this.parents.set(depth - 1, data);
                    }
                    if (depth > 1) {
                        data.parent = this.parents.get(depth - 2);
                    }
                    String label = TextData.this.labelProvider.getText(object);
                    items.add(new Data.Item(data, this.index, null, 0, label));
                    this.index += label.length();
                    if (TextData.this.propertySourceProvider != null && (propertySource = TextData.this.propertySourceProvider.getPropertySource(object)) instanceof PropertySource) {
                        PropertySource emfPropertySource = (PropertySource)propertySource;
                        IItemPropertySource itemPropertySource = emfPropertySource.getItemPropertySource();
                        this.visit(items, data, itemPropertySource, object);
                    }
                    return data;
                }

                private void visit(List<Data.Item> items, Data data, IItemPropertySource itemPropertySource, Object object) {
                    for (IItemPropertyDescriptor iItemPropertyDescriptor : TextData.this.sort(itemPropertySource.getPropertyDescriptors(object), object)) {
                        Object propertyValue;
                        List<String> text = FindAndReplaceTarget.getText(iItemPropertyDescriptor, object);
                        if (text != null) {
                            int i = 0;
                            int size = text.size();
                            while (i < size) {
                                String value = text.get(i);
                                items.add(new Data.Item(data, this.index, iItemPropertyDescriptor, i, value));
                                this.index += value.length();
                                ++i;
                            }
                        }
                        if (!((propertyValue = iItemPropertyDescriptor.getPropertyValue(object)) instanceof IItemPropertySource)) continue;
                        IItemPropertySource childPropertySource = (IItemPropertySource)propertyValue;
                        this.visit(items, data, childPropertySource, propertyValue);
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        protected List<? extends IItemPropertyDescriptor> sort(List<IItemPropertyDescriptor> propertyDescriptors, Object object) {
            AbstractMap categorizedPropertyDescriptors = this.collator == null ? new LinkedHashMap() : new TreeMap(this.collator);
            for (IItemPropertyDescriptor itemPropertyDescriptor : propertyDescriptors) {
                LinkedHashMap<String, IItemPropertyDescriptor> sortedItemPropertyDescriptors;
                String category = itemPropertyDescriptor.getCategory(object);
                if (category == null) {
                    category = EMFEditUIPlugin.INSTANCE.getString("_UI_Misc_property_category");
                }
                if ((sortedItemPropertyDescriptors = (LinkedHashMap<String, IItemPropertyDescriptor>)categorizedPropertyDescriptors.get(category)) == null) {
                    sortedItemPropertyDescriptors = this.collator == null ? new LinkedHashMap() : new TreeMap(Collator.getInstance());
                    categorizedPropertyDescriptors.put(category, sortedItemPropertyDescriptors);
                }
                sortedItemPropertyDescriptors.put(itemPropertyDescriptor.getDisplayName(object), itemPropertyDescriptor);
            }
            ArrayList result = new ArrayList(propertyDescriptors.size());
            for (Map sortedItemPropertyDescriptors : categorizedPropertyDescriptors.values()) {
                result.addAll(sortedItemPropertyDescriptors.values());
            }
            return result;
        }
    }
}

