/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.internal.security.storage.SlashEncode;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;
import org.eclipse.oomph.setup.internal.core.StringFilter;
import org.eclipse.oomph.setup.util.StringExpander;
import org.eclipse.oomph.util.StringUtil;

public class StringFilterRegistry {
    public static final StringFilterRegistry INSTANCE = new StringFilterRegistry();
    private static final Pattern CAMEL_PATTERN = Pattern.compile("(?:[^\\p{Alnum}]+|^)(\\p{Lower})?");
    private final Map<String, StringFilter> filters = new HashMap<String, StringFilter>();

    private StringFilterRegistry() {
        this.registerFilter("file", new StringFilter(){

            public String filter(String value) {
                return URI.createURI((String)value).toFileString();
            }
        });
        this.registerFilter("uri", new StringFilter(){

            public String filter(String value) {
                return URI.createFileURI((String)value).toString();
            }
        });
        this.registerFilter("uriLastSegment", new StringFilter(){

            public String filter(String value) {
                URI uri = URI.createURI((String)value);
                if (!uri.isHierarchical()) {
                    uri = URI.createURI((String)uri.opaquePart());
                }
                return URI.decode((String)uri.lastSegment());
            }
        });
        this.registerFilter("gitRepository", new StringFilter(){

            public String filter(String value) {
                String result;
                URI uri = URI.createURI((String)value);
                if (!uri.isHierarchical()) {
                    uri = URI.createURI((String)uri.opaquePart());
                }
                if ((result = URI.decode((String)uri.lastSegment())) != null && result.endsWith(".git")) {
                    result = result.substring(0, result.length() - 4);
                }
                return result;
            }
        });
        this.registerFilter("username", new StringFilter(){

            public String filter(String value) {
                return URI.encodeSegment((String)value, (boolean)false).replace(":", "%3A").replace("@", "%40");
            }
        });
        this.registerFilter("canonical", new StringFilter(){

            public String filter(String value) {
                if (StringExpander.STRING_EXPANSION_PATTERN.matcher(value).find()) {
                    return value;
                }
                File file = new File(value).getAbsoluteFile();
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    return file.getAbsolutePath();
                }
            }
        });
        this.registerFilter("preferenceNode", new StringFilter(){

            public String filter(String value) {
                return value.replaceAll("/", "\\\\2f");
            }
        });
        this.registerFilter("length", new StringFilter(){

            public String filter(String value) {
                return Integer.toString(value.length());
            }
        });
        this.registerFilter("trim", new StringFilter(){

            public String filter(String value) {
                return value.trim();
            }
        });
        this.registerFilter("trimLeft", new StringFilter(){

            public String filter(String value) {
                return StringUtil.trimLeft((String)value);
            }
        });
        this.registerFilter("trimRight", new StringFilter(){

            public String filter(String value) {
                return StringUtil.trimRight((String)value);
            }
        });
        this.registerFilter("trimTrailingSlashes", new StringFilter(){

            public String filter(String value) {
                return StringUtil.trimTrailingSlashes((String)value);
            }
        });
        this.registerFilter("upper", new StringFilter(){

            public String filter(String value) {
                return value.toUpperCase();
            }
        });
        this.registerFilter("lower", new StringFilter(){

            public String filter(String value) {
                return value.toLowerCase();
            }
        });
        this.registerFilter("cap", new StringFilter(){

            public String filter(String value) {
                return StringUtil.cap((String)value);
            }
        });
        this.registerFilter("allCap", new StringFilter(){

            public String filter(String value) {
                return StringUtil.capAll((String)value);
            }
        });
        this.registerFilter("qualifiedName", new StringFilter(){

            public String filter(String value) {
                return value.trim().replaceAll("[^\\p{Alnum}]+", ".").toLowerCase();
            }
        });
        this.registerFilter("camel", new StringFilter(){

            public String filter(String value) {
                Matcher matcher = CAMEL_PATTERN.matcher(value);
                StringBuffer result = new StringBuffer();
                while (matcher.find()) {
                    String group = matcher.group(1);
                    matcher.appendReplacement(result, group == null ? "" : group.toUpperCase());
                }
                matcher.appendTail(result);
                return result.toString();
            }
        });
        this.registerFilter("property", new StringFilter(){

            public String filter(String value) {
                return value.replaceAll("\\\\", "\\\\\\\\");
            }
        });
        this.registerFilter("path", new StringFilter(){

            public String filter(String value) {
                return value.replaceAll("\\\\", "/");
            }
        });
        this.registerFilter("basePath", new StringFilter(){

            public String filter(String value) {
                int pos = (value = value.replaceAll("\\\\", "/")).lastIndexOf(47);
                if (pos == -1) {
                    return "";
                }
                return value.substring(0, pos);
            }
        });
        this.registerFilter("lastSegment", new StringFilter(){

            public String filter(String value) {
                int pos = Math.max(value.lastIndexOf(47), value.lastIndexOf(92));
                if (pos == -1) {
                    return value;
                }
                return value.substring(pos + 1);
            }
        });
        this.registerFilter("fileExtension", new StringFilter(){

            public String filter(String value) {
                int pos = value.lastIndexOf(46);
                if (pos == -1) {
                    return "";
                }
                return value.substring(pos + 1);
            }
        });
        this.registerFilter("urlEncode", new StringFilter(){

            public String filter(String value) {
                try {
                    return URLEncoder.encode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return value;
                }
            }
        });
        this.registerFilter("urlDecode", new StringFilter(){

            public String filter(String value) {
                try {
                    return URLDecoder.decode(value, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    return value;
                }
            }
        });
        this.registerFilter("slashEncode", new StringFilter(){

            public String filter(String value) {
                try {
                    return SlashEncode.encode((String)value);
                }
                catch (Throwable throwable) {
                    return value;
                }
            }
        });
        this.registerFilter("slashDecode", new StringFilter(){

            public String filter(String value) {
                try {
                    return SlashEncode.decode((String)value);
                }
                catch (Throwable throwable) {
                    return value;
                }
            }
        });
        this.registerFilter("propertyValue", new StringFilter(){

            public String filter(String value) {
                PreferencesUtil.PreferenceProperty preferenceProperty = new PreferencesUtil.PreferenceProperty(value);
                String result = preferenceProperty.get(null);
                return result == null ? "" : result;
            }
        });
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        System.out.println(URLEncoder.encode("file:/C:/develop/", "UTF-8"));
    }

    public String filter(String value, String filterName) {
        StringFilter filter = this.filters.get(filterName.toLowerCase());
        if (filter != null) {
            return filter.filter(value);
        }
        return value;
    }

    void initContributions() {
        if (SetupCorePlugin.INSTANCE.isOSGiRunning()) {
            try {
                IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
                IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor("org.eclipse.oomph.setup.core.stringFilters");
                int n = iConfigurationElementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                    String filterName = configurationElement.getAttribute("name");
                    if (!this.filters.containsKey(filterName)) {
                        try {
                            StringFilter filter = (StringFilter)configurationElement.createExecutableExtension("class");
                            this.registerFilter(filterName, filter);
                        }
                        catch (Exception ex) {
                            SetupCorePlugin.INSTANCE.log(ex);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                SetupCorePlugin.INSTANCE.log(ex);
            }
        }
    }

    private void registerFilter(String filterName, StringFilter filter) {
        this.filters.put(filterName.toLowerCase(), filter);
    }
}

