/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.ScopeType;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.Trigger;
import org.eclipse.oomph.setup.User;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.util.PropertiesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetupTaskItemProvider
extends ModelElementItemProvider {
    private static final Map<Set<Trigger>, IItemLabelProvider> EXCLUSION_LABEL_PROVIDERS = new HashMap<Set<Trigger>, IItemLabelProvider>();

    static {
        for (Set validTriggers : Trigger.LITERALS.keySet()) {
            final HashMap<Set, String> exclusionLabels = new HashMap<Set, String>();
            for (Set triggers : Trigger.LITERALS.keySet()) {
                LinkedHashSet compliment = new LinkedHashSet(validTriggers);
                compliment.removeAll(triggers);
                exclusionLabels.put(triggers, (String)Trigger.LITERALS.get(compliment));
            }
            EXCLUSION_LABEL_PROVIDERS.put(validTriggers, new IItemLabelProvider(){

                public String getText(Object object) {
                    return (String)exclusionLabels.get(object);
                }

                public Object getImage(Object object) {
                    return null;
                }
            });
        }
    }

    public SetupTaskItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addIDPropertyDescriptor(object);
            this.addDescriptionPropertyDescriptor(object);
            this.addScopeTypePropertyDescriptor(object);
            this.addExcludedTriggersPropertyDescriptor(object);
            this.addDisabledPropertyDescriptor(object);
            this.addPredecessorsPropertyDescriptor(object);
            this.addSuccessorsPropertyDescriptor(object);
            this.addRestrictionsPropertyDescriptor(object);
            this.addFilterPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addPredecessorsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SetupTask_predecessors_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SetupTask_predecessors_feature", "_UI_SetupTask_type"), (EStructuralFeature)SetupPackage.Literals.SETUP_TASK__PREDECESSORS, true, false, true, null, null, new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addSuccessorsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SetupTask_successors_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SetupTask_successors_feature", "_UI_SetupTask_type"), (EStructuralFeature)SetupPackage.Literals.SETUP_TASK__SUCCESSORS, true, false, true, null, null, new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addIDPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SetupTask_iD_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SetupTask_iD_feature", "_UI_SetupTask_type"), (EStructuralFeature)SetupPackage.Literals.SETUP_TASK__ID, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addRestrictionsPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SetupTask_restrictions_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SetupTask_restrictions_feature", "_UI_SetupTask_type"), (EStructuralFeature)SetupPackage.Literals.SETUP_TASK__RESTRICTIONS, true, false, true, null, null, new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addFilterPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SetupTask_filter_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SetupTask_filter_feature", "_UI_SetupTask_type"), (EStructuralFeature)SetupPackage.Literals.SETUP_TASK__FILTER, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected Object filterParent(AdapterFactoryItemDelegator itemDelegator, EStructuralFeature feature, Object object) {
        Object result = super.filterParent(itemDelegator, feature, object);
        if (result instanceof Index) {
            return null;
        }
        return result;
    }

    protected Collection<?> filterChoices(Collection<?> choices, EStructuralFeature feature, Object object) {
        SetupTask setupTask = (SetupTask)object;
        int featureID = setupTask.eClass().getFeatureID(feature);
        switch (featureID) {
            case 8: {
                ScopeType scope = setupTask.getScopeType();
                ArrayList result = new ArrayList(choices);
                Iterator it = result.iterator();
                block8: while (it.hasNext()) {
                    Object value = it.next();
                    if (!(value instanceof Scope)) continue;
                    Scope restriction = (Scope)value;
                    switch (scope) {
                        case USER: {
                            break;
                        }
                        case PROJECT: 
                        case STREAM: {
                            if (restriction instanceof ProductVersion) continue block8;
                        }
                        default: {
                            it.remove();
                        }
                    }
                }
                return result;
            }
            case 6: 
            case 7: {
                boolean direction = featureID == 6;
                List<Scope> scopes = this.getScopes(setupTask);
                int scopesSize = scopes.size();
                ArrayList result = new ArrayList(choices);
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    List<Scope> targetScopes;
                    int targetScopesSize;
                    Object value = it.next();
                    if (!(value instanceof SetupTask)) continue;
                    SetupTask targetSetupTast = (SetupTask)value;
                    if ((direction ? !targetSetupTast.requires(setupTask) : !setupTask.requires(targetSetupTast)) && !this.onlyHasVariables(targetSetupTast) && (scopesSize == 1 && scopes.get(0) instanceof User || (targetScopesSize = (targetScopes = this.getScopes(targetSetupTast)).size()) <= scopesSize && scopes.subList(0, targetScopesSize).equals(targetScopes))) continue;
                    it.remove();
                }
                return result;
            }
        }
        return super.filterChoices(choices, feature, object);
    }

    private List<Scope> getScopes(SetupTask setupTask) {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        Scope scope = setupTask.getScope();
        while (scope != null) {
            scopes.add(0, scope);
            scope = scope.getParentScope();
        }
        return scopes;
    }

    private boolean onlyHasVariables(SetupTask setupTask) {
        if (setupTask instanceof VariableTask) {
            return true;
        }
        if (setupTask instanceof CompoundTask) {
            CompoundTask compoundTask = (CompoundTask)setupTask;
            for (SetupTask childSetupTask : compoundTask.getSetupTasks()) {
                if (this.onlyHasVariables(childSetupTask)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected void addScopeTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SetupTask_scopeType_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SetupTask_scopeType_feature", "_UI_SetupTask_type"), (EStructuralFeature)SetupPackage.Literals.SETUP_TASK__SCOPE_TYPE, false, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected void addExcludedTriggersPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SetupTask_excludedTriggers_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SetupTask_excludedTriggers_feature", "_UI_SetupTask_type"), (EStructuralFeature)SetupPackage.Literals.SETUP_TASK__EXCLUDED_TRIGGERS, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, PropertiesUtil.EXPERT_FILTER){

            public IItemLabelProvider getLabelProvider(Object object) {
                SetupTask setupTask = (SetupTask)object;
                return (IItemLabelProvider)EXCLUSION_LABEL_PROVIDERS.get(setupTask.getValidTriggers());
            }

            public String getDisplayName(Object object) {
                return "Triggers";
            }

            public String getDescription(Object object) {
                return "The triggers for which the task is applicable";
            }

            public Collection<?> getChoiceOfValues(Object object) {
                SetupTask setupTask = (SetupTask)object;
                Set validTriggers = setupTask.getValidTriggers();
                ArrayList result = new ArrayList(Trigger.LITERALS.keySet());
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    if (validTriggers.containsAll((Collection)it.next())) continue;
                    it.remove();
                }
                Collections.reverse(result);
                return result;
            }
        });
    }

    protected void addDescriptionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SetupTask_description_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SetupTask_description_feature", "_UI_SetupTask_type"), (EStructuralFeature)SetupPackage.Literals.SETUP_TASK__DESCRIPTION, true, true, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addDisabledPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_SetupTask_disabled_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_SetupTask_disabled_feature", "_UI_SetupTask_type"), (EStructuralFeature)SetupPackage.Literals.SETUP_TASK__DISABLED, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, new String[]{"org.eclipse.ui.views.properties.expert"}));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        String label = ((SetupTask)object).getID();
        return label == null || label.length() == 0 ? this.getString("_UI_SetupTask_type") : String.valueOf(this.getString("_UI_SetupTask_type")) + " " + label;
    }

    public void notifyChangedGen(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(SetupTask.class)) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public void notifyChanged(Notification notification) {
        switch (notification.getFeatureID(SetupTask.class)) {
            case 5: {
                this.updateChildren(notification);
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }
}

