/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.util.internal.pde;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.util.internal.pde.UtilPDEPlugin;
import org.eclipse.oomph.util.pde.TargetPlatformUtil;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetFeature;

public class TargetPlatformFeatureLocation
implements IDynamicVariableResolver {
    public String resolveValue(IDynamicVariable variable, String element) throws CoreException {
        try {
            if (!StringUtil.isEmpty((String)element)) {
                int pos = element.lastIndexOf(95);
                String id = pos == -1 ? element : element.substring(0, pos);
                String version = pos == -1 ? null : element.substring(pos + 1);
                ITargetDefinition targetDefinition = TargetPlatformUtil.getActiveTargetDefinition();
                if (!targetDefinition.isResolved()) {
                    targetDefinition.resolve((IProgressMonitor)new NullProgressMonitor());
                }
                TargetFeature[] targetFeatureArray = targetDefinition.getAllFeatures();
                int n = targetFeatureArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String location;
                    TargetFeature feature = targetFeatureArray[n2];
                    if (feature.getId().equals(id) && (version == null || version.equals(feature.getVersion())) && (location = feature.getLocation()) != null) {
                        return location;
                    }
                    ++n2;
                }
            }
        }
        catch (Exception ex) {
            UtilPDEPlugin.INSTANCE.coreException(ex);
        }
        return null;
    }
}

