/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.core.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.base.util.BaseResource;
import org.eclipse.oomph.base.util.BaseUtil;
import org.eclipse.oomph.setup.CatalogSelection;
import org.eclipse.oomph.setup.Index;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.SetupCorePlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalogManager {
    public static final String PROPERTY_INDEX = "PROPERTY_INDEX";
    private Index index;
    private CatalogSelection selection = SetupFactory.eINSTANCE.createCatalogSelection();
    private PropertyChangeSupport propertyChangeSupport;

    public CatalogManager() {
        Resource selectionResource = Resource.Factory.Registry.INSTANCE.getFactory(SetupContext.CATALOG_SELECTION_SETUP_URI).createResource(SetupContext.CATALOG_SELECTION_SETUP_URI);
        selectionResource.getContents().add((Object)this.selection);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    private synchronized PropertyChangeSupport getPropertyChangeSupport() {
        if (this.propertyChangeSupport == null) {
            this.propertyChangeSupport = new PropertyChangeSupport(this);
        }
        return this.propertyChangeSupport;
    }

    public Index getIndex() {
        return this.index;
    }

    public CatalogSelection getSelection() {
        return this.selection;
    }

    public List<? extends Scope> getCatalogs(boolean product) {
        if (this.index == null) {
            return Collections.emptyList();
        }
        List result = (List)this.index.eGet((EStructuralFeature)(product ? SetupPackage.Literals.INDEX__PRODUCT_CATALOGS : SetupPackage.Literals.INDEX__PROJECT_CATALOGS));
        return result;
    }

    public List<? extends Scope> getSelectedCatalogs(boolean product) {
        List result = (List)this.selection.eGet((EStructuralFeature)(product ? SetupPackage.Literals.CATALOG_SELECTION__PRODUCT_CATALOGS : SetupPackage.Literals.CATALOG_SELECTION__PROJECT_CATALOGS));
        return result;
    }

    public void selectCatalog(boolean product, Scope scope, boolean on) {
        boolean changed;
        InternalEList list = (InternalEList)this.selection.eGet((EStructuralFeature)(product ? SetupPackage.Literals.CATALOG_SELECTION__PRODUCT_CATALOGS : SetupPackage.Literals.CATALOG_SELECTION__PROJECT_CATALOGS));
        boolean bl = changed = on ? list.add((Object)scope) : list.remove((Object)scope);
        if (changed) {
            this.saveSelection();
        }
    }

    public void indexLoaded(Index index) {
        if (index == null) {
            return;
        }
        Index oldIndex = this.index;
        this.index = index;
        ResourceSet resourceSet = index.eResource().getResourceSet();
        if (resourceSet.getURIConverter().exists(SetupContext.CATALOG_SELECTION_SETUP_URI, null)) {
            BaseResource selectionResource = BaseUtil.loadResourceSafely((ResourceSet)resourceSet, (URI)SetupContext.CATALOG_SELECTION_SETUP_URI);
            CatalogSelection selection = (CatalogSelection)EcoreUtil.getObjectByType((Collection)selectionResource.getContents(), (EClassifier)SetupPackage.Literals.CATALOG_SELECTION);
            EcoreUtil.resolveAll((Resource)selectionResource);
            selectionResource.getContents().clear();
            selectionResource.getContents().add((Object)this.selection);
            this.updateProxyKeyedMap(this.selection.getDefaultProductVersions());
            this.updateProxyKeyedMap(this.selection.getDefaultStreams());
            if (selection != null) {
                this.selection.getDefaultProductVersions().putAll(selection.getDefaultProductVersions());
                this.selection.getDefaultStreams().putAll(selection.getDefaultStreams());
                EList selectedStreams = this.selection.getSelectedStreams();
                selectedStreams.clear();
                selectedStreams.addAll((Collection)selection.getSelectedStreams());
                EList productCatalogs = this.selection.getProductCatalogs();
                productCatalogs.clear();
                productCatalogs.addAll((Collection)selection.getProductCatalogs());
                this.filter(productCatalogs, index.getProductCatalogs());
                EList projectCatalogs = this.selection.getProjectCatalogs();
                projectCatalogs.clear();
                projectCatalogs.addAll((Collection)selection.getProjectCatalogs());
                this.filter(projectCatalogs, index.getProjectCatalogs());
            }
            this.filterProxies(this.selection.getDefaultProductVersions());
            this.filterProxies(this.selection.getDefaultStreams());
            this.filterProxies((EList<? extends EObject>)this.selection.getProductCatalogs());
            this.filterProxies((EList<? extends EObject>)this.selection.getProjectCatalogs());
            if (this.selection.getProductCatalogs().isEmpty()) {
                this.populateSelectedProductCatalogs(this.selection, index);
            }
            if (this.selection.getProjectCatalogs().isEmpty()) {
                this.populateSelectedProjectCatalogs(this.selection, index);
            }
        } else {
            Resource selectionResource = this.selection.eResource();
            resourceSet.getResources().add((Object)selectionResource);
            this.populateSelectedProductCatalogs(this.selection, index);
            this.populateSelectedProjectCatalogs(this.selection, index);
            this.saveSelection();
        }
        this.getPropertyChangeSupport().firePropertyChange(PROPERTY_INDEX, oldIndex, this.index);
    }

    private <T extends Scope> void filter(EList<T> selectionScopes, EList<T> indexScopes) {
        ArrayList<T> scopes = new ArrayList<T>(indexScopes);
        scopes.retainAll((Collection<?>)selectionScopes);
        Iterator it = scopes.iterator();
        while (it.hasNext()) {
            Scope scope = (Scope)it.next();
            if (!"redirectable".equals(scope.getName())) continue;
            it.remove();
        }
        ECollections.setEList(selectionScopes, scopes);
    }

    private void populateSelectedProductCatalogs(CatalogSelection selection, Index index) {
        EList productCatalogs = selection.getProductCatalogs();
        for (ProductCatalog productCatalog : index.getProductCatalogs()) {
            URI uri = EcoreUtil.getURI((EObject)productCatalog);
            if ("catalog".equals(uri.scheme()) || "self".equals(productCatalog.getName()) || productCatalog.getProducts().isEmpty()) continue;
            productCatalogs.add((Object)productCatalog);
        }
    }

    private void populateSelectedProjectCatalogs(CatalogSelection selection, Index index) {
        EList projectCatalogs = selection.getProjectCatalogs();
        for (ProjectCatalog projectCatalog : index.getProjectCatalogs()) {
            if (projectCatalog.getProjects().isEmpty()) continue;
            projectCatalogs.add((Object)projectCatalog);
        }
    }

    private <K extends EObject, V extends EObject> void updateProxyKeyedMap(EMap<K, V> eMap) {
        BasicEMap originalEMap = new BasicEMap(eMap.map());
        eMap.clear();
        eMap.putAll((EMap)originalEMap);
    }

    private <K extends EObject, V extends EObject> void filterProxies(EMap<K, V> eMap) {
        Iterator it = eMap.iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            EObject key = (EObject)entry.getKey();
            EObject value = (EObject)entry.getValue();
            if (key != null && !key.eIsProxy() && value != null && !value.eIsProxy()) continue;
            it.remove();
        }
    }

    private void filterProxies(EList<? extends EObject> list) {
        Iterator it = list.iterator();
        while (it.hasNext()) {
            if (!((EObject)it.next()).eIsProxy()) continue;
            it.remove();
        }
    }

    public void saveSelection() {
        for (EObject eObject : this.selection.eCrossReferences()) {
            InternalEObject internalEObject = (InternalEObject)eObject;
            InternalEObject eContainer = internalEObject.eInternalContainer();
            while (eContainer != null) {
                if (eContainer.eIsProxy()) {
                    return;
                }
                eContainer = eContainer.eInternalContainer();
            }
        }
        try {
            this.selection.eResource().save(null);
        }
        catch (Exception ex) {
            SetupCorePlugin.INSTANCE.log(ex);
        }
    }
}

