/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.P2Package;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.RepositoryList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryListItemProvider
extends ModelElementItemProvider {
    public RepositoryListItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addNamePropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_RepositoryList_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_RepositoryList_name_feature", "_UI_RepositoryList_type"), (EStructuralFeature)P2Package.Literals.REPOSITORY_LIST__NAME, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(P2Package.Literals.REPOSITORY_LIST__REPOSITORIES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/RepositoryList"));
    }

    protected boolean shouldComposeCreationImage() {
        return true;
    }

    public String getText(Object object) {
        String label = ((RepositoryList)object).getName();
        return label == null || label.length() == 0 ? this.getString("_UI_RepositoryList_type") : label;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(RepositoryList.class)) {
            case 2: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 1: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(P2Package.Literals.REPOSITORY_LIST__REPOSITORIES, P2Factory.eINSTANCE.createRepository()));
    }

    public Command createCommand(Object object, EditingDomain domain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
        if (commandClass == DragAndDropCommand.class) {
            DragAndDropCommand.Detail detail = (DragAndDropCommand.Detail)commandParameter.getFeature();
            Command command = this.createDragAndDropCommand(domain, commandParameter.getOwner(), detail.location, detail.operations, detail.operation, commandParameter.getCollection());
            if (command != null && command.canExecute()) {
                return command;
            }
            return UnexecutableCommand.INSTANCE;
        }
        return super.createCommand(object, domain, commandClass, commandParameter);
    }

    protected Command createPrimaryDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection<?> collection) {
        return new DragAndDropCommand(domain, owner, location, operations, operation, collection){

            protected boolean prepareDropCopyOn() {
                BasicEList objects = new BasicEList();
                for (Object object : this.collection) {
                    if (object instanceof URI) {
                        URI uri = (URI)object;
                        Repository repository = P2Factory.eINSTANCE.createRepository(uri.toString());
                        objects.add((Object)repository);
                        continue;
                    }
                    objects.add(object);
                }
                if (objects.isEmpty()) {
                    return false;
                }
                this.dropCommand = AddCommand.create((EditingDomain)this.domain, (Object)this.owner, null, (Collection)objects);
                if (!this.dropCommand.canExecute()) {
                    return false;
                }
                this.dropCommand.dispose();
                this.optimizedDropCommandOwner = this.owner;
                this.dropCommand = null;
                this.dragCommand = CopyCommand.create((EditingDomain)this.domain, (Collection)objects);
                return this.dragCommand.canExecute();
            }
        };
    }
}

