/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui.tests;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.oomph.tests.AbstractTest;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public abstract class AbstractUITest
extends AbstractTest {
    protected static SWTBot bot;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        bot = new SWTBot().shell("Eclipse Installer").bot();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        bot = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ShellTrackingBot
    extends SWTBot {
        private final Listener skinListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget instanceof Shell) {
                    Shell shell = (Shell)event.widget;
                    ShellTrackingBot.this.addShell(shell);
                }
            }
        };
        private final ShellListener shellListener = new ShellListener(){

            public void shellActivated(ShellEvent e) {
                Shell shell = (Shell)e.widget;
                ShellTrackingBot.this.activeShell = shell;
            }

            public void shellDeactivated(ShellEvent e) {
            }

            public void shellIconified(ShellEvent e) {
                Shell shell = (Shell)e.widget;
                ShellTrackingBot.this.shells.put(shell, true);
            }

            public void shellDeiconified(ShellEvent e) {
                Shell shell = (Shell)e.widget;
                ShellTrackingBot.this.shells.put(shell, false);
            }

            public void shellClosed(ShellEvent e) {
                final Shell shell = (Shell)e.widget;
                if (!shell.isDisposed()) {
                    ShellTrackingBot.this.display.syncExec(new Runnable(){

                        public void run() {
                            shell.removeShellListener(ShellTrackingBot.this.shellListener);
                        }
                    });
                }
                if (shell == ShellTrackingBot.this.activeShell) {
                    ShellTrackingBot.this.activeShell = null;
                }
                ShellTrackingBot.this.shells.remove(shell);
            }
        };
        private final Map<Shell, Boolean> shells = new HashMap<Shell, Boolean>();
        private Shell activeShell;

        public ShellTrackingBot() {
            this.display.syncExec(new Runnable(){

                public void run() {
                    Shell[] shellArray = ShellTrackingBot.this.display.getShells();
                    int n = shellArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Shell shell = shellArray[n2];
                        ShellTrackingBot.this.addShell(shell);
                        ++n2;
                    }
                    ShellTrackingBot.this.display.addListener(45, ShellTrackingBot.this.skinListener);
                }
            });
        }

        public <T extends Widget> T widget(Matcher<T> matcher, Widget parentWidget, int index) {
            this.restoreShells();
            return (T)super.widget(matcher, parentWidget, index);
        }

        public <T extends Widget> T widget(Matcher<T> matcher, int index) {
            this.restoreShells();
            return (T)super.widget(matcher, index);
        }

        public void restoreShells() {
            this.display.syncExec(new Runnable(){

                public void run() {
                    for (Map.Entry entry : ShellTrackingBot.this.shells.entrySet()) {
                        Shell shell = (Shell)entry.getKey();
                        boolean minimized = (Boolean)entry.getValue();
                        if (shell.getMinimized() == minimized) continue;
                        shell.setMinimized(minimized);
                    }
                    if (ShellTrackingBot.this.activeShell != null) {
                        if (ShellTrackingBot.this.activeShell.isDisposed()) {
                            ShellTrackingBot.this.activeShell = null;
                        } else {
                            ShellTrackingBot.this.activeShell.forceActive();
                            ShellTrackingBot.this.activeShell.forceFocus();
                        }
                    }
                }
            });
        }

        private void addShell(Shell shell) {
            if (!this.shells.containsKey(shell)) {
                this.shells.put(shell, shell.getMinimized());
                shell.addShellListener(this.shellListener);
            }
        }
    }
}

