/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.util;

import java.io.Closeable;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;

public abstract class OS {
    public static final OS INSTANCE = OS.create();
    private final String osgiOS;
    private final String osgiWS;
    private final String osgiArch;

    protected OS(String osgiOS, String osgiWS, String osgiArch) {
        this.osgiOS = osgiOS;
        this.osgiWS = osgiWS;
        this.osgiArch = osgiArch;
    }

    public String getOsgiOS() {
        return this.osgiOS;
    }

    public String getOsgiWS() {
        return this.osgiWS;
    }

    public String getOsgiArch() {
        return this.osgiArch;
    }

    public boolean isCurrent() {
        return Platform.getOS().equals(this.osgiOS) && Platform.getWS().equals(this.osgiWS) && Platform.getOSArch().equals(this.osgiArch);
    }

    public boolean isLineEndingConversionNeeded() {
        return false;
    }

    protected String getEncoding() {
        return "ISO-8859-1";
    }

    public final String getEclipseDir() {
        return "eclipse";
    }

    public abstract String getEclipseExecutable();

    public abstract String getEclipseIni();

    public abstract String getGitPrefix();

    public abstract String getJREsRoot();

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static OS create() {
        String os = Platform.getOS();
        String ws = Platform.getWS();
        String arch = Platform.getOSArch();
        if ("win32".equals(os)) {
            if ("x86_64".equals(arch)) {
                return new Win64(ws);
            }
            return new Win32(ws, arch);
        }
        if ("macosx".equals(os)) {
            return new Mac(ws, arch);
        }
        if ("linux".equals(os)) {
            return new Linux(ws, arch);
        }
        throw new IllegalStateException("Operating system not supported: " + os);
    }

    private static final class Linux
    extends OS {
        public Linux(String osgiWS, String osgiArch) {
            super("linux", osgiWS, osgiArch);
        }

        public String getEclipseExecutable() {
            return "eclipse";
        }

        public String getEclipseIni() {
            return "eclipse.ini";
        }

        public String getGitPrefix() {
            return "";
        }

        public String getJREsRoot() {
            return "";
        }
    }

    private static final class Mac
    extends OS {
        public Mac(String osgiWS, String osgiArch) {
            super("macosx", osgiWS, osgiArch);
        }

        public String getEclipseExecutable() {
            return "Eclipse.app/Contents/MacOS/eclipse";
        }

        public String getEclipseIni() {
            return "Eclipse.app/Contents/MacOS/eclipse.ini";
        }

        public String getGitPrefix() {
            return "/";
        }

        public String getJREsRoot() {
            return "/";
        }
    }

    private static class Win32
    extends OS {
        public Win32(String osgiWS, String osgiArch) {
            super("win32", osgiWS, osgiArch);
        }

        public boolean isLineEndingConversionNeeded() {
            return true;
        }

        public String getEclipseExecutable() {
            return "eclipse.exe";
        }

        public String getEclipseIni() {
            return "eclipse.ini";
        }

        public String getGitPrefix() {
            return "C:\\Program Files (x86)\\Git";
        }

        public String getJREsRoot() {
            return "C:\\Program Files (x86)\\Java";
        }
    }

    private static class Win64
    extends Win32 {
        public Win64(String osgiWS) {
            super(osgiWS, "x86_64");
        }

        public String getJREsRoot() {
            return "C:\\Program Files\\Java";
        }
    }
}

