/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.core;

import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.core.ITargletContainerDescriptor;
import org.eclipse.oomph.targlets.core.WorkspaceIUInfo;

public class TargletContainerEvent
extends EventObject {
    private static final long serialVersionUID = 1L;
    private final transient ITargletContainerDescriptor descriptor;

    public TargletContainerEvent(ITargletContainer source, ITargletContainerDescriptor descriptor) {
        super(source);
        this.descriptor = descriptor;
    }

    public final ITargletContainer getSource() {
        return (ITargletContainer)super.getSource();
    }

    public final ITargletContainerDescriptor getDescriptor() {
        return this.descriptor;
    }

    public static class IDChangedEvent
    extends TargletContainerEvent {
        private static final long serialVersionUID = 1L;
        private final String oldID;

        public IDChangedEvent(ITargletContainer source, ITargletContainerDescriptor descriptor, String oldID) {
            super(source, descriptor);
            this.oldID = oldID;
        }

        public String getOldID() {
            return this.oldID;
        }

        public String toString() {
            return "TargletsChangedEvent[source=" + this.getSource().getID() + ", oldID=" + this.oldID + "]";
        }
    }

    public static class ProfileUpdateFailedEvent
    extends TargletContainerEvent {
        private static final long serialVersionUID = 1L;
        private final transient IStatus updateProblem;

        public ProfileUpdateFailedEvent(ITargletContainer source, ITargletContainerDescriptor descriptor, IStatus updateProblem) {
            super(source, descriptor);
            this.updateProblem = updateProblem;
        }

        public final IStatus getUpdateProblem() {
            return this.updateProblem;
        }

        public String toString() {
            return "ProfileUpdateFailedEvent[source=" + this.getSource().getID() + ", updateProblem=" + this.updateProblem + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProfileUpdateSucceededEvent
    extends TargletContainerEvent {
        private static final long serialVersionUID = 1L;
        private final transient Profile profile;
        private final transient List<IMetadataRepository> metadataRepositories;
        private final transient IProvisioningPlan provisioningPlan;
        private final transient Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos;

        public ProfileUpdateSucceededEvent(ITargletContainer source, ITargletContainerDescriptor descriptor, Profile profile, List<IMetadataRepository> metadataRepositories, IProvisioningPlan provisioningPlan, Map<IInstallableUnit, WorkspaceIUInfo> workspaceIUInfos) {
            super(source, descriptor);
            this.profile = profile;
            this.metadataRepositories = metadataRepositories;
            this.provisioningPlan = provisioningPlan;
            this.workspaceIUInfos = workspaceIUInfos;
        }

        public final Profile getProfile() {
            return this.profile;
        }

        public final List<IMetadataRepository> getMetadataRepositories() {
            return this.metadataRepositories;
        }

        public final IProvisioningPlan getProvisioningPlan() {
            return this.provisioningPlan;
        }

        public final Map<IInstallableUnit, WorkspaceIUInfo> getWorkspaceIUInfos() {
            return this.workspaceIUInfos;
        }

        @Override
        public String toString() {
            return "ProfileUpdateSucceededEvent[source=" + this.getSource().getID() + ", metadataRepositories=" + this.metadataRepositories + ", profile=" + this.profile + ", provisioningPlan=" + this.provisioningPlan + ", workspaceIUInfos=" + this.workspaceIUInfos + "]";
        }
    }

    public static class TargletsChangedEvent
    extends TargletContainerEvent {
        private static final long serialVersionUID = 1L;

        public TargletsChangedEvent(ITargletContainer source, ITargletContainerDescriptor descriptor) {
            super(source, descriptor);
        }

        public String toString() {
            return "TargletsChangedEvent[source=" + this.getSource().getID() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WorkspaceUpdateFinishedEvent
    extends TargletContainerEvent {
        private static final long serialVersionUID = 1L;
        private final transient Map<WorkspaceIUInfo, ResourcesUtil.ImportResult> importResults;

        public WorkspaceUpdateFinishedEvent(ITargletContainer source, ITargletContainerDescriptor descriptor, Map<WorkspaceIUInfo, ResourcesUtil.ImportResult> importResults) {
            super(source, descriptor);
            this.importResults = Collections.unmodifiableMap(importResults);
        }

        public final Map<WorkspaceIUInfo, ResourcesUtil.ImportResult> getImportResults() {
            return this.importResults;
        }

        @Override
        public String toString() {
            return "WorkspaceUpdateFinishedEvent[source=" + this.getSource().getID() + ", importResults=" + this.importResults + "]";
        }
    }
}

