/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.dal.driver.custom.functions;

import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.dal.driver.sample.Activator;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.dal.Function;
import org.osgi.service.dal.OperationMetadata;
import org.osgi.service.dal.PropertyMetadata;

public abstract class BaseFunction {
    private static Log LOGGER = LogFactory.getLog(BaseFunction.class);
    protected Dictionary<String, Object> props = null;
    protected Dictionary<String, PropertyMetadata> propMetadatas = null;
    protected Dictionary<String, OperationMetadata> oprMetadatas = null;
    protected String funcionId = "";
    protected String uid = "";
    protected String deviceUid = "";
    protected ServiceReference<?> funcRef = null;
    protected ServiceRegistration<?> funcReg = null;

    public BaseFunction(String deviceUid, String serviceType, String funcionId) {
        this.funcionId = funcionId;
        this.deviceUid = deviceUid;
        this.uid = String.valueOf(deviceUid) + ":" + funcionId;
        this.props = new Hashtable<String, Object>();
        this.props.put("dal.function.UID", this.uid);
        this.props.put("dal.function.type", serviceType);
        this.props.put("dal.function.device.UID", deviceUid);
        this.propMetadatas = new Hashtable<String, PropertyMetadata>();
        this.oprMetadatas = new Hashtable<String, OperationMetadata>();
        this.setupFuncProperties();
        this.setupPropertyMetadata();
        this.setupOperationMetadata();
        LOGGER.info((Object)("Register function (" + this.uid + ") ..."));
        this.funcReg = Activator.getContext().registerService(Function.class.getName(), (Object)this, this.props);
        this.funcRef = this.funcReg.getReference();
        LOGGER.info((Object)("Function (" + this.uid + ") is registered."));
    }

    public void remove() {
        this.funcReg.unregister();
    }

    public Object getServiceProperty(String propKey) {
        if (this.funcRef != null) {
            return this.funcRef.getProperty(propKey);
        }
        return this.props.get(propKey);
    }

    public PropertyMetadata getPropertyMetadata(String propertyName) {
        return this.propMetadatas.get(propertyName);
    }

    public OperationMetadata getOperationMetadata(String operationName) {
        return this.oprMetadatas.get(operationName);
    }

    public String[] getServicePropertyKeys() {
        if (this.funcRef != null) {
            return this.funcRef.getPropertyKeys();
        }
        String[] keys = new String[this.props.size()];
        int count = 0;
        Enumeration<String> key = this.props.keys();
        while (key.hasMoreElements()) {
            keys[count++] = key.nextElement();
        }
        return keys;
    }

    protected abstract void setupFuncProperties();

    protected abstract void setupPropertyMetadata();

    protected abstract void setupOperationMetadata();
}

