/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Element;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.Property;
import org.eclipse.om2m.sdt.SubDevice;
import org.eclipse.om2m.sdt.utils.Logger;

public class Device
extends Element {
    private Map<String, Module> modules;
    private Map<String, Property> properties;
    private Map<String, SubDevice> devices;
    private String definition;
    private String longDefinitionName;
    private String shortDefinitionName;

    public Device(String id, Domain domain, Identifiers identifiers) {
        super(String.valueOf(identifiers.getDefinition()) + "__" + id);
        if (domain.getDevice(this.getName()) != null) {
            throw new IllegalArgumentException("Already a device with name " + this.getName() + " in domain " + domain);
        }
        this.definition = identifiers.getDefinition();
        this.longDefinitionName = identifiers.getLongName();
        this.shortDefinitionName = identifiers.getShortName();
        this.modules = new HashMap<String, Module>();
        this.properties = new HashMap<String, Property>();
        this.devices = new HashMap<String, SubDevice>();
        domain.addDevice(this);
    }

    public String getId() {
        return this.getName();
    }

    public String getPid() {
        return this.getName().replaceAll("\\.", "_");
    }

    public String getDefinition() {
        return this.definition;
    }

    public String getLongDefinitionName() {
        return this.longDefinitionName;
    }

    public String getShortDefinitionName() {
        return this.shortDefinitionName;
    }

    public Collection<String> getModuleNames() {
        return this.modules.keySet();
    }

    public Collection<Module> getModules() {
        return this.modules.values();
    }

    public Module getModule(String name) {
        return this.modules.get(name);
    }

    public void addModule(Module module) {
        if (this.modules.get(module.getName()) != null) {
            throw new IllegalArgumentException("Already a module with name " + module.getName() + " on device " + this.getName());
        }
        Logger.info("SUPER add module " + module, this.getClass());
        module.setOwner(this);
        this.modules.put(module.getName(), module);
    }

    public void removeModule(String name) {
        this.modules.remove(name);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    public Property getProperty(String name) {
        return this.properties.get(name);
    }

    public Property getProperty(String name, boolean shortName) {
        if (shortName) {
            return this.properties.get(name);
        }
        for (Property prop : this.properties.values()) {
            if (!prop.getName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public void addProperty(Property property) {
        this.properties.put(property.getName(), property);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public Collection<String> getSubDeviceNames() {
        return this.devices.keySet();
    }

    public Collection<SubDevice> getSubDevices() {
        return this.devices.values();
    }

    public SubDevice getSubDevice(String name) {
        return this.devices.get(name);
    }

    public void addSubDevice(SubDevice device) {
        if (this.devices.get(device.getName()) != null) {
            throw new IllegalArgumentException("Already a subdevice with name " + device.getName() + " on device " + this.getName());
        }
        this.devices.put(device.getName(), device);
    }

    public void removeSubDevice(String name) {
        this.devices.remove(name);
    }

    @Override
    protected String prettyPrint(String t1) {
        String t2 = String.valueOf(t1) + "\t";
        StringBuffer ret = new StringBuffer(t1).append("<Device id=\"").append(this.getId()).append("\">");
        if (this.getDoc() != null) {
            ret.append("\n").append(t2).append(this.getDoc());
        }
        this.prettyPrint(ret, this.properties.values(), "Properties", t2);
        this.prettyPrint(ret, this.modules.values(), "Modules", t2);
        this.prettyPrint(ret, this.devices.values(), "SubDevices", t2);
        return ret.append("\n").append(t1).append("</Device>").toString();
    }

    protected void finalize() throws Throwable {
        Logger.info("finalize " + this);
        this.modules.clear();
        this.devices.clear();
        this.properties.clear();
    }
}

