/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class LiquidLevel
extends Module {
    private org.eclipse.om2m.sdt.home.types.LiquidLevel liquidLevel;

    public LiquidLevel(String name, Domain domain, org.eclipse.om2m.sdt.home.types.LiquidLevel liquidLevel) {
        super(name, domain, (Identifiers)ModuleType.liquidLevel);
        if (liquidLevel == null || !liquidLevel.getShortDefinitionType().equals(DatapointType.liquidLevel.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong liquidLevel datapoint: " + (Object)((Object)liquidLevel));
        }
        this.liquidLevel = liquidLevel;
        liquidLevel.setDoc("The desired quantity of supplies to be used; e.g. of rinse liquid, of water, of milk in a cup of coffee.");
        this.addDataPoint((DataPoint)liquidLevel);
    }

    public LiquidLevel(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (org.eclipse.om2m.sdt.home.types.LiquidLevel)dps.get(DatapointType.liquidLevel.getShortName()));
    }

    public int getLiquidLevel() throws DataPointException, AccessException {
        return (Integer)this.liquidLevel.getValue();
    }

    public void setLiquidLevel(int v) throws DataPointException, AccessException {
        this.liquidLevel.setValue(v);
    }
}

