/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.binding.coap;

import ch.ethz.inf.vs.californium.coap.CoAP;
import ch.ethz.inf.vs.californium.coap.Option;
import ch.ethz.inf.vs.californium.coap.OptionSet;
import ch.ethz.inf.vs.californium.coap.Request;
import ch.ethz.inf.vs.californium.coap.Response;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.binding.service.RestClientService;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.Attribute;
import org.eclipse.om2m.commons.resource.FilterCriteria;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;

public class CoapClient
implements RestClientService {
    private static Log LOGGER = LogFactory.getLog(CoapClient.class);
    private static String protocol = "coap";

    public String getProtocol() {
        return protocol;
    }

    public ResponsePrimitive sendRequest(RequestPrimitive requestPrimitive) {
        OptionSet options;
        Request request;
        ResponsePrimitive responsePrimitive;
        String url;
        block90: {
            block88: {
                LOGGER.debug((Object)("Sending request with CoAP binding: " + requestPrimitive));
                url = requestPrimitive.getTo();
                if (!url.startsWith(String.valueOf(protocol) + "://")) {
                    url = url.startsWith("://") ? String.valueOf(protocol) + url : (url.startsWith("//") ? String.valueOf(protocol) + ":" + url : String.valueOf(protocol) + "://" + url);
                }
                responsePrimitive = new ResponsePrimitive();
                String representation = requestPrimitive.getContent() != null ? requestPrimitive.getContent().toString() : null;
                CoAP.Code code = null;
                BigInteger operation = requestPrimitive.getOperation();
                if (operation != null) {
                    if (operation.equals(Operation.CREATE)) {
                        code = CoAP.Code.POST;
                    } else if (operation.equals(Operation.RETRIEVE) || operation.equals(Operation.DISCOVERY)) {
                        code = CoAP.Code.GET;
                    } else if (operation.equals(Operation.UPDATE)) {
                        code = CoAP.Code.PUT;
                    } else if (operation.equals(Operation.DELETE)) {
                        code = CoAP.Code.DELETE;
                    } else if (operation.equals(Operation.NOTIFY)) {
                        code = CoAP.Code.POST;
                    }
                } else {
                    return responsePrimitive;
                }
                request = new Request(code);
                options = new OptionSet();
                request.setOptions(options);
                int MId = (int)(1000.0 + Math.random() * 9001.0);
                request.setMID(MId);
                CoAP.Type coapType = CoAP.Type.CON;
                request.setType(coapType);
                request.setURI(url);
                if (representation != null) {
                    request.setPayload(representation);
                }
                if (requestPrimitive.getRequestContentType() == null) break block88;
                switch (requestPrimitive.getRequestContentType()) {
                    case "application/xml": {
                        request.getOptions().setContentFormat(41);
                        break;
                    }
                    case "application/vnd.onem2m-res+xml": {
                        request.getOptions().setContentFormat(10000);
                        break;
                    }
                    case "application/json": {
                        request.getOptions().setContentFormat(50);
                        break;
                    }
                    case "application/vnd.onem2m-res+json": {
                        request.getOptions().setContentFormat(10001);
                    }
                }
            }
            if (requestPrimitive.getReturnContentType() == null) break block90;
            switch (requestPrimitive.getReturnContentType()) {
                case "application/xml": {
                    request.getOptions().setAccept(41);
                    break;
                }
                case "application/vnd.onem2m-res+xml": {
                    request.getOptions().setAccept(10000);
                    break;
                }
                case "application/json": {
                    request.getOptions().setAccept(50);
                    break;
                }
                case "application/vnd.onem2m-res+json": {
                    request.getOptions().setAccept(10001);
                }
            }
        }
        if (requestPrimitive.getFrom() != null) {
            options.addOption(new Option(256, requestPrimitive.getFrom()));
        }
        if (requestPrimitive.getRequestIdentifier() != null) {
            options.addOption(new Option(257, requestPrimitive.getRequestIdentifier()));
        }
        if (requestPrimitive.getResourceType() != null) {
            options.addOption(new Option(267, requestPrimitive.getResourceType().intValue()));
        }
        if (requestPrimitive.getEventCategory() != null) {
            options.addOption(new Option(264, requestPrimitive.getEventCategory()));
        }
        if (!requestPrimitive.getQueryStrings().isEmpty()) {
            for (String queryStringKey : requestPrimitive.getQueryStrings().keySet()) {
                for (Iterator value : (List)requestPrimitive.getQueryStrings().get(queryStringKey)) {
                    options.addURIQuery(String.valueOf(queryStringKey) + "=" + value);
                }
            }
        }
        if (requestPrimitive.getResponseTypeInfo() != null) {
            if (!requestPrimitive.getResponseTypeInfo().getNotificationURI().isEmpty()) {
                String notifUris = "";
                for (String nu : requestPrimitive.getResponseTypeInfo().getNotificationURI()) {
                    notifUris = String.valueOf(notifUris) + nu + "&";
                }
                if (notifUris.endsWith("&")) {
                    notifUris = notifUris.substring(0, notifUris.length() - 1);
                }
                options.addOption(new Option(263, notifUris));
            }
            if (requestPrimitive.getResponseTypeInfo().getResponseType() != null) {
                options.addURIQuery("rt=" + requestPrimitive.getResponseTypeInfo().getResponseType());
            }
        }
        if (requestPrimitive.getResultPersistence() != null) {
            options.addURIQuery("rp=" + requestPrimitive.getResultPersistence());
        }
        if (requestPrimitive.getResultContent() != null) {
            options.addURIQuery("rcn=" + requestPrimitive.getResultContent());
        }
        if (requestPrimitive.getDiscoveryResultType() != null) {
            options.addURIQuery("drt=" + requestPrimitive.getDiscoveryResultType());
        }
        if (requestPrimitive.getFilterCriteria() != null) {
            FilterCriteria filter = requestPrimitive.getFilterCriteria();
            if (!filter.getAttribute().isEmpty()) {
                for (Attribute att : filter.getAttribute()) {
                    options.addURIQuery(String.valueOf(att.getName()) + "=" + att.getValue());
                }
            }
            if (filter.getFilterUsage() != null) {
                options.addURIQuery("fu=" + filter.getFilterUsage());
            }
            if (!filter.getLabels().isEmpty()) {
                for (String label : filter.getLabels()) {
                    options.addURIQuery("lbl=" + label);
                }
            }
            if (filter.getLimit() != null) {
                options.addURIQuery("lim=" + filter.getLimit());
            }
            if (filter.getResourceType() != null) {
                options.addURIQuery("rty=" + filter.getResourceType());
            }
        }
        if (requestPrimitive.getGroupRequestIdentifier() != null) {
            options.addOption(new Option(266, requestPrimitive.getGroupRequestIdentifier()));
        }
        request.setScheme(url);
        request.send();
        Response response = null;
        try {
            response = request.waitForResponse();
        }
        catch (InterruptedException e) {
            LOGGER.error((Object)("CoAP Client > Failed to receive response: " + e.getMessage()), (Throwable)e);
            responsePrimitive.setResponseStatusCode(ResponseStatusCode.TARGET_NOT_REACHABLE);
            responsePrimitive.setContent((Object)"Target is not reachable");
            responsePrimitive.setContentType("text/plain");
            return responsePrimitive;
        }
        if (response != null) {
            if (response.getOptions().hasContentFormat(40)) {
                String linkFormat = response.getPayloadString();
                responsePrimitive.setContent((Object)linkFormat);
            } else {
                responsePrimitive.setContent((Object)response.getPayloadString());
            }
        }
        List optionsList = response.getOptions().asSortedList();
        for (Option o : optionsList) {
            switch (o.getNumber()) {
                case 256: {
                    responsePrimitive.setFrom(o.getStringValue());
                    break;
                }
                case 257: {
                    responsePrimitive.setRequestIdentifier(o.getStringValue());
                    break;
                }
                case 265: {
                    responsePrimitive.setResponseStatusCode(BigInteger.valueOf(o.getIntegerValue()));
                    break;
                }
                case 8: {
                    responsePrimitive.setLocation(o.getStringValue());
                    break;
                }
                default: {
                    LOGGER.trace((Object)("Option not handled: " + o.getNumber()));
                }
            }
        }
        if (responsePrimitive.getResponseStatusCode() == null) {
            responsePrimitive.setResponseStatusCode(this.getResponseStatusCode(response.getCode().value));
        }
        switch (response.getOptions().getContentFormat()) {
            case 41: {
                responsePrimitive.setContentType("application/xml");
                break;
            }
            case 10000: {
                responsePrimitive.setContentType("application/vnd.onem2m-res+xml");
                break;
            }
            case 50: {
                responsePrimitive.setContentType("application/json");
                break;
            }
            case 10001: {
                responsePrimitive.setContentType("application/vnd.onem2m-res+json");
            }
        }
        LOGGER.debug((Object)("CoAP Client > " + responsePrimitive));
        return responsePrimitive;
    }

    private BigInteger getResponseStatusCode(int statusCode) {
        switch (statusCode) {
            case 200: {
                return ResponseStatusCode.OK;
            }
            case 202: {
                return ResponseStatusCode.ACCEPTED;
            }
            case 201: {
                return ResponseStatusCode.CREATED;
            }
            case 204: {
                return ResponseStatusCode.DELETED;
            }
            case 400: {
                return ResponseStatusCode.BAD_REQUEST;
            }
            case 403: {
                return ResponseStatusCode.ACCESS_DENIED;
            }
            case 404: {
                return ResponseStatusCode.NOT_FOUND;
            }
            case 405: {
                return ResponseStatusCode.OPERATION_NOT_ALLOWED;
            }
            case 409: {
                return ResponseStatusCode.CONFLICT;
            }
            case 500: {
                return ResponseStatusCode.INTERNAL_SERVER_ERROR;
            }
            case 501: {
                return ResponseStatusCode.NOT_IMPLEMENTED;
            }
            case 503: {
                return ResponseStatusCode.SERVICE_UNAVAILABLE;
            }
        }
        return ResponseStatusCode.INTERNAL_SERVER_ERROR;
    }
}

