/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.eclipse.om2m.commons.constants.MgmtDefinitionTypes;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AreaNwkDeviceInfo;
import org.eclipse.om2m.commons.resource.MgmtObj;

@Entity(name="andi")
@Inheritance(strategy=InheritanceType.TABLE_PER_CLASS)
public class AreaNwkDeviceInfoEntity
extends MgmtObjEntity {
    @Column(name="dvd")
    protected String devID;
    @Column(name="dvt")
    protected String devType;
    @Column(name="awi")
    protected String areaNwkId;
    @Column(name="sli")
    protected BigInteger sleepInterval;
    @Column(name="sld")
    protected BigInteger sleepDuration;
    @Column(name="ss")
    protected String status;
    @Column(name="lnh")
    protected List<String> listOfNeighbors;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="ANDI_ACP_JOIN", joinColumns={@JoinColumn(name="ANDI_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> accessControlPolicies;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="linkedAreaNwkDeviceInfoEntities")
    @JoinTable(name="ANDI_DAC_JOIN", joinColumns={@JoinColumn(name="ANDI_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="DAC_JOINID", referencedColumnName="ri")})
    protected List<DynamicAuthorizationConsultationEntity> dynamicAuthorizationConsultations;
    @OneToMany(fetch=FetchType.LAZY, targetEntity=SubscriptionEntity.class, mappedBy="parentAndi")
    @JoinTable(name="ANDI_SUB_JOIN", joinColumns={@JoinColumn(name="ANDI_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> subscriptions;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=NodeEntity.class)
    @JoinTable(name="ANDI_NOD_JOIN", joinColumns={@JoinColumn(name="ANDI_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")})
    protected NodeEntity parentNode;

    public AreaNwkDeviceInfoEntity() {
        this.mgmtDefinition = MgmtDefinitionTypes.AREA_NWK_DEVICE_INFO;
    }

    public String getDevID() {
        return this.devID;
    }

    public void setDevID(String devID) {
        this.devID = devID;
    }

    public String getDevType() {
        return this.devType;
    }

    public void setDevType(String devType) {
        this.devType = devType;
    }

    public String getAreaNwkId() {
        return this.areaNwkId;
    }

    public void setAreaNwkId(String areaNwkId) {
        this.areaNwkId = areaNwkId;
    }

    public BigInteger getSleepInterval() {
        return this.sleepInterval;
    }

    public void setSleepInterval(BigInteger sleepInterval) {
        this.sleepInterval = sleepInterval;
    }

    public BigInteger getSleepDuration() {
        return this.sleepDuration;
    }

    public void setSleepDuration(BigInteger sleepDuration) {
        this.sleepDuration = sleepDuration;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public List<String> getListOfNeighbors() {
        if (this.listOfNeighbors == null) {
            this.listOfNeighbors = new ArrayList<String>();
        }
        return this.listOfNeighbors;
    }

    public void setListOfNeighbors(List<String> listOfNeighbors) {
        this.listOfNeighbors = listOfNeighbors;
    }

    @Override
    public List<SubscriptionEntity> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<SubscriptionEntity>();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(List<SubscriptionEntity> subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Override
    public NodeEntity getParentNode() {
        return this.parentNode;
    }

    @Override
    public void setParentNode(NodeEntity parentNode) {
        this.parentNode = parentNode;
    }

    @Override
    public List<AccessControlPolicyEntity> getAccessControlPolicies() {
        if (this.accessControlPolicies == null) {
            this.accessControlPolicies = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.accessControlPolicies;
    }

    @Override
    public void setAccessControlPolicies(List<AccessControlPolicyEntity> acps) {
        this.accessControlPolicies = acps;
    }

    @Override
    public List<DynamicAuthorizationConsultationEntity> getDynamicAuthorizationConsultations() {
        if (this.dynamicAuthorizationConsultations == null) {
            this.dynamicAuthorizationConsultations = new ArrayList<DynamicAuthorizationConsultationEntity>();
        }
        return this.dynamicAuthorizationConsultations;
    }

    @Override
    public void setDynamicAuthorizationConsultations(List<DynamicAuthorizationConsultationEntity> list) {
        this.dynamicAuthorizationConsultations = list;
    }

    @Override
    public void fillFrom(MgmtObj mgmtObj) {
        super.fillFrom(mgmtObj);
        AreaNwkDeviceInfo andi = (AreaNwkDeviceInfo)mgmtObj;
        this.devID = andi.getDevID();
        this.devType = andi.getDevType();
        this.areaNwkId = andi.getAreaNwkId();
        this.sleepDuration = andi.getSleepDuration();
        this.sleepInterval = andi.getSleepInterval();
        this.status = andi.getStatus();
        this.listOfNeighbors = andi.getListOfNeighbors();
    }
}

