/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.obix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.eclipse.om2m.commons.obix.Uri;

public class Contract {
    static final Contract OBJ = new Contract("obix:obj");
    Uri[] list;
    String string;

    public Contract() {
    }

    public Contract(String list) {
        this(Contract.parse(list));
        this.string = list;
    }

    public Contract(String[] list) {
        this.list = new Uri[list.length];
        int i = 0;
        while (i < list.length) {
            Uri uri = new Uri();
            uri.setVal(list[i]);
            this.list[i] = uri;
            ++i;
        }
    }

    public Contract(Uri[] list) {
        if (list != null) {
            this.list = Arrays.copyOf(list, list.length);
        }
    }

    public static Uri[] parse(String list) {
        StringTokenizer st = new StringTokenizer(list, " ");
        ArrayList<Uri> acc = new ArrayList<Uri>();
        while (st.hasMoreTokens()) {
            acc.add(new Uri(st.nextToken()));
        }
        return acc.toArray(new Uri[acc.size()]);
    }

    public Uri primary() {
        return this.list[0];
    }

    public int size() {
        return this.list.length;
    }

    public Uri get(int index) {
        return this.list[index];
    }

    public Uri[] list() {
        return this.list;
    }

    public boolean contains(Uri uri) {
        int i = 0;
        while (i < this.list.length) {
            if (this.list[i].equals(uri)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsOnlyObj() {
        return this.list.length == 1 && this.list[0].getVal().equals("obix:obj");
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.list);
        result = 31 * result + (this.string == null ? 0 : this.string.hashCode());
        return result;
    }

    public boolean equals(Object that) {
        if (that instanceof Contract) {
            return this.toString().equals(that.toString());
        }
        return false;
    }

    public String encodeJava() {
        return "new Contract(\"" + this.toString() + "\")";
    }

    public String toString() {
        if (this.string == null) {
            StringBuffer s = new StringBuffer();
            int i = 0;
            while (i < this.list.length) {
                if (i > 0) {
                    s.append(' ');
                }
                s.append(this.list[i].getVal());
                ++i;
            }
            this.string = s.toString();
        }
        return this.string;
    }
}

