/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class PushButton
extends Module {
    private BooleanDataPoint pushed;

    public PushButton(String name, Domain domain, BooleanDataPoint pushed) {
        super(name, domain, (Identifiers)ModuleType.pushButton);
        if (pushed == null || !pushed.getShortDefinitionType().equals(DatapointType.pushed.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong pushed datapoint: " + pushed);
        }
        this.pushed = pushed;
        this.pushed.setWritable(false);
        this.pushed.setDoc("To indicate the press of the button.");
        this.addDataPoint((DataPoint)this.pushed);
    }

    public PushButton(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (BooleanDataPoint)dps.get(DatapointType.pushed.getShortName()));
    }

    public boolean isPushed() throws DataPointException, AccessException {
        return (Boolean)this.pushed.getValue();
    }
}

