/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.debug;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.objectteams.otdt.core.ext.OTJavaNature;
import org.eclipse.objectteams.otdt.core.ext.OTREContainer;
import org.eclipse.objectteams.otdt.core.ext.WeavingScheme;
import org.eclipse.objectteams.otdt.debug.OTDebugPlugin;
import org.eclipse.objectteams.otdt.debug.internal.TempFileManager;

public class OTVMRunnerAdaptor {
    private static final String OT_DEBUG_VMARG = "-Dot.debug";
    private static final String OT_DEBUG_CALLIN_STEPPING_VMARG = "-Dot.debug.callin.stepping";
    private static final String OT_TEAMCONFIG_VMARG = "-Dot.teamconfig";
    private static Map<WeavingScheme, List<String>> JPLIS_VMARGS = new HashMap<WeavingScheme, List<String>>();
    private ILaunchConfiguration _launchConfig;
    private String _mode;
    private ILaunch _launch;
    private WeavingScheme weavingScheme;

    public OTVMRunnerAdaptor(IJavaProject javaProject) {
        this.weavingScheme = OTJavaNature.getWeavingScheme((IJavaProject)javaProject);
    }

    public void setAdaptationArgs(ILaunchConfiguration configuration, String mode, ILaunch launch) {
        this._launchConfig = configuration;
        this._mode = mode;
        this._launch = launch;
    }

    public String adaptVMArgumentString(String vmArguments) throws CoreException {
        String teamConfigArg;
        String sep = " ";
        StringBuffer result = new StringBuffer(vmArguments);
        for (String arg : this.getJplisVmargs()) {
            result.append(sep).append(arg);
        }
        String callinSteppingVMArg = this.getCallinSteppingVMArg();
        if (callinSteppingVMArg != null) {
            result.append(sep).append(callinSteppingVMArg);
        }
        if ((teamConfigArg = this.generateTeamConfigArgument(this._launch, this._launchConfig)) != null) {
            result.append(sep).append(teamConfigArg);
        }
        if ("debug".equals(this._mode)) {
            result.append(sep).append(OT_DEBUG_VMARG);
        }
        return result.toString();
    }

    private List<String> getJplisVmargs() {
        List<String> args = JPLIS_VMARGS.get(this.weavingScheme);
        if (args == null) {
            args = new ArrayList<String>();
            args.add("-Dot.otdt");
            args.add("-javaagent:\"" + OTREContainer.getOtreAgentJarPath((WeavingScheme)this.weavingScheme).toOSString() + '\"');
            JPLIS_VMARGS.put(this.weavingScheme, args);
        }
        return args;
    }

    private String getCallinSteppingVMArg() {
        String value = OTDebugPlugin.getDefault().getCallinSteppingConfig();
        if (value == null) {
            return null;
        }
        return "-Dot.debug.callin.stepping=" + value;
    }

    private String generateTeamConfigArgument(ILaunch launch, ILaunchConfiguration configuration) throws CoreException {
        List<String> teamList = this.getTeamConfigList(configuration);
        if (teamList.isEmpty()) {
            return null;
        }
        File teamFile = this.createTeamConfigFile(launch, teamList);
        return "-Dot.teamconfig=\"" + teamFile.getAbsolutePath() + '\"';
    }

    private File createTeamConfigFile(ILaunch launch, List<String> teamList) throws CoreException {
        try {
            TempFileManager manager = OTDebugPlugin.getDefault().getTempFileManager();
            File tempFile = manager.createTempFile(launch, ".otteamconfig", ".conf");
            PrintStream printStream = new PrintStream(new FileOutputStream(tempFile));
            for (String element : teamList) {
                printStream.println(element);
            }
            printStream.close();
            return tempFile;
        }
        catch (Exception e) {
            IStatus status = OTDebugPlugin.createErrorStatus("Error writing static teams configuration", e);
            throw new CoreException(status);
        }
    }

    private List<String> getTeamConfigList(ILaunchConfiguration configuration) throws CoreException {
        boolean teamsActive = configuration.getAttribute("org.eclipse.objectteams.otdt.debug.TEAMCONFIG_ACTIVE_ATTR", true);
        if (!teamsActive) {
            return new LinkedList<String>();
        }
        List teamHandles = configuration.getAttribute("org.eclipse.objectteams.otdt.debug.TEAMCONFIG_ATTR", new LinkedList());
        LinkedList<String> teamNames = new LinkedList<String>();
        LinkedList<String> badHandles = new LinkedList<String>();
        for (String teamHandle : teamHandles) {
            IType teamType = (IType)JavaCore.create((String)teamHandle);
            if (teamType != null && teamType.exists()) {
                teamNames.add(teamType.getFullyQualifiedName());
                continue;
            }
            badHandles.add(teamHandle);
        }
        if (!badHandles.isEmpty()) {
            IStatus status = OTDebugPlugin.createErrorStatus("Cannot determine types: " + ((Object)badHandles).toString());
            throw new CoreException(status);
        }
        return teamNames;
    }
}

