/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otredyn.bytecode.asm;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.objectteams.otredyn.bytecode.AbstractBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.AbstractTeam;
import org.eclipse.objectteams.otredyn.bytecode.Field;
import org.eclipse.objectteams.otredyn.bytecode.IBytecodeProvider;
import org.eclipse.objectteams.otredyn.bytecode.Method;
import org.eclipse.objectteams.otredyn.bytecode.RedefineStrategyFactory;
import org.eclipse.objectteams.otredyn.bytecode.asm.AbstractTransformableClassNode;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddAfterClassLoadingHook;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddEmptyMethodAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddFieldAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddGlobalTeamActivationAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddImplicitActivationAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddInterfaceAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.AddThreadNotificationAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.AsmBoundClass;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateAddRemoveRoleMethod;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateCallAllBindingsCallInOrgMethod;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateDispatchCodeInCallAllBindingsAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateDispatchCodeInOrgMethodAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateFieldAccessAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateMethodAccessAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateSuperCallInCallOrigAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateSwitchAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateSwitchForAccessAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.CreateSwitchForCallAllBindingsNode;
import org.eclipse.objectteams.otredyn.bytecode.asm.LiftingParticipantAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.LoaderAwareClassWriter;
import org.eclipse.objectteams.otredyn.bytecode.asm.MoveCodeToCallOrigAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.MultiClassAdapter;
import org.eclipse.objectteams.otredyn.bytecode.asm.ReplaceWickedSuperCallsAdapter;
import org.eclipse.objectteams.otredyn.runtime.TeamManager;
import org.eclipse.objectteams.otredyn.transformer.jplis.ObjectTeamsTransformer;
import org.eclipse.objectteams.otredyn.transformer.names.ClassNames;
import org.eclipse.objectteams.otredyn.transformer.names.ConstantMembers;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

class AsmWritableBoundClass
extends AsmBoundClass {
    private static boolean dumping = false;
    private ClassWriter writer;
    private MultiClassAdapter multiAdapter;
    private ClassReader reader;
    private boolean isTransformed;
    private boolean isTransformedForMemberAccess;
    private boolean isTransformedStatic;
    private List<AbstractTransformableClassNode> nodes;
    private boolean isFirstTransformation = true;
    private boolean isTransformationActive;
    private int n = 0;

    static {
        if (System.getProperty("ot.dump") != null) {
            dumping = true;
        }
    }

    protected AsmWritableBoundClass(String name, String id, IBytecodeProvider bytecodeProvider, ClassLoader loader) {
        super(name, id, bytecodeProvider, loader);
    }

    private void addField(Field field, int access) {
        assert (this.isTransformationActive) : "No transformation active";
        String desc = field.getSignature();
        this.multiAdapter.addVisitor(new AddFieldAdapter((ClassVisitor)this.writer, field.getName(), access, desc));
    }

    private void addEmptyMethod(Method method, int access, String signature, String[] exceptions, String superToCall) {
        assert (this.isTransformationActive) : "No transformation active";
        String desc = method.getSignature();
        Type[] args = Type.getArgumentTypes((String)desc);
        this.multiAdapter.addVisitor(new AddEmptyMethodAdapter((ClassVisitor)this.writer, method.getName(), access, desc, exceptions, signature, args.length + 1, superToCall));
    }

    private void addInterface(String name) {
        assert (this.isTransformationActive) : "No transformation active";
        this.multiAdapter.setToplevelVisitor(new AddInterfaceAdapter((ClassVisitor)this.writer, name));
    }

    @Override
    protected void startTransformation() {
        this.reader = new ClassReader(this.allocateAndGetBytecode());
        this.writer = this.getClassWriter();
        this.multiAdapter = new MultiClassAdapter((ClassVisitor)this.writer);
        this.nodes = new ArrayList<AbstractTransformableClassNode>();
        this.isTransformationActive = true;
    }

    LoaderAwareClassWriter getClassWriter() {
        int flags = 2;
        return new LoaderAwareClassWriter(this.reader, flags, this.loader);
    }

    @Override
    public boolean isTransformationActive() {
        return this.isTransformationActive;
    }

    @Override
    protected void endTransformation() {
        assert (this.isTransformationActive) : "No transformation active";
        if (this.multiAdapter.hasVisitors() || !this.nodes.isEmpty()) {
            this.reader.accept((ClassVisitor)this.multiAdapter, 4);
            this.setBytecode(this.writer.toByteArray());
            for (AbstractTransformableClassNode node : this.nodes) {
                this.reader = new ClassReader(this.allocateAndGetBytecode());
                this.reader.accept((ClassVisitor)node, 4);
                if (!node.transform()) continue;
                this.writer = this.getClassWriter();
                node.accept((ClassVisitor)this.writer);
                this.setBytecode(this.writer.toByteArray());
            }
            this.dump();
            this.reader = null;
            this.writer = null;
            this.multiAdapter = null;
            this.nodes = null;
            if (!this.isFirstTransformation) {
                try {
                    this.redefine();
                }
                catch (Throwable t) {
                    final Runnable previousTask = (Runnable)TeamManager.pendingTasks.get();
                    TeamManager.pendingTasks.set(new Runnable(){

                        @Override
                        public void run() {
                            if (previousTask != null) {
                                previousTask.run();
                            }
                            AsmWritableBoundClass.this.redefine();
                        }

                        public String toString() {
                            return "Retry " + AsmWritableBoundClass.this.toString();
                        }
                    });
                    this.isTransformationActive = false;
                    this.isFirstTransformation = false;
                    return;
                }
            }
        } else {
            this.reader = null;
            this.writer = null;
            this.multiAdapter = null;
            this.nodes = null;
        }
        this.isTransformationActive = false;
        this.isFirstTransformation = false;
        this.releaseBytecode();
        AbstractTeam mySuper = this.getSuperclass();
        if (mySuper != null && !mySuper.openBindingTasks.isEmpty() && mySuper.isLoaded()) {
            mySuper.handleTaskList();
        }
    }

    @Override
    protected void createDispatchCodeInOrgMethod(Method boundMethod, int joinPointId, int boundMethodId) {
        assert (this.isTransformationActive) : "No transformation active";
        this.nodes.add(new CreateDispatchCodeInOrgMethodAdapter(boundMethod, joinPointId, boundMethodId));
    }

    @Override
    protected void createDispatchCodeInCallAllBindings(int joinpointId, int boundMethodId) {
        assert (this.isTransformationActive) : "No transformation active";
        this.nodes.add(new CreateDispatchCodeInCallAllBindingsAdapter(joinpointId, boundMethodId));
    }

    @Override
    protected void moveCodeToCallOrig(Method boundMethod, int boundMethodId) {
        if (boundMethod.getName().equals("<init>")) {
            return;
        }
        assert (this.isTransformationActive) : "No transformation active";
        this.nodes.add(new MoveCodeToCallOrigAdapter(this, boundMethod, boundMethodId, this.weavingContext));
    }

    @Override
    protected void createSuperCallInCallOrig(int joinpointId) {
        assert (this.isTransformationActive) : "No transformation active";
        this.nodes.add(new CreateSuperCallInCallOrigAdapter(this.getInternalSuperClassName(), joinpointId));
    }

    @Override
    protected void createCallAllBindingsCallInOrgMethod(Method boundMethod, int boundMethodId, boolean needToAddMethod) {
        assert (this.isTransformationActive) : "No transformation active";
        if (needToAddMethod) {
            String desc = boundMethod.getSignature();
            Type[] args = Type.getArgumentTypes((String)desc);
            this.multiAdapter.addVisitor(new AddEmptyMethodAdapter((ClassVisitor)this.writer, boundMethod.getName(), boundMethod.getAccessFlags(), desc, null, boundMethod.getSignature(), args.length + 1, null));
        }
        this.nodes.add(new CreateCallAllBindingsCallInOrgMethod(boundMethod, boundMethodId));
    }

    @Override
    protected void replaceWickedSuperCalls(AbstractBoundClass superclass, Method targetMethod) {
        ReplaceWickedSuperCallsAdapter.register(this.nodes, superclass, targetMethod);
    }

    @Override
    protected void weaveMethodAccess(Method method, int accessId) {
        this.nodes.add(new CreateMethodAccessAdapter(method, accessId));
    }

    @Override
    protected void weaveFieldAccess(Field field, int accessId) {
        this.nodes.add(new CreateFieldAccessAdapter(field, accessId));
    }

    private void dump() {
        if (!dumping) {
            return;
        }
        FileOutputStream fos = null;
        try {
            File dir;
            String name = this.getName();
            int index = name.indexOf(47);
            if (index == -1) {
                index = name.indexOf(46);
            }
            if (!(dir = new File("otdyn")).exists()) {
                dir.mkdir();
            }
            String filename = "otdyn/" + name.substring(index + 1) + ".class";
            fos = new FileOutputStream(filename);
            fos.write(this.allocateAndGetBytecode());
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dump(byte[] bytecode, String postfix) {
        if (!dumping) {
            return;
        }
        FileOutputStream fos = null;
        try {
            File dir;
            String name = this.getName();
            int index = name.indexOf(47);
            if (index == -1) {
                index = name.indexOf(46);
            }
            if (!(dir = new File("otdyn")).exists()) {
                dir.mkdir();
            }
            String filename = "otdyn/" + name.substring(index + 1) + postfix + ".#" + this.n++;
            fos = new FileOutputStream(filename);
            fos.write(bytecode);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void redefine() {
        try {
            Class<?> clazz = this.loader.loadClass(this.getName());
            byte[] bytecode = this.allocateAndGetBytecode();
            this.dump(bytecode, "redef");
            RedefineStrategyFactory.getRedefineStrategy().redefine(clazz, bytecode);
        }
        catch (Throwable t) {
            throw new RuntimeException("Error occured while dynamically redefining class " + this.getName() + "\n" + t.getMessage(), t);
        }
    }

    @Override
    protected void prepareAsPossibleBaseClass() {
        String superClassName;
        if (!this.isFirstTransformation) {
            return;
        }
        this.addInterface(ClassNames.I_BOUND_BASE_SLASH);
        int methodModifiers = 1;
        if (this.isInterface()) {
            methodModifiers |= 0x400;
        }
        if (!this.isInterface()) {
            this.addField(ConstantMembers.roleSet, 1);
        }
        this.addEmptyMethod(ConstantMembers.callOrig, methodModifiers, null, null, null);
        this.addEmptyMethod(ConstantMembers.callAllBindingsClient, methodModifiers, null, null, null);
        if (!this.isInterface()) {
            this.addEmptyMethod(this.getCallOrigStatic(), 9, null, null, null);
            this.addEmptyMethod(ConstantMembers.accessStatic, 9, null, null, null);
        }
        if (!ObjectTeamsTransformer.isWeavable(superClassName = this.getSuperClassName().replace('.', '/'))) {
            superClassName = null;
        }
        this.addEmptyMethod(ConstantMembers.access, methodModifiers, null, null, superClassName);
        this.addEmptyMethod(ConstantMembers.addOrRemoveRole, methodModifiers, null, null, null);
        if (!this.isInterface()) {
            this.multiAdapter.addVisitor(new AddAfterClassLoadingHook((ClassVisitor)this.writer, this));
        }
        if (AddThreadNotificationAdapter.shouldNotify(this)) {
            this.multiAdapter.addVisitor(new AddThreadNotificationAdapter((ClassVisitor)this.writer, this));
        }
    }

    Method getCallOrigStatic() {
        if (this.isRole()) {
            return ConstantMembers.callOrigStaticRoleVersion(this.getEnclosingClassName());
        }
        return ConstantMembers.callOrigStatic;
    }

    @Override
    protected void prepareTeamActivation() {
        if (!this.isFirstTransformation || this.isInterface()) {
            return;
        }
        if (this.isTeam() || this.isRole()) {
            this.multiAdapter.addVisitor(new AddImplicitActivationAdapter((ClassVisitor)this.writer, this));
        }
        AddGlobalTeamActivationAdapter.checkAddVisitor(this.multiAdapter, this.writer);
    }

    @Override
    protected void prepareLiftingParticipant() {
        if (this.isTeam() && LiftingParticipantAdapter.isLiftingParticipantConfigured(this.loader)) {
            this.multiAdapter.addVisitor(new LiftingParticipantAdapter((ClassVisitor)this.writer));
        }
    }

    @Override
    protected void prepareForFirstTransformation() {
        if (!this.isTransformed && !this.isInterface()) {
            this.nodes.add(new CreateSwitchAdapter(ConstantMembers.callOrig));
            this.nodes.add(new CreateSwitchForCallAllBindingsNode());
            this.nodes.add(new CreateAddRemoveRoleMethod());
            this.isTransformed = true;
        }
    }

    @Override
    protected void prepareForFirstStaticTransformation() {
        if (!this.isTransformedStatic && !this.isInterface()) {
            this.nodes.add(new CreateSwitchAdapter(this.getCallOrigStatic(), this.isRole()));
            this.isTransformedStatic = true;
        }
    }

    @Override
    protected void prepareForFirstMemberAccess() {
        if (!this.isTransformedForMemberAccess && !this.isInterface()) {
            String superClassName = this.weavingContext.isWeavable(this.getSuperClassName()) ? this.getInternalSuperClassName() : null;
            this.nodes.add(new CreateSwitchForAccessAdapter(ConstantMembers.access, superClassName, this));
            this.nodes.add(new CreateSwitchForAccessAdapter(ConstantMembers.accessStatic, superClassName, this));
            this.isTransformedForMemberAccess = true;
        }
    }

    @Override
    public boolean isFirstTransformation() {
        return this.isFirstTransformation;
    }
}

