/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.bytecode;

import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.OTByteCodes;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;

public class ConstantPoolSimpleConverter
extends ClassFileStruct {
    int srcOffset;
    byte[] dest;
    ClassFile dstClassFile;

    public static ConstantPoolSimpleConverter create(RoleModel srcRole, MethodBinding srcMethod, byte[] destBytes, ClassFile dstClassFile) {
        if (srcRole != null) {
            return new ConstantPoolSimpleConverter(srcRole, srcMethod, destBytes, dstClassFile);
        }
        return new ConstantPoolSimpleConverter(srcMethod, destBytes, dstClassFile);
    }

    private ConstantPoolSimpleConverter(RoleModel srcRole, MethodBinding srcMethod, byte[] destBytes, ClassFile dstClassFile) {
        super(srcRole.getByteCode(), srcRole.getConstantPoolOffsets(), 0);
        this.srcOffset = srcRole.getByteCodeOffset(srcMethod);
        this.dest = destBytes;
        this.dstClassFile = dstClassFile;
    }

    private ConstantPoolSimpleConverter(MethodBinding srcMethod, byte[] destBytes, ClassFile dstClassFile) {
        super(srcMethod.model.getBytes(), srcMethod.model.getConstantPoolOffsets(), 0);
        this.srcOffset = srcMethod.model.getStructOffset();
        this.dest = destBytes;
        this.dstClassFile = dstClassFile;
    }

    public ConstantPoolSimpleConverter(byte[] bytes, int[] constantPoolOffsets, int methodOffset, byte[] destBytes, ClassFile dstClassFile) {
        super(bytes, constantPoolOffsets, 0);
        this.srcOffset = methodOffset;
        this.dest = destBytes;
        this.dstClassFile = dstClassFile;
    }

    public char[] updateName(int offset) {
        int ref = OTByteCodes.getWord(this.reference, this.srcOffset + offset);
        char[] name = this.getUtf8(ref);
        this.writeName(offset, name);
        return name;
    }

    public void writeName(int offset, char[] name) {
        this.write2(this.dest, offset, this.dstClassFile.constantPool.literalIndex(name));
    }

    private char[] getUtf8(int index) {
        int start = this.constantPoolOffsets[index];
        assert (this.u1At(start) == 1);
        return this.utf8At(start + 3, this.u2At(start + 1));
    }

    private void write2(byte[] code, int offset, int value) {
        code[offset] = (byte)(value >> 8);
        code[offset + 1] = (byte)value;
    }
}

