/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeAnchorReference;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ITeamAnchor;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.ProblemAnchorBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.FieldModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;

public class TypeParameter
extends AbstractVariableDeclaration {
    public TypeVariableBinding binding;
    public TypeReference[] bounds;

    public int getKind() {
        return 6;
    }

    public boolean hasBaseBound() {
        return this.type != null && (this.type.bits & 0x2000) != 0;
    }

    public void checkBounds(Scope scope) {
        if (this.type != null) {
            this.type.checkBounds(scope);
        }
        if (this.bounds != null) {
            int i = 0;
            int length = this.bounds.length;
            while (i < length) {
                this.bounds[i].checkBounds(scope);
                ++i;
            }
        }
    }

    private void internalResolve(Scope scope, boolean staticContext) {
        Binding existingType;
        if (!(this.binding == null || (existingType = scope.parent.getBinding(this.name, 4, this, false)) == null || this.binding == existingType || !existingType.isValidBinding() || existingType.kind() == 4100 && staticContext || RoleModel.areTypeParametersOfSameRole(this.binding, existingType))) {
            scope.problemReporter().typeHiding(this, existingType);
        }
    }

    public void resolve(BlockScope scope) {
        this.internalResolve(scope, scope.methodScope().isStatic);
    }

    public void resolve(ClassScope scope) {
        this.internalResolve(scope, scope.enclosingSourceType().isStatic());
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        output.append(this.name);
        if (this.type != null) {
            if (this.hasBaseBound()) {
                output.append(" base ");
            } else {
                output.append(" extends ");
            }
            this.type.print(0, output);
        }
        if (this.bounds != null) {
            int i = 0;
            while (i < this.bounds.length) {
                output.append(" & ");
                this.bounds[i].print(0, output);
                ++i;
            }
        }
        return output;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.bounds != null) {
                int boundsLength = this.bounds.length;
                int i = 0;
                while (i < boundsLength) {
                    this.bounds[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.bounds != null) {
                int boundsLength = this.bounds.length;
                int i = 0;
                while (i < boundsLength) {
                    this.bounds[i].traverse(visitor, scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, scope);
    }

    public void connectTypeAnchors(Scope scope) {
        if (this.type instanceof TypeAnchorReference) {
            int numParams = 1;
            if (this.bounds != null) {
                numParams += this.bounds.length;
            }
            ITeamAnchor[] anchors = new ITeamAnchor[numParams];
            anchors[0] = ((TypeAnchorReference)this.type).resolveAnchor(scope);
            if (!ProblemAnchorBinding.checkAnchor(scope, this.type, anchors[0], this.name)) {
                return;
            }
            if (anchors[0] instanceof FieldBinding && anchors[0].isValidBinding()) {
                FieldModel.getModel(((FieldBinding)anchors[0]).original()).addUsageRank(this.binding.rank);
            }
            int boundCnt = 0;
            if (this.bounds != null) {
                int i = 0;
                while (i < this.bounds.length) {
                    if (this.bounds[i] instanceof TypeAnchorReference) {
                        anchors[1 + i] = ((TypeAnchorReference)this.bounds[i]).resolveAnchor(scope);
                    } else {
                        TypeBinding bound = this.bounds[i].resolveType((ClassScope)scope);
                        if (++boundCnt == 1) {
                            this.binding.superclass = (ReferenceBinding)bound;
                        } else {
                            scope.problemReporter().incompleteDependentTypesImplementation(this, "Cannot combine more than one type bound with an instance bound");
                        }
                    }
                    ++i;
                }
            }
            this.binding.anchors = anchors;
        }
    }
}

