/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.config.LoggingErrorHandling;
import org.eclipse.nebula.widgets.nattable.edit.editor.IEditErrorHandler;
import org.eclipse.nebula.widgets.nattable.style.ConfigAttribute;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;

public final class EditConfigHelper {
    private EditConfigHelper() {
    }

    public static IEditErrorHandler getEditErrorHandler(IConfigRegistry configRegistry, ConfigAttribute<IEditErrorHandler> configAttribute, List<String> configLabels) {
        IEditErrorHandler errorHandler = configRegistry.getConfigAttribute(configAttribute, DisplayMode.EDIT, configLabels);
        if (errorHandler == null) {
            errorHandler = new LoggingErrorHandling();
        }
        return errorHandler;
    }

    public static boolean openInline(IConfigRegistry configRegistry, List<String> configLabels) {
        Boolean openInDialog = configRegistry.getConfigAttribute(EditConfigAttributes.OPEN_IN_DIALOG, DisplayMode.EDIT, configLabels);
        return openInDialog == null || openInDialog == false;
    }

    public static boolean supportMultiEdit(IConfigRegistry configRegistry, List<String> configLabels) {
        Boolean supportMultiEdit = configRegistry.getConfigAttribute(EditConfigAttributes.SUPPORT_MULTI_EDIT, DisplayMode.EDIT, configLabels);
        return supportMultiEdit == null || supportMultiEdit != false;
    }

    public static boolean openAdjacentEditor(IConfigRegistry configRegistry, List<String> configLabels) {
        Boolean openAdjacentEditor = configRegistry.getConfigAttribute(EditConfigAttributes.OPEN_ADJACENT_EDITOR, DisplayMode.EDIT, configLabels);
        return openAdjacentEditor != null && openAdjacentEditor != false;
    }

    public static boolean activateEditorOnTraversal(IConfigRegistry configRegistry, List<String> configLabels) {
        Boolean activateOnTraversal = configRegistry.getConfigAttribute(EditConfigAttributes.ACTIVATE_EDITOR_ON_TRAVERSAL, DisplayMode.EDIT, configLabels);
        return activateOnTraversal == null || activateOnTraversal != false;
    }
}

