/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.predicate.primitive.BytePredicate;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.iterator.ByteIterator;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ByteHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyByteIterable;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ByteHashSet;

public class CollectByteIterable<T>
extends AbstractLazyByteIterable {
    private final LazyIterable<T> iterable;
    private final ByteFunction<? super T> function;
    private final ByteFunctionToProcedure<T> byteFunctionToProcedure;

    public CollectByteIterable(LazyIterable<T> adapted, ByteFunction<? super T> function) {
        this.iterable = adapted;
        this.function = function;
        this.byteFunctionToProcedure = new ByteFunctionToProcedure(function);
    }

    @Override
    public ByteIterator byteIterator() {
        return new ByteIterator(){
            private final Iterator<T> iterator;
            {
                this.iterator = CollectByteIterable.this.iterable.iterator();
            }

            @Override
            public byte next() {
                return CollectByteIterable.this.function.byteValueOf(this.iterator.next());
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }
        };
    }

    @Override
    public void forEach(ByteProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(ByteProcedure procedure) {
        this.iterable.forEachWith(this.byteFunctionToProcedure, procedure);
    }

    @Override
    public int size() {
        return this.iterable.size();
    }

    @Override
    public boolean isEmpty() {
        return this.iterable.isEmpty();
    }

    @Override
    public boolean notEmpty() {
        return this.iterable.notEmpty();
    }

    @Override
    public int count(BytePredicate predicate) {
        return this.iterable.count((? super T each) -> predicate.accept(this.function.byteValueOf(each)));
    }

    @Override
    public boolean anySatisfy(BytePredicate predicate) {
        return this.iterable.anySatisfy((? super T each) -> predicate.accept(this.function.byteValueOf(each)));
    }

    @Override
    public boolean allSatisfy(BytePredicate predicate) {
        return this.iterable.allSatisfy((? super T each) -> predicate.accept(this.function.byteValueOf(each)));
    }

    @Override
    public boolean noneSatisfy(BytePredicate predicate) {
        return this.iterable.allSatisfy((? super T each) -> !predicate.accept(this.function.byteValueOf(each)));
    }

    @Override
    public byte[] toArray() {
        byte[] array = new byte[this.size()];
        this.iterable.forEachWithIndex((each, index) -> {
            array[index] = this.function.byteValueOf(each);
        });
        return array;
    }

    @Override
    public byte[] toSortedArray() {
        byte[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    @Override
    public MutableByteList toList() {
        return ByteArrayList.newList(this);
    }

    @Override
    public MutableByteSet toSet() {
        return ByteHashSet.newSet(this);
    }

    @Override
    public MutableByteBag toBag() {
        return ByteHashBag.newBag(this);
    }

    @Override
    public boolean containsAll(byte ... source) {
        for (byte value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsAll(ByteIterable source) {
        ByteIterator iterator = source.byteIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    private static final class ByteFunctionToProcedure<T>
    implements Procedure2<T, ByteProcedure> {
        private static final long serialVersionUID = 1L;
        private final ByteFunction<? super T> function;

        private ByteFunctionToProcedure(ByteFunction<? super T> function) {
            this.function = function;
        }

        @Override
        public void value(T each, ByteProcedure procedure) {
            procedure.value(this.function.byteValueOf(each));
        }
    }
}

