/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.export;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.export.IOutputStreamProvider;
import org.eclipse.swt.widgets.Shell;

public class FilePathOutputStreamProvider
implements IOutputStreamProvider {
    private final String filePath;
    private OutputStream stream = null;

    public FilePathOutputStreamProvider(String filePath) {
        this.filePath = filePath;
    }

    @Override
    public Object getResult() {
        if (this.stream == null) {
            return null;
        }
        return new File(this.filePath);
    }

    @Override
    public OutputStream getOutputStream(Shell shell) {
        try {
            this.stream = new PrintStream(this.filePath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(Messages.getString("FileOutputStreamProvider.errorMessage", this.filePath), e);
        }
        return this.stream;
    }
}

