/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.layer;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.freeze.CompositeFreezeLayer;
import org.eclipse.nebula.widgets.nattable.freeze.FreezeConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CompositeFreezeLayerPainter
extends CompositeLayer.CompositeLayerPainter {
    private CompositeLayer compositeLayer;
    private CompositeFreezeLayer compositeFreezeLayer;
    private ILayer freezeLayer;
    private boolean inspectComposite = true;
    private final Collection<ILayer> nestedVerticalLayers = new ArrayList<ILayer>();
    private final Collection<ILayer> nestedHorizontalLayers = new ArrayList<ILayer>();

    public CompositeFreezeLayerPainter(CompositeFreezeLayer compositeFreezeLayer) {
        super(compositeFreezeLayer);
        this.compositeFreezeLayer = compositeFreezeLayer;
        this.freezeLayer = compositeFreezeLayer.getChildLayerByLayoutCoordinate(0, 0);
    }

    public CompositeFreezeLayerPainter(CompositeLayer compositeLayer, CompositeFreezeLayer compositeFreezeLayer) {
        this(compositeLayer, compositeFreezeLayer, true);
    }

    public CompositeFreezeLayerPainter(CompositeLayer compositeLayer, CompositeFreezeLayer compositeFreezeLayer, boolean inspectComposite) {
        super(compositeLayer);
        this.compositeLayer = compositeLayer;
        this.compositeFreezeLayer = compositeFreezeLayer;
        this.freezeLayer = compositeFreezeLayer.getChildLayerByLayoutCoordinate(0, 0);
        this.inspectComposite = inspectComposite;
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        int freezeHeight;
        Integer separatorWidth;
        super.paintLayer(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
        Color separatorColor = configRegistry.getConfigAttribute(FreezeConfigAttributes.SEPARATOR_COLOR, DisplayMode.NORMAL, new String[0]);
        if (separatorColor == null) {
            separatorColor = GUIHelper.COLOR_BLUE;
        }
        if ((separatorWidth = configRegistry.getConfigAttribute(FreezeConfigAttributes.SEPARATOR_WIDTH, DisplayMode.NORMAL, new String[0])) == null) {
            separatorWidth = 1;
        }
        gc.setClipping(rectangle);
        Color oldFg = gc.getForeground();
        int oldWidth = gc.getLineWidth();
        gc.setForeground(separatorColor);
        gc.setLineWidth(GUIHelper.convertHorizontalPixelToDpi((int)separatorWidth, configRegistry));
        int freezeWidth = this.freezeLayer.getWidth() - 1;
        if (freezeWidth > 0) {
            int x = this.getFreezeX(xOffset);
            gc.drawLine(x, yOffset, x, yOffset + this.getHeight() - 1);
        }
        if ((freezeHeight = this.freezeLayer.getHeight() - 1) > 0) {
            int y = this.getFreezeY(yOffset);
            gc.drawLine(xOffset, y, xOffset + this.getWidth() - 1, y);
        }
        gc.setForeground(oldFg);
        gc.setLineWidth(oldWidth);
    }

    protected int getHeight() {
        if (this.compositeLayer != null) {
            return this.compositeLayer.getHeight();
        }
        return this.compositeFreezeLayer.getHeight();
    }

    protected int getWidth() {
        if (this.compositeLayer != null) {
            return this.compositeLayer.getWidth();
        }
        return this.compositeFreezeLayer.getWidth();
    }

    protected int getFreezeX(int xOffset) {
        int result = xOffset + this.freezeLayer.getWidth() - 1;
        if (this.compositeLayer != null && this.inspectComposite && this.compositeLayer.getLayoutXCount() > 1) {
            result += this.compositeLayer.getChildLayerByLayoutCoordinate(0, 0).getWidth();
        }
        for (ILayer nested : this.nestedHorizontalLayers) {
            result += nested.getWidth();
        }
        return result;
    }

    protected int getFreezeY(int yOffset) {
        int result = yOffset + this.freezeLayer.getHeight() - 1;
        if (this.compositeLayer != null && this.inspectComposite && this.compositeLayer.getLayoutYCount() > 1) {
            result += this.compositeLayer.getChildLayerByLayoutCoordinate(0, 0).getHeight();
        }
        for (ILayer nested : this.nestedVerticalLayers) {
            result += nested.getHeight();
        }
        return result;
    }

    public void addNestedVerticalLayer(ILayer layer) {
        if (layer != null) {
            this.nestedVerticalLayers.add(layer);
        }
    }

    public void addNestedHorizontalLayer(ILayer layer) {
        if (layer != null) {
            this.nestedHorizontalLayers.add(layer);
        }
    }
}

