/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula;

import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.copy.InternalCellClipboard;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayerPainter;
import org.eclipse.nebula.widgets.nattable.style.BorderStyle;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.IStyle;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CopySelectionLayerPainter
extends SelectionLayerPainter {
    protected InternalCellClipboard clipboard;

    public CopySelectionLayerPainter(InternalCellClipboard clipboard) {
        this.clipboard = clipboard;
    }

    public CopySelectionLayerPainter(InternalCellClipboard clipboard, Color gridColor) {
        this.clipboard = clipboard;
    }

    public CopySelectionLayerPainter(InternalCellClipboard clipboard, Color gridColor, boolean clipLeft, boolean clipTop) {
        super(gridColor, clipLeft, clipTop);
        this.clipboard = clipboard;
    }

    public CopySelectionLayerPainter(InternalCellClipboard clipboard, boolean clipLeft, boolean clipTop) {
        this(clipboard, GUIHelper.COLOR_GRAY, clipLeft, clipTop);
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        super.paintLayer(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
        if (this.clipboard.getCopiedCells() != null) {
            Rectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
            int columnPositionOffset = positionRectangle.x;
            int rowPositionOffset = positionRectangle.y;
            int originalLineStyle = gc.getLineStyle();
            Color originalForeground = gc.getForeground();
            this.applyCopyBorderStyle(gc, configRegistry);
            int x0 = 0;
            int x1 = 0;
            int y0 = 0;
            int y1 = 0;
            boolean isFirst = true;
            ILayerCell[][] iLayerCellArray = this.clipboard.getCopiedCells();
            int n = iLayerCellArray.length;
            int n2 = 0;
            while (n2 < n) {
                ILayerCell[] cells;
                ILayerCell[] iLayerCellArray2 = cells = iLayerCellArray[n2];
                int n3 = cells.length;
                int n4 = 0;
                while (n4 < n3) {
                    ILayerCell cell = iLayerCellArray2[n4];
                    if (isFirst) {
                        x0 = cell.getBounds().x;
                        x1 = cell.getBounds().x + cell.getBounds().width;
                        y0 = cell.getBounds().y;
                        y1 = cell.getBounds().y + cell.getBounds().height;
                        isFirst = false;
                    } else {
                        x0 = Math.min(x0, cell.getBounds().x);
                        x1 = Math.max(x1, cell.getBounds().x + cell.getBounds().width);
                        y0 = Math.min(y0, cell.getBounds().y);
                        y1 = Math.max(y1, cell.getBounds().y + cell.getBounds().height);
                    }
                    ++n4;
                }
                ++n2;
            }
            gc.drawLine(x0 += xOffset - columnPositionOffset, y0 += yOffset - rowPositionOffset, x0, y1 += yOffset - rowPositionOffset);
            gc.drawLine(x0, y0, x1 += xOffset - columnPositionOffset, y0);
            gc.drawLine(x0, y1, x1, y1);
            gc.drawLine(x1, y0, x1, y1);
            gc.setLineStyle(originalLineStyle);
            gc.setForeground(originalForeground);
        }
    }

    protected void applyCopyBorderStyle(GC gc, IConfigRegistry configRegistry) {
        BorderStyle borderStyle;
        IStyle cellStyle = configRegistry.getConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", "copyBorderStyle");
        BorderStyle borderStyle2 = borderStyle = cellStyle != null ? cellStyle.getAttributeValue(CellStyleAttributes.BORDER_STYLE) : null;
        if (borderStyle == null) {
            gc.setLineStyle(2);
            gc.setLineDash(new int[]{2, 2});
            gc.setForeground(GUIHelper.COLOR_BLACK);
        } else {
            gc.setLineStyle(BorderStyle.LineStyleEnum.toSWT(borderStyle.getLineStyle()));
            gc.setLineWidth(borderStyle.getThickness());
            gc.setForeground(borderStyle.getColor());
        }
    }
}

