/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.richtext.painter;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.nebula.widgets.richtext.painter.LinePainter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Point;

public class TagProcessingState {
    private Point startingPoint = new Point(0, 0);
    private Point pointer = new Point(0, 0);
    private int marginLeft;
    private TextAlignment textAlignment = TextAlignment.LEFT;
    private Color prevColor;
    private Color prevBgColor;
    private boolean underlineActive = false;
    private boolean strikethroughActive = false;
    private Deque<Font> fontStack = new LinkedList<Font>();
    private Deque<Boolean> orderedListStack = new LinkedList<Boolean>();
    private Deque<Integer> listNumberStack = new LinkedList<Integer>();
    private Deque<Integer> listMarginStack = new LinkedList<Integer>();
    private LinePainter currentLine;
    private Iterator<LinePainter> lineIterator;
    private boolean rendering = true;
    private int paragraphCount = 0;

    public Color getPrevColor() {
        return this.prevColor;
    }

    public void setPrevColor(Color prevColor) {
        this.prevColor = prevColor;
    }

    public Color getPrevBgColor() {
        return this.prevBgColor;
    }

    public void setPrevBgColor(Color prevBgColor) {
        this.prevBgColor = prevBgColor;
    }

    public void addPreviousFont(Font font) {
        this.fontStack.addLast(font);
    }

    public Font pollPreviousFont() {
        return this.fontStack.pollLast();
    }

    public boolean isUnderlineActive() {
        return this.underlineActive;
    }

    public void setUnderlineActive(boolean underlineActive) {
        this.underlineActive = underlineActive;
    }

    public boolean isStrikethroughActive() {
        return this.strikethroughActive;
    }

    public void setStrikethroughActive(boolean strikethroughActive) {
        this.strikethroughActive = strikethroughActive;
    }

    public void setStartingPoint(int startX, int startY) {
        this.startingPoint.x = startX;
        this.startingPoint.y = startY;
        this.pointer.x = startX;
        this.pointer.y = startY;
    }

    public Point getPointer() {
        return this.pointer;
    }

    public void increaseX(int x) {
        this.pointer.x += x;
    }

    public void increaseY(int y) {
        this.pointer.y += y;
    }

    public void setX(int x) {
        this.pointer.x = x;
    }

    public void setY(int y) {
        this.pointer.y = y;
    }

    public void resetX() {
        this.pointer.x = this.startingPoint.x + this.marginLeft + this.getListMargin();
    }

    public void calculateX(int areaWidth) {
        if (this.textAlignment.equals((Object)TextAlignment.LEFT) || this.textAlignment.equals((Object)TextAlignment.JUSTIFY)) {
            this.pointer.x = this.startingPoint.x + this.marginLeft + this.getListMargin();
        } else if (this.textAlignment.equals((Object)TextAlignment.RIGHT)) {
            int space = areaWidth - (this.marginLeft + this.getListMargin());
            this.pointer.x = this.startingPoint.x + this.marginLeft + this.getListMargin() + (space - this.getCurrentLine().getContentWidth());
        } else if (this.textAlignment.equals((Object)TextAlignment.CENTER)) {
            int space = areaWidth - (this.marginLeft + this.getListMargin());
            this.pointer.x = this.startingPoint.x + this.marginLeft + this.getListMargin() + (space - this.getCurrentLine().getContentWidth()) / 2;
        }
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public TextAlignment getTextAlignment() {
        return this.textAlignment;
    }

    public void setTextAlignment(TextAlignment textAlignment) {
        this.textAlignment = textAlignment;
    }

    public LinePainter getCurrentLine() {
        return this.currentLine;
    }

    public void setLineIterator(Iterator<LinePainter> lineIterator) {
        this.lineIterator = lineIterator;
    }

    public void activateNextLine() {
        this.currentLine = this.lineIterator.next();
    }

    public int getCurrentLineHeight() {
        return this.currentLine.getLineHeight();
    }

    public FontMetrics getCurrentBiggestFontMetrics() {
        return this.currentLine.getBiggestMetrics();
    }

    public boolean isRendering() {
        return this.rendering;
    }

    public void setRendering(boolean render) {
        this.rendering = render;
    }

    public boolean isOrderedList() {
        return this.orderedListStack.peekLast();
    }

    public void setOrderedList(boolean orderedList) {
        this.orderedListStack.add(orderedList);
    }

    public int getListMargin() {
        int result = 0;
        for (Integer margin : this.listMarginStack) {
            result += margin.intValue();
        }
        return result;
    }

    public void setListMargin(int listMargin) {
        this.listMarginStack.add(listMargin);
    }

    public Integer getCurrentListNumber() {
        return this.listNumberStack.peekLast();
    }

    public void initCurrentListNumber() {
        this.listNumberStack.add(1);
    }

    public void increaseCurrentListNumber() {
        int current = this.listNumberStack.pollLast();
        this.listNumberStack.add(++current);
    }

    public int getListDepth() {
        return this.listNumberStack.size();
    }

    public void resetListConfiguration() {
        this.listNumberStack.removeLast();
        this.listMarginStack.removeLast();
        this.orderedListStack.removeLast();
    }

    public int getParagraphCount() {
        return this.paragraphCount;
    }

    public void increaseParagraphCount() {
        ++this.paragraphCount;
    }

    public static enum TextAlignment {
        LEFT,
        CENTER,
        RIGHT,
        JUSTIFY;

    }
}

