/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import org.eclipse.core.runtime.Assert;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

class RatingTooltip
extends ToolTip {
    private static final String RATING_TIP_SHOWN_PREFERENCE = "ratingTipShown";
    private final Control parent;
    private final Runnable continueRunnable;

    public RatingTooltip(Control control, Runnable continueRunnable) {
        super(control, 1, true);
        Assert.isNotNull((Object)continueRunnable);
        this.parent = control;
        this.continueRunnable = continueRunnable;
        this.setHideOnMouseDown(false);
    }

    protected Composite createToolTipContentArea(Event event, Composite parent) {
        Shell shell = parent.getShell();
        this.setData(Shell.class.getName(), shell);
        Color backgroundColor = parent.getDisplay().getSystemColor(1);
        Composite container = new Composite(parent, 0);
        container.setBackground(backgroundColor);
        GridLayoutFactory.swtDefaults().numColumns(2).spacing(8, 5).applyTo(container);
        final Button continueButton = new Button(container, 0);
        continueButton.setBackground(backgroundColor);
        continueButton.setText(Messages.RatingTooltip_Continue);
        continueButton.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                Button button = (Button)((Accessible)e.getSource()).getControl();
                String text = button.getText();
                e.result = text.replace('>', ' ');
            }
        });
        Point prefSize = continueButton.computeSize(-1, -1, true);
        GridDataFactory.fillDefaults().align(4, 128).hint(-1, (int)((double)prefSize.y * 1.2)).applyTo((Control)continueButton);
        Label label = new Label(container, 64);
        label.setBackground(backgroundColor);
        label.setText(Messages.RatingTooltip_Note);
        prefSize = label.computeSize(-1, -1, true);
        int prefWidth = Math.max(180, (int)((double)prefSize.x * 0.4));
        GridDataFactory.fillDefaults().span(1, 2).align(1, 128).grab(false, true).hint(prefWidth, -1).applyTo((Control)label);
        final Button dontShowCheckBox = new Button(container, 32);
        dontShowCheckBox.setSelection(true);
        dontShowCheckBox.setBackground(backgroundColor);
        dontShowCheckBox.setText(Messages.RatingTooltip_Dont_show_again);
        GridDataFactory.fillDefaults().align(1, 128).applyTo((Control)dontShowCheckBox);
        continueButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (dontShowCheckBox.getSelection()) {
                    MarketplaceClientUiPlugin.getInstance().getPreferenceStore().setValue(RatingTooltip.RATING_TIP_SHOWN_PREFERENCE, true);
                }
                RatingTooltip.this.continueRunnable.run();
                RatingTooltip.this.hide();
            }
        });
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                if (!continueButton.isDisposed()) {
                    continueButton.setFocus();
                }
            }
        });
        return container;
    }

    protected void afterHideToolTip(Event event) {
        this.setData(Shell.class.getName(), null);
    }

    public void show() {
        Rectangle bounds = this.parent.getBounds();
        this.show(new Point(0, bounds.height));
    }

    public static boolean shouldShowRatingTooltip() {
        return !MarketplaceClientUiPlugin.getInstance().getPreferenceStore().getBoolean(RATING_TIP_SHOWN_PREFERENCE);
    }
}

