/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: Triple.java,v 1.1 2007/03/18 08:10:12 lzhang Exp $
 */
package org.eclipse.eodm.util;

import org.eclipse.eodm.RDFFactory;
import org.eclipse.eodm.rdf.rdfbase.RDFSLiteral;
import org.eclipse.eodm.rdf.rdfbase.URIReference;
import org.eclipse.eodm.rdf.rdfweb.Namespace;
import org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition;


/**
 * Triple is the basic exchange data structure between OO memory data model and other sources of RDF or OWL
 * 
 *@eodmext  This class is added by EODM.
 */
public class Triple extends Object{
	
	URIReference subjectUriRef;
	String subjectURI;
	String subjectNodeID;	
	//String subjectNameSpace;
	//String subjectLocalName;
	
	URIReference predicateUriRef;
	String predicate;
	//String prediacateNameSpace;
	//String predicateLocalName;
	
	URIReference objectUriRef;
	String objectURI;
	String objectNodeID;
	RDFSLiteral objectLiteral;
	//String ObjectNameSpace;
	//String ObjectLocalName;
	
	public RDFSLiteral getObjectLiteral() {
		return objectLiteral;
	}
	public void setObjectLiteral(RDFSLiteral objectLiteral) {
		this.objectLiteral = objectLiteral;
	}
	public String getObjectNodeID() {
		return objectNodeID;
	}
	public void setObjectNodeID(String objectNodeID) {
		this.objectNodeID = objectNodeID;
	}
	public String getObjectURI() {
		return objectURI;
	}
	public void setObjectURI(String objectURI) {
		try{
			this.objectURI = objectURI;
			this.objectUriRef = RDFFactory.eINSTANCE.createURIReference(objectURI);
		}catch(Exception e){e.printStackTrace();}
	}
	public void setObjectURI(Namespace namespace, String localName) {
		this.objectURI = namespace.getNamespaceURIRef().getURIString()+localName;
		this.objectUriRef = RDFFactory.eINSTANCE.createURIReference(namespace,localName);
		
	}
	public URIReference getObjectUriRef() {
		return objectUriRef;
	}
	public void setObjectUriRef(URIReference objectUriRef) {
		try{
			if(objectUriRef.getNamespace()!=null)
			{
				this.objectUriRef = RDFFactory.eINSTANCE.createURIReference(
						objectUriRef.getNamespace(),
						objectUriRef.getFragmentIdentifier().getName());
			}
			else
			{
				this.objectUriRef = RDFFactory.eINSTANCE.createURIReference(objectUriRef.getURIString());
			}}catch(Exception e){e.printStackTrace();}
		this.objectURI = this.objectUriRef.getURIString();
	}
	public String getPredicate() {
		return predicate;
	}
	public void setPredicate(String predicate) {
		this.predicate = predicate;
		try{
			this.predicateUriRef = RDFFactory.eINSTANCE.createURIReference(predicate);
		}catch(Exception e){e.printStackTrace();}
	}
	public URIReference getPredicateUriRef() {
		return predicateUriRef;
	}
	public void setPredicateUriRef(URIReference predicateUriRef) {
		this.predicateUriRef = predicateUriRef;
		this.predicate = this.predicateUriRef.getURIString();
	}
	public void setPredicateUriRef(Namespace namespace, String localName) {
		this.predicateUriRef = RDFFactory.eINSTANCE.createURIReference(namespace,localName);
		this.predicate = namespace.getNamespaceURIRef().getURIString() + localName;
	}
	public String getSubjectNodeID() {
		return subjectNodeID;
	}
	public void setSubjectNodeID(String subjectNodeID) {
		this.subjectNodeID = subjectNodeID;
	}
	public String getSubjectURI() {
		return subjectURI;
	}
	public void setSubjectURI(String subjectURI) {
		this.subjectURI = subjectURI;
		try{
			this.subjectUriRef = RDFFactory.eINSTANCE.createURIReference(subjectURI);
		}catch(Exception e){e.printStackTrace();}
	}
	public void setSubjectURI(Namespace namespace, String localName) {
		//System.out.println(namespace.getNamespaceValue().getName());
		this.subjectUriRef = RDFFactory.eINSTANCE.createURIReference(namespace,localName);
		this.subjectURI = namespace.getNamespaceURIRef().getURIString()+localName;
		//System.out.println(this.subjectUriRef.getNamespace().getNamespaceValue().getName());
	}
	
	public URIReference getSubjectUriRef() {
		//System.out.println(this.subjectUriRef.getNamespace().getNamespaceValue().getName());
		return subjectUriRef;
	}
	public void setSubjectUriRef(URIReference subjectUriRef) {
		try{
		if(subjectUriRef.getNamespace()!=null)
		{
			this.subjectUriRef = RDFFactory.eINSTANCE.createURIReference(
					subjectUriRef.getNamespace(),
					subjectUriRef.getFragmentIdentifier().getName());
		}
		else
		{
			this.subjectUriRef = RDFFactory.eINSTANCE.createURIReference(subjectUriRef.getURIString());
		}}catch(Exception e){e.printStackTrace();}
		//this.subjectUriRef = subjectUriRef;
		this.subjectURI = this.subjectUriRef.getURIString();
	}
	public boolean isSubjectURI()
	{
		return this.getSubjectURI()!=null&&!this.getSubjectURI().equals("");
	}
	public boolean isObjectURI()
	{
		return this.getObjectURI()!=null&&!this.getObjectURI().equals("");
	}
	public boolean isObjectLiteral()
	{
		return this.getObjectLiteral()!=null;
	}
	public boolean isObjectBlankNode()
	{
		return this.getObjectNodeID()!=null;
	}
	
	public void print()
	{
		print(null) ;
	}
	
	protected void appendAbbrev(StringBuffer buf, String uri, NamespaceDefinition[] nss )
	{
		if ( nss != null )
			for (int i=0; i<nss.length; i++)
			{
				String nsUri = nss[i].getNamespace().getNamespaceURIRef().getURIString() ;
				if ( uri.startsWith( nsUri ) )
				{
					buf.append( nss[i].getNamespacePrefix() );
					buf.append(":") ;
					buf.append( uri.substring( nsUri.length() ) );
					return ;
				}
			}
		buf.append( uri );
	}
	
	public void print(NamespaceDefinition[] nss)
	{
		StringBuffer output = new StringBuffer(64);
		
		output.append("(");
		String subjStr = this.getSubjectURI() ;
		if ( subjStr.length() == 0 ) subjStr = this.getSubjectNodeID();
		appendAbbrev(output, subjStr, nss) ;
		output.append(",\t");
		appendAbbrev(output, this.getPredicate(), nss );
		output.append(",\t");
		String objStr = null ;
		if ( isObjectURI() ) objStr = this.getObjectURI() ;
		if ( isObjectBlankNode() ) objStr = this.getObjectNodeID() ;
		if ( isObjectLiteral() ) objStr = this.getObjectLiteral().getLexicalForm();
		appendAbbrev(output, objStr, nss);
		output.append(")");
		
		System.out.println( output.toString() );
	}
	
	public Triple cloneTriple()
	{
		Triple triple = new Triple();
		if(this.isSubjectURI())
		{
			triple.setSubjectUriRef(this.subjectUriRef);
		}
		else
		{
			triple.setSubjectNodeID(this.subjectNodeID);
		}
		triple.setPredicateUriRef(this.predicateUriRef);
		if(this.isObjectURI())
		{
			triple.setObjectUriRef(this.objectUriRef);
		}
		else if (this.isObjectBlankNode())
		{
			triple.setObjectNodeID(this.objectNodeID);
		}
		else
		{
			triple.setObjectLiteral(this.objectLiteral);
		}
		
		return triple;
	}
}
