/**
 * Copyright (c) 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * $Id: RDFStatement.java,v 1.1 2007/03/18 08:10:08 lzhang Exp $
 */
package org.eclipse.eodm.rdf.rdfbase;

import org.eclipse.emf.common.util.EList;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>RDF Statement</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following ODM features are supported:
 * <ul>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getDocument <em>document</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#isIsReifiedOnly <em>isReifiedOnly</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#isIsReified <em>isReified</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getRDFsubject <em>RDFsubject</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getRDFobject <em>RDFobject</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getRDFpredicate <em>RDFpredicate</em>}</li>
 *   <li>{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getNameForReification <em>nameForReification</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFStatement()
 * @model
 * @generated
 */
public interface RDFStatement extends RDFSResource {
	/**
	 * Returns the value of the '<em><b>document</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfweb.Document}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfweb.Document#getStatement <em>statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Document</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>document</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFStatement_Document()
	 * @see org.eclipse.eodm.rdf.rdfweb.Document#getStatement
	 * @model type="org.eclipse.eodm.rdf.rdfweb.Document" opposite="statement" required="true"
	 * @generated
	 */
	EList getDocument();

	/**
	 * Returns the value of the '<em><b>isReifiedOnly</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Reified Only</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>isReifiedOnly</em>' attribute.
	 * @see #setIsReifiedOnly(boolean)
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFStatement_IsReifiedOnly()
	 * @model required="true"
	 * @generated
	 */
	boolean isIsReifiedOnly();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#isIsReifiedOnly <em>isReifiedOnly</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>isReifiedOnly</em>' attribute.
	 * @see #isIsReifiedOnly()
	 * @generated
	 */
	void setIsReifiedOnly(boolean value);

	/**
	 * Returns the value of the '<em><b>isReified</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Reified</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>isReified</em>' attribute.
	 * @see #setIsReified(boolean)
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFStatement_IsReified()
	 * @model required="true"
	 * @generated
	 */
	boolean isIsReified();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#isIsReified <em>isReified</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>isReified</em>' attribute.
	 * @see #isIsReified()
	 * @generated
	 */
	void setIsReified(boolean value);

	/**
	 * Returns the value of the '<em><b>RDFsubject</b></em>' reference.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfbase.RDFSResource#getSubjectStatement <em>subjectStatement</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RD Fsubject</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFsubject</em>' reference.
	 * @see #setRDFsubject(RDFSResource)
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFStatement_RDFsubject()
	 * @see org.eclipse.eodm.rdf.rdfbase.RDFSResource#getSubjectStatement
	 * @model opposite="subjectStatement"
	 * @generated
	 */
	RDFSResource getRDFsubject();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getRDFsubject <em>RDFsubject</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>RDFsubject</em>' reference.
	 * @see #getRDFsubject()
	 * @generated
	 */
	void setRDFsubject(RDFSResource value);

	/**
	 * Returns the value of the '<em><b>RDFobject</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RD Fobject</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFobject</em>' reference.
	 * @see #setRDFobject(RDFSResource)
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFStatement_RDFobject()
	 * @model
	 * @generated
	 */
	RDFSResource getRDFobject();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getRDFobject <em>RDFobject</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>RDFobject</em>' reference.
	 * @see #getRDFobject()
	 * @generated
	 */
	void setRDFobject(RDFSResource value);

	/**
	 * Returns the value of the '<em><b>RDFpredicate</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>RD Fpredicate</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>RDFpredicate</em>' reference.
	 * @see #setRDFpredicate(RDFProperty)
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFStatement_RDFpredicate()
	 * @model
	 * @generated
	 */
	RDFProperty getRDFpredicate();

	/**
	 * Sets the value of the '{@link org.eclipse.eodm.rdf.rdfbase.RDFStatement#getRDFpredicate <em>RDFpredicate</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>RDFpredicate</em>' reference.
	 * @see #getRDFpredicate()
	 * @generated
	 */
	void setRDFpredicate(RDFProperty value);

	/**
	 * Returns the value of the '<em><b>nameForReification</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.eodm.rdf.rdfbase.URIReference}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.eodm.rdf.rdfbase.URIReference#getReifiedStatement <em>reifiedStatement</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name For Reification</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>nameForReification</em>' reference list.
	 * @see org.eclipse.eodm.rdf.rdfbase.util.RDFBasePackage#getRDFStatement_NameForReification()
	 * @see org.eclipse.eodm.rdf.rdfbase.URIReference#getReifiedStatement
	 * @model type="org.eclipse.eodm.rdf.rdfbase.URIReference" opposite="reifiedStatement"
	 * @generated
	 */
	EList getNameForReification();

} // RDFStatement
