/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: NodeElement.java,v 1.2 2007/03/18 08:39:03 lzhang Exp $
 */
package org.eclipse.eodm.rdf.resource.parser.xml;

import org.eclipse.eodm.rdf.resource.parser.element.RDFResourceElement;

/**
 * Node element. Please refer to
 * http://www.w3.org/TR/rdf-syntax-grammar/#section-Syntax-node-property-elements.
 */
public class NodeElement extends Element {
    private RDFResourceElement resource;

    private int rdfLI = 0;

    private boolean isExplicit = true;

    /**
     * Construct a node element.
     * 
     * @param resource
     *            the resource
     */
    public NodeElement(RDFResourceElement resource) {
        this.resource = resource;
    }

    /**
     * Get the resource
     * 
     * @return the resource
     */
    public RDFResourceElement getResource() {
        return resource;
    }

    /**
     * Set the resource.
     * 
     * @param resource
     *            the resource
     */
    public void setResource(RDFResourceElement resource) {
        this.resource = resource;
    }

    /**
     * Get the next rdf:li element NO.
     * 
     * @return the next rdf:li element NO.
     */
    public int nextLI() {
        rdfLI++;
        return rdfLI;
    }

    public String toString() {
        return "NodeElement{" + "resource=" + resource + "}";
    }

    /**
     * Check whether the node element is explicit.
     * 
     * @return true if the node element is explicit
     */
    public boolean isExplicit() {
        return isExplicit;
    }

    /**
     * Set the node element to be explicit.
     * 
     * @param isExplicit
     *            check whether the node element is explicit
     */
    public void setExplicit(boolean isExplicit) {
        this.isExplicit = isExplicit;
    }

}