/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: TripleAnalyzer.java,v 1.1 2007/03/18 09:07:05 lzhang Exp $
 */

package org.eclipse.eodm.owl.resource.parser;

import org.eclipse.eodm.rdf.rdfweb.NamespaceDefinition;
import org.eclipse.eodm.rdf.resource.parser.element.RDFResourceElement;
import org.eclipse.eodm.rdf.resource.parser.element.RDFValue;
import org.eclipse.eodm.rdf.resource.parser.element.URIReference;

public interface TripleAnalyzer {

    /**
     * Analyze an RDF triple {subject, predicate, object}.
     * 
     * @param subject
     *            The subject of the triple
     * @param predicate
     *            The predicate of the triple
     * @param object
     *            The object of the triple
     */
    public void analyseStatement(RDFResourceElement subject,
            URIReference predicate, RDFValue object);

    /**
     * Handle namespaces generated during RDF parsing.
     * 
     * @param name
     *            The abbreviation of the namespace
     * @param uri
     *            The namespace full uri
     * @return the Namespace handled
     */
    public NamespaceDefinition handleNamespace(String name, String uri);
}
