/**
 * <copyright> 
 * 
 * Copyright (c) 2004-2005 IBM Corporation and others. 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License - v 1.0 
 * which accompanies this distribution, and is available at 
 * http://opensource.org/licenses/eclipse-1.0.txt 
 * 
 * Contributors: 
 *   IBM - Initial API and implementation 
 * 
 * </copyright> 
 * 
 * $Id: Union.java,v 1.1 2007/03/18 09:06:59 lzhang Exp $
 */

package org.eclipse.eodm.owl.reasoner.structural;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Union extends Concept {
    
    public Union(Concept c1, Concept c2) {
        addUnionOf(c1);
        addUnionOf(c2);
    }
    
    public Union(List clist) {
        if(clist != null) {
            for(Iterator iter = clist.iterator();iter.hasNext();) {
                addUnionOf((Concept)iter.next());
            }
        }
    }
    
    public void addUnionOf(Concept c) {
        if(c != null) {
            if(c.getCType()==TermUtil.C_UNION) {
                for(Iterator it=((Union)c).getUnionOf().iterator();it.hasNext();) {
                    addUnionOf((Concept)it.next());
                }
            } 
            else if(!content.contains(c)){
                content.add(c);
            }
        }
    }
    
    public List getUnionOf() {
        return content;
    }
    
    public void clear() {
        content.clear();
    }
    
    
    public int getCType() {
        return TermUtil.C_UNION;
    }
    
    
    // list of AND nodes
    private List content = new ArrayList();


    public boolean isRestriction() {
        return false;
    }
    
}
