/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.owl.resource.parser.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import org.eclipse.eodm.owl.resource.parser.OWLDocument;
import org.eclipse.eodm.owl.resource.parser.exception.OWLParserException;
import org.eclipse.eodm.owl.resource.parser.impl.OWLOntologyGraph;

public class OWLDocumentImpl
implements OWLDocument {
    private boolean localFile = true;
    private String localURI = null;
    private String publicURI = null;
    private String charset = null;
    private String defaultBaseURI = null;
    private InputStream inputStream = null;
    private LinkedList incomingURIs = new LinkedList();
    private LinkedList outgoingURIs = new LinkedList();
    private boolean parsingFlag = false;
    OWLOntologyGraph ontologygraph;

    public OWLDocumentImpl() {
    }

    public OWLDocumentImpl(String localURI, String publicURI, boolean localFile) {
        this.localURI = localURI;
        this.publicURI = publicURI;
        if (publicURI != null) {
            this.addImportOntologyURIs(publicURI);
        }
        this.localFile = localFile;
        if (localURI != null) {
            try {
                this.localURI = new File(localURI).getCanonicalPath();
            }
            catch (IOException iOException) {
                throw new OWLParserException("The file " + localFile + " is not found.");
            }
        }
    }

    public OWLDocumentImpl(InputStream stream) {
        this.localURI = "OWLInputStream";
        this.publicURI = null;
        this.localFile = true;
        this.inputStream = stream;
    }

    public InputStream getOWLInputStream() {
        return this.inputStream;
    }

    public boolean isLocalFile() {
        return this.localFile;
    }

    public String getLocalURI() {
        return this.localURI;
    }

    public String getPublicURI() {
        return this.publicURI;
    }

    public void setPublicURI(String URI2) {
        this.publicURI = URI2;
        this.addImportOntologyURIs(URI2);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public InputStream readInput() throws OWLParserException {
        if (this.inputStream != null) {
            return this.inputStream;
        }
        InputStream input = null;
        URL url = null;
        try {
            if (this.publicURI != null) {
                url = new URL(this.publicURI);
            }
        }
        catch (MalformedURLException e1) {
            throw new OWLParserException("The document uri " + this.publicURI + " is malformed.", e1);
        }
        if (this.isLocalFile()) {
            try {
                input = new FileInputStream(this.localURI);
            }
            catch (FileNotFoundException e) {
                throw new OWLParserException("The file " + this.localURI + " is not found.", e);
            }
        }
        if (url != null && url.getProtocol().equalsIgnoreCase("file")) {
            try {
                String file = new File(url.getPath()).getCanonicalPath();
                input = new FileInputStream(file);
                this.localURI = file;
                this.localFile = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new OWLParserException("Cannot load the file", e);
            }
        }
        try {
            input = new URL(this.publicURI).openStream();
        }
        catch (MalformedURLException e) {
            throw new OWLParserException("The document uri " + this.publicURI + " is malformed.", e);
        }
        catch (IOException e) {
            throw new OWLParserException("IO exception when open the input stream.", e);
        }
        return input;
    }

    public String getDefaultBaseURI() {
        return this.defaultBaseURI;
    }

    public void setDefaultBaseURI(String baseURI) {
        this.defaultBaseURI = baseURI;
    }

    public boolean isParsed() {
        return this.parsingFlag;
    }

    public LinkedList getImportOntologyURIs(boolean flag) {
        if (flag) {
            return this.incomingURIs;
        }
        return this.outgoingURIs;
    }

    public void setParsed() {
        this.parsingFlag = true;
    }

    public void addImportOntologyURIs(String str) {
        int i = 0;
        while (i < this.incomingURIs.size()) {
            if (str.equals((String)this.incomingURIs.get(i))) {
                return;
            }
            ++i;
        }
        this.incomingURIs.addLast(str);
    }

    public OWLOntologyGraph getOntologyGraph() {
        return this.ontologygraph;
    }

    public void setOntologyGraph(OWLOntologyGraph ontologygraph) {
        this.ontologygraph = ontologygraph;
    }

    public void setInputStream(InputStream input) {
        this.inputStream = null;
    }
}

