/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.owl.reasoner.structural;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.eodm.owl.reasoner.structural.AllValueFrom;
import org.eclipse.eodm.owl.reasoner.structural.Cardinality;
import org.eclipse.eodm.owl.reasoner.structural.Concept;
import org.eclipse.eodm.owl.reasoner.structural.HasValue;
import org.eclipse.eodm.owl.reasoner.structural.Individual;
import org.eclipse.eodm.owl.reasoner.structural.Intersection;
import org.eclipse.eodm.owl.reasoner.structural.MaxCardinality;
import org.eclipse.eodm.owl.reasoner.structural.MinCardinality;
import org.eclipse.eodm.owl.reasoner.structural.Negation;
import org.eclipse.eodm.owl.reasoner.structural.PrimitiveConcept;
import org.eclipse.eodm.owl.reasoner.structural.RBox;
import org.eclipse.eodm.owl.reasoner.structural.Resource;
import org.eclipse.eodm.owl.reasoner.structural.Restriction;
import org.eclipse.eodm.owl.reasoner.structural.Role;
import org.eclipse.eodm.owl.reasoner.structural.SomeValueFrom;
import org.eclipse.eodm.owl.reasoner.structural.Term;
import org.eclipse.eodm.owl.reasoner.structural.TermFactory;
import org.eclipse.eodm.owl.reasoner.structural.Union;

public class ReasonerUtil {
    public static final String THING = "http://www.w3.org/2002/07/owl#Thing";
    public static final String NOTHING = "http://www.w3.org/2002/07/owl#Nothing";
    public static final PrimitiveConcept TOP = TermFactory.instance().createPrim("http://www.w3.org/2002/07/owl#Thing");
    public static final PrimitiveConcept BOTTOM = TermFactory.instance().createPrim("http://www.w3.org/2002/07/owl#Nothing");
    public static final boolean DEBUG = true;

    public static Concept[] getAllForms(Concept c, RBox rbox) {
        Concept[] forms = new Concept[]{ReasonerUtil.toMinimalDNF(c, rbox), ReasonerUtil.toMaximalCNF(c, rbox)};
        return forms;
    }

    public static Concept toDNF(Concept c, boolean normalizeRestriction) {
        Concept term = c;
        List clist = null;
        int size = -1;
        int type = c == null ? -1 : c.getCType();
        switch (type) {
            case 12: {
                clist = ((Intersection)c).getIntersectOf();
                size = clist.size();
                if (size > 1) {
                    int j;
                    ArrayList<List> list = new ArrayList<List>();
                    Intersection prefix = TermFactory.instance().createIntersect();
                    int length = 1;
                    int i = 0;
                    while (i < size) {
                        Concept child = ReasonerUtil.toDNF((Concept)clist.get(i), normalizeRestriction);
                        if (child.getCType() == 13) {
                            List or = ((Union)child).getUnionOf();
                            list.add(or);
                            length *= or.size();
                        } else {
                            prefix.addIntersectOf(child);
                        }
                        ++i;
                    }
                    int slength = list.size();
                    if (slength == 0) {
                        term = prefix;
                        break;
                    }
                    int[][] idlist = new int[length][slength];
                    int head = 1;
                    int i2 = 0;
                    while (i2 < slength) {
                        int len = ((List)list.get(i2)).size();
                        int index = 0;
                        j = 0;
                        while (j < head) {
                            int tail = length / (head * len);
                            int val = 0;
                            while (val < len) {
                                int k = 0;
                                while (k < tail) {
                                    idlist[index++][i2] = val;
                                    ++k;
                                }
                                ++val;
                            }
                            ++j;
                        }
                        head *= len;
                        ++i2;
                    }
                    Union dnf = TermFactory.instance().createUnion();
                    int i3 = 0;
                    while (i3 < length) {
                        Intersection sub = TermFactory.instance().createIntersect();
                        j = 0;
                        while (j < slength) {
                            sub.addIntersectOf(prefix);
                            sub.addIntersectOf((Concept)((List)list.get(j)).get(idlist[i3][j]));
                            ++j;
                        }
                        dnf.addUnionOf(sub);
                        ++i3;
                    }
                    term = dnf;
                    break;
                }
                if (size == 1) {
                    term = ReasonerUtil.toDNF((Concept)clist.get(0), normalizeRestriction);
                    break;
                }
                term = BOTTOM;
                break;
            }
            case 13: {
                clist = ((Union)c).getUnionOf();
                size = clist.size();
                if (size > 1) {
                    term = TermFactory.instance().createUnion();
                    int i = 0;
                    while (i < size) {
                        Concept c1 = (Concept)clist.get(i);
                        ((Union)term).addUnionOf(ReasonerUtil.toDNF(c1, normalizeRestriction));
                        ++i;
                    }
                    break;
                }
                if (size == 1) {
                    term = ReasonerUtil.toDNF((Concept)clist.get(0), normalizeRestriction);
                    break;
                }
                term = BOTTOM;
                break;
            }
            case 14: {
                if (normalizeRestriction) {
                    SomeValueFrom s = (SomeValueFrom)c;
                    term = TermFactory.instance().createSome(s.getOnProperty(), ReasonerUtil.toDNF(s.getRange(), normalizeRestriction));
                    break;
                }
                term = ReasonerUtil.cloneConcept(c);
                break;
            }
            case 15: {
                if (normalizeRestriction) {
                    AllValueFrom a = (AllValueFrom)c;
                    term = TermFactory.instance().createAll(a.getOnProperty(), ReasonerUtil.toDNF(a.getRange(), normalizeRestriction));
                    break;
                }
                term = ReasonerUtil.cloneConcept(c);
                break;
            }
            default: {
                term = ReasonerUtil.cloneConcept(c);
            }
        }
        return ReasonerUtil.optimizeDNF(term);
    }

    /*
     * Unable to fully structure code
     */
    private static Concept optimizeDNF(Concept dnf) {
        term = dnf;
        clist = null;
        type = dnf == null ? -1 : dnf.getCType();
        switch (type) {
            case 12: {
                clist = ((Intersection)dnf).getIntersectOf();
                if (clist.size() != 1) break;
                term = (Concept)clist.get(0);
                break;
            }
            case 13: {
                clist = ((Union)dnf).getUnionOf();
                i = clist.size() - 1;
                while (i >= 0) {
                    c1 = (Concept)clist.get(i);
                    if (c1.getCType() != 12) ** GOTO lbl36
                    j = i - 1;
                    while (j >= 0) {
                        c2 = (Concept)clist.get(j);
                        if (c2.getCType() != 12) ** GOTO lbl29
                        if (!((Intersection)c1).getIntersectOf().containsAll(((Intersection)c2).getIntersectOf())) ** GOTO lbl24
                        clist.remove(i);
                        ** GOTO lbl45
lbl24:
                        // 1 sources

                        if (!((Intersection)c2).getIntersectOf().containsAll(((Intersection)c1).getIntersectOf())) ** GOTO lbl33
                        clist.remove(j);
                        --i;
                        ** GOTO lbl33
lbl29:
                        // 1 sources

                        if (!((Intersection)c1).getIntersectOf().contains(c2)) ** GOTO lbl33
                        clist.remove(i);
                        ** GOTO lbl45
lbl33:
                        // 3 sources

                        --j;
                    }
                    ** GOTO lbl45
lbl36:
                    // 1 sources

                    j = i - 1;
                    while (j >= 0) {
                        c2 = (Concept)clist.get(j);
                        if (c2.getCType() == 12 && ((Intersection)c2).getIntersectOf().contains(c1)) {
                            clist.remove(j);
                            --i;
                        }
                        --j;
                    }
lbl45:
                    // 4 sources

                    --i;
                }
                i = 0;
                while (i < clist.size()) {
                    c1 = (Concept)clist.get(i);
                    if (c1.getCType() == 12 && ((Intersection)c1).getIntersectOf().size() == 1) {
                        ((ArrayList)clist).set(i, ((Intersection)c1).getIntersectOf().get(0));
                    }
                    ++i;
                }
                if (clist.size() != 1) break;
                term = (Concept)clist.get(0);
                break;
            }
        }
        return term;
    }

    public static Concept toCNF(Concept c, boolean normalizeRestriction) {
        Concept term = c;
        List clist = null;
        int size = -1;
        int type = c == null ? -1 : c.getCType();
        switch (type) {
            case 12: {
                clist = ((Intersection)c).getIntersectOf();
                size = clist.size();
                if (size > 1) {
                    term = TermFactory.instance().createIntersect();
                    int i = 0;
                    while (i < size) {
                        ((Intersection)term).addIntersectOf(ReasonerUtil.toCNF((Concept)clist.get(i), normalizeRestriction));
                        ++i;
                    }
                    break;
                }
                if (size == 1) {
                    term = ReasonerUtil.toCNF((Concept)clist.get(0), normalizeRestriction);
                    break;
                }
                term = BOTTOM;
                break;
            }
            case 13: {
                clist = ((Union)c).getUnionOf();
                size = clist.size();
                if (size > 1) {
                    int j;
                    Union prefix = TermFactory.instance().createUnion();
                    ArrayList<List> list = new ArrayList<List>();
                    int length = 1;
                    int i = 0;
                    while (i < size) {
                        Concept child = ReasonerUtil.toCNF((Concept)clist.get(i), normalizeRestriction);
                        if (child.getCType() == 12) {
                            List and = ((Intersection)child).getIntersectOf();
                            list.add(and);
                            length *= and.size();
                        } else {
                            prefix.addUnionOf(child);
                        }
                        ++i;
                    }
                    int slength = list.size();
                    if (slength == 0) {
                        term = prefix;
                        break;
                    }
                    int[][] idlist = new int[length][slength];
                    int head = 1;
                    int i2 = 0;
                    while (i2 < slength) {
                        int len = ((List)list.get(i2)).size();
                        int index = 0;
                        j = 0;
                        while (j < head) {
                            int tail = length / (head * len);
                            int val = 0;
                            while (val < len) {
                                int k = 0;
                                while (k < tail) {
                                    idlist[index++][i2] = val;
                                    ++k;
                                }
                                ++val;
                            }
                            ++j;
                        }
                        head *= len;
                        ++i2;
                    }
                    Intersection cnf = TermFactory.instance().createIntersect();
                    int i3 = 0;
                    while (i3 < length) {
                        Union sub = TermFactory.instance().createUnion();
                        sub.addUnionOf(prefix);
                        j = 0;
                        while (j < slength) {
                            sub.addUnionOf((Concept)((List)list.get(j)).get(idlist[i3][j]));
                            ++j;
                        }
                        cnf.addIntersectOf(sub);
                        ++i3;
                    }
                    term = cnf;
                    break;
                }
                if (size == 1) {
                    term = ReasonerUtil.toCNF((Concept)clist.get(0), normalizeRestriction);
                    break;
                }
                term = BOTTOM;
                break;
            }
            case 14: {
                if (normalizeRestriction) {
                    SomeValueFrom s = (SomeValueFrom)c;
                    term = TermFactory.instance().createSome(s.getOnProperty(), ReasonerUtil.toCNF(s.getRange(), normalizeRestriction));
                    break;
                }
                term = ReasonerUtil.cloneConcept(c);
                break;
            }
            case 15: {
                if (normalizeRestriction) {
                    AllValueFrom a = (AllValueFrom)c;
                    term = TermFactory.instance().createAll(a.getOnProperty(), ReasonerUtil.toCNF(a.getRange(), normalizeRestriction));
                    break;
                }
                term = ReasonerUtil.cloneConcept(c);
                break;
            }
            default: {
                term = ReasonerUtil.cloneConcept(c);
            }
        }
        return ReasonerUtil.optimizeCNF(term);
    }

    /*
     * Unable to fully structure code
     */
    private static Concept optimizeCNF(Concept cnf) {
        term = cnf;
        clist = null;
        type = cnf == null ? -1 : cnf.getCType();
        switch (type) {
            case 13: {
                clist = ((Union)cnf).getUnionOf();
                if (clist.size() != 1) break;
                term = (Concept)clist.get(0);
                break;
            }
            case 12: {
                clist = ((Intersection)cnf).getIntersectOf();
                i = clist.size() - 1;
                while (i >= 0) {
                    c1 = (Concept)clist.get(i);
                    if (c1.getCType() != 13) ** GOTO lbl36
                    j = i - 1;
                    while (j >= 0) {
                        c2 = (Concept)clist.get(j);
                        if (c2.getCType() != 13) ** GOTO lbl29
                        if (!((Union)c1).getUnionOf().containsAll(((Union)c2).getUnionOf())) ** GOTO lbl24
                        clist.remove(i);
                        ** GOTO lbl45
lbl24:
                        // 1 sources

                        if (!((Union)c2).getUnionOf().containsAll(((Union)c1).getUnionOf())) ** GOTO lbl33
                        clist.remove(j);
                        --i;
                        ** GOTO lbl33
lbl29:
                        // 1 sources

                        if (!((Union)c1).getUnionOf().contains(c2)) ** GOTO lbl33
                        clist.remove(i);
                        ** GOTO lbl45
lbl33:
                        // 3 sources

                        --j;
                    }
                    ** GOTO lbl45
lbl36:
                    // 1 sources

                    j = i - 1;
                    while (j >= 0) {
                        c2 = (Concept)clist.get(j);
                        if (c2.getCType() == 13 && ((Union)c2).getUnionOf().contains(c1)) {
                            clist.remove(j);
                            --i;
                        }
                        --j;
                    }
lbl45:
                    // 4 sources

                    --i;
                }
                i = 0;
                while (i < clist.size()) {
                    c1 = (Concept)clist.get(i);
                    if (c1.getCType() == 13 && ((Union)c1).getUnionOf().size() == 1) {
                        ((ArrayList)clist).set(i, ((Union)c1).getUnionOf().get(0));
                    }
                    ++i;
                }
                if (clist.size() != 1) break;
                term = (Concept)clist.get(0);
                break;
            }
        }
        return term;
    }

    public static Concept toMinimalDNF(Concept c, RBox rbox) {
        Concept term = ReasonerUtil.toDNF(c, false);
        int type = term == null ? -1 : term.getCType();
        switch (type) {
            case 12: {
                ReasonerUtil.applyIRules((Intersection)term, rbox);
                Iterator it = ((Intersection)term).getIntersectOf().iterator();
                while (it.hasNext()) {
                    Concept c1 = (Concept)it.next();
                    if (!c1.isRestriction() || c1.getCType() == 19) continue;
                    Restriction rest = (Restriction)c1;
                    rest.setRange(ReasonerUtil.toMinimalDNF(rest.getRange(), rbox));
                }
                break;
            }
            case 13: {
                List ulist = ((Union)term).getUnionOf();
                Iterator it = ulist.iterator();
                block10: while (it.hasNext()) {
                    Concept subc = (Concept)it.next();
                    switch (subc.getCType()) {
                        case 12: {
                            ReasonerUtil.applyIRules((Intersection)subc, rbox);
                            Iterator iter = ((Intersection)subc).getIntersectOf().iterator();
                            while (iter.hasNext()) {
                                Concept c1 = (Concept)iter.next();
                                if (!c1.isRestriction() || c1.getCType() == 19) continue;
                                Restriction rest = (Restriction)c1;
                                rest.setRange(ReasonerUtil.toMinimalDNF(rest.getRange(), rbox));
                            }
                            continue block10;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: {
                            Restriction rest = (Restriction)subc;
                            rest.setRange(ReasonerUtil.toMinimalDNF(rest.getRange(), rbox));
                            break;
                        }
                    }
                }
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                Restriction rest = (Restriction)term;
                rest.setRange(ReasonerUtil.toMinimalDNF(rest.getRange(), rbox));
                break;
            }
        }
        return term;
    }

    private static Concept applyIRules(Intersection c, RBox rbox) {
        List clist = c.getIntersectOf();
        Iterator it = clist.iterator();
        while (it.hasNext()) {
            Concept c1 = (Concept)it.next();
            if (c1.getCType() != 15) continue;
            Iterator iter = clist.iterator();
            while (iter.hasNext()) {
                Concept c2 = (Concept)iter.next();
                if (c2 == c1) continue;
                switch (c2.getCType()) {
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        Restriction rest = (Restriction)c2;
                        Role p = rest.getOnProperty();
                        Role r = ((AllValueFrom)c1).getOnProperty();
                        if (!rbox.isSubPropertyOf(p, r)) break;
                        Concept range = rest.getRange();
                        if (range.getCType() == 12) {
                            ((Intersection)range).addIntersectOf(((AllValueFrom)c1).getRange());
                            break;
                        }
                        rest.setRange(TermFactory.instance().createIntersect(range, ((AllValueFrom)c1).getRange()));
                        break;
                    }
                }
            }
        }
        return c;
    }

    public static Concept toMaximalCNF(Concept c, RBox rbox) {
        Concept term = ReasonerUtil.toCNF(c, false);
        int type = term == null ? -1 : term.getCType();
        switch (type) {
            case 12: {
                List ilist = ((Intersection)term).getIntersectOf();
                Iterator it = ilist.iterator();
                block9: while (it.hasNext()) {
                    Concept subc = (Concept)it.next();
                    switch (subc.getCType()) {
                        case 13: {
                            ReasonerUtil.applyURules((Union)subc, rbox);
                            Iterator iter = ((Union)subc).getUnionOf().iterator();
                            while (iter.hasNext()) {
                                Concept c1 = (Concept)iter.next();
                                if (!c1.isRestriction() || c1.getCType() == 19) continue;
                                Restriction rest = (Restriction)c1;
                                rest.setRange(ReasonerUtil.toMaximalCNF(rest.getRange(), rbox));
                            }
                            continue block9;
                        }
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: {
                            Restriction rest = (Restriction)subc;
                            rest.setRange(ReasonerUtil.toMaximalCNF(rest.getRange(), rbox));
                            break;
                        }
                    }
                }
                break;
            }
            case 13: {
                ReasonerUtil.applyURules((Union)term, rbox);
                Iterator it = ((Union)term).getUnionOf().iterator();
                while (it.hasNext()) {
                    Concept c1 = (Concept)it.next();
                    if (!c1.isRestriction() || c1.getCType() == 19) continue;
                    Restriction rest = (Restriction)c1;
                    rest.setRange(ReasonerUtil.toMaximalCNF(rest.getRange(), rbox));
                }
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                Restriction rest = (Restriction)term;
                rest.setRange(ReasonerUtil.toMaximalCNF(rest.getRange(), rbox));
                break;
            }
        }
        return term;
    }

    private static Concept applyURules(Union c, RBox rbox) {
        List clist = c.getUnionOf();
        Iterator it = clist.iterator();
        while (it.hasNext()) {
            Concept c1 = (Concept)it.next();
            if (c1.getCType() != 14) continue;
            Iterator iter = clist.iterator();
            while (iter.hasNext()) {
                Concept c2 = (Concept)iter.next();
                if (c2 == c1) continue;
                switch (c2.getCType()) {
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: {
                        Restriction rest = (Restriction)c2;
                        Role p = rest.getOnProperty();
                        Role r = ((Restriction)c1).getOnProperty();
                        if (!rbox.isSubPropertyOf(p, r)) break;
                        Concept range = rest.getRange();
                        if (range.getCType() == 13) {
                            ((Union)range).addUnionOf(((Restriction)c1).getRange());
                            break;
                        }
                        rest.setRange(TermFactory.instance().createUnion(range, ((Restriction)c1).getRange()));
                        break;
                    }
                }
            }
        }
        return c;
    }

    public static Concept negate(Concept c) {
        return c.getCType() == 11 ? ((Negation)c).getNot() : TermFactory.instance().createNegation(c);
    }

    public static Concept toNNF(Concept c) {
        Concept term = null;
        int type = c == null ? -1 : c.getCType();
        block0 : switch (type) {
            case 11: {
                Concept t = ((Negation)c).getNot();
                switch (t.getCType()) {
                    case 11: {
                        term = ReasonerUtil.toNNF(((Negation)t).getNot());
                        break;
                    }
                    case 15: {
                        term = TermFactory.instance().createSome(((AllValueFrom)t).getOnProperty(), ReasonerUtil.toNNF(ReasonerUtil.negate(((AllValueFrom)t).getRange())));
                        break;
                    }
                    case 14: {
                        term = TermFactory.instance().createAll(((SomeValueFrom)t).getOnProperty(), ReasonerUtil.toNNF(ReasonerUtil.negate(((SomeValueFrom)t).getRange())));
                        break;
                    }
                    case 12: {
                        term = TermFactory.instance().createUnion();
                        Iterator it = ((Intersection)t).getIntersectOf().iterator();
                        while (it.hasNext()) {
                            ((Union)term).addUnionOf(ReasonerUtil.toNNF(ReasonerUtil.negate((Concept)it.next())));
                        }
                        break block0;
                    }
                    case 13: {
                        term = TermFactory.instance().createIntersect();
                        Iterator it = ((Union)t).getUnionOf().iterator();
                        while (it.hasNext()) {
                            ((Intersection)term).addIntersectOf(ReasonerUtil.toNNF(ReasonerUtil.negate((Concept)it.next())));
                        }
                        break block0;
                    }
                    default: {
                        term = c;
                        break;
                    }
                }
                break;
            }
            case 15: {
                term = TermFactory.instance().createAll(((AllValueFrom)c).getOnProperty(), ReasonerUtil.toNNF(((AllValueFrom)c).getRange()));
                break;
            }
            case 14: {
                term = TermFactory.instance().createSome(((SomeValueFrom)c).getOnProperty(), ReasonerUtil.toNNF(((SomeValueFrom)c).getRange()));
                break;
            }
            case 12: {
                term = TermFactory.instance().createIntersect();
                Iterator it = ((Intersection)c).getIntersectOf().iterator();
                while (it.hasNext()) {
                    ((Intersection)term).addIntersectOf(ReasonerUtil.toNNF((Concept)it.next()));
                }
                break;
            }
            case 13: {
                term = TermFactory.instance().createUnion();
                Iterator it = ((Union)c).getUnionOf().iterator();
                while (it.hasNext()) {
                    ((Union)term).addUnionOf(ReasonerUtil.toNNF((Concept)it.next()));
                }
                break;
            }
            default: {
                term = c;
            }
        }
        return term;
    }

    public static String toString(Term t) {
        StringBuffer buffer = new StringBuffer();
        List l = null;
        Object[] tmp = null;
        if (t != null) {
            block0 : switch (t.getType()) {
                case 1: {
                    buffer.append(((Role)t).getName());
                    break;
                }
                case 2: {
                    if (((Resource)t).getRType() != 101) break;
                    buffer.append(((Individual)t).getName());
                    break;
                }
                case 0: {
                    switch (((Concept)t).getCType()) {
                        case 20: {
                            buffer.append(((PrimitiveConcept)t).getName());
                            break block0;
                        }
                        case 11: {
                            buffer.append("(NOT ");
                            buffer.append(ReasonerUtil.toString(((Negation)t).getNot()));
                            buffer.append(")");
                            break block0;
                        }
                        case 12: {
                            buffer.append("(AND");
                            l = ((Intersection)t).getIntersectOf();
                            tmp = new String[l.size()];
                            int i = 0;
                            while (i < tmp.length) {
                                tmp[i] = ReasonerUtil.toString((Concept)l.get(i));
                                ++i;
                            }
                            Arrays.sort(tmp);
                            i = 0;
                            while (i < tmp.length) {
                                buffer.append(" ");
                                buffer.append((String)tmp[i]);
                                ++i;
                            }
                            buffer.append(")");
                            break block0;
                        }
                        case 13: {
                            buffer.append("(OR");
                            l = ((Union)t).getUnionOf();
                            tmp = new String[l.size()];
                            int i = 0;
                            while (i < tmp.length) {
                                tmp[i] = ReasonerUtil.toString((Concept)l.get(i));
                                ++i;
                            }
                            Arrays.sort(tmp);
                            i = 0;
                            while (i < tmp.length) {
                                buffer.append(" ");
                                buffer.append((String)tmp[i]);
                                ++i;
                            }
                            buffer.append(")");
                            break block0;
                        }
                        case 14: {
                            buffer.append("(SOME ");
                            buffer.append(((SomeValueFrom)t).getOnProperty().getName());
                            buffer.append(" ");
                            buffer.append(ReasonerUtil.toString(((SomeValueFrom)t).getRange()));
                            buffer.append(")");
                            break block0;
                        }
                        case 15: {
                            buffer.append("(ALL ");
                            buffer.append(((AllValueFrom)t).getOnProperty().getName());
                            buffer.append(" ");
                            buffer.append(ReasonerUtil.toString(((AllValueFrom)t).getRange()));
                            buffer.append(")");
                            break block0;
                        }
                        case 16: {
                            buffer.append("(MIN ");
                            buffer.append(((MinCardinality)t).getValRange());
                            buffer.append(" ");
                            buffer.append(((MinCardinality)t).getOnProperty().getName());
                            buffer.append(" ");
                            buffer.append(ReasonerUtil.toString(((MinCardinality)t).getRange()));
                            buffer.append(")");
                            break block0;
                        }
                        case 17: {
                            buffer.append("(MAX ");
                            buffer.append(((MaxCardinality)t).getValRange());
                            buffer.append(" ");
                            buffer.append(((MaxCardinality)t).getOnProperty().getName());
                            buffer.append(" ");
                            buffer.append(ReasonerUtil.toString(((MaxCardinality)t).getRange()));
                            buffer.append(")");
                            break block0;
                        }
                        case 18: {
                            buffer.append("(Card ");
                            buffer.append(((Cardinality)t).getValRange());
                            buffer.append(" ");
                            buffer.append(((Cardinality)t).getOnProperty().getName());
                            buffer.append(" ");
                            buffer.append(ReasonerUtil.toString(((Cardinality)t).getRange()));
                            buffer.append(")");
                            break block0;
                        }
                        case 19: {
                            buffer.append("(HasValue ");
                            buffer.append(((HasValue)t).getOnProperty().getName());
                            buffer.append(" ");
                            buffer.append(ReasonerUtil.toString(((HasValue)t).getHasValue()));
                            buffer.append(")");
                        }
                    }
                }
            }
        }
        return buffer.toString();
    }

    public static Concept cloneConcept(Concept c) {
        Concept clone = null;
        int type = c == null ? -1 : c.getCType();
        switch (type) {
            case 11: {
                clone = TermFactory.instance().createNegation(((Negation)c).getNot());
                break;
            }
            case 15: {
                clone = TermFactory.instance().createAll(((AllValueFrom)c).getOnProperty(), ReasonerUtil.cloneConcept(((AllValueFrom)c).getRange()));
                break;
            }
            case 14: {
                clone = TermFactory.instance().createSome(((SomeValueFrom)c).getOnProperty(), ReasonerUtil.cloneConcept(((SomeValueFrom)c).getRange()));
                break;
            }
            case 18: {
                clone = TermFactory.instance().createCardinality(((Cardinality)c).getOnProperty(), ((Cardinality)c).getValRange(), ReasonerUtil.cloneConcept(((Cardinality)c).getRange()));
                break;
            }
            case 17: {
                clone = TermFactory.instance().createMaxCardinality(((MaxCardinality)c).getOnProperty(), ((MaxCardinality)c).getValRange(), ReasonerUtil.cloneConcept(((MaxCardinality)c).getRange()));
                break;
            }
            case 16: {
                clone = TermFactory.instance().createMinCardinality(((MinCardinality)c).getOnProperty(), ((MinCardinality)c).getValRange(), ReasonerUtil.cloneConcept(((MinCardinality)c).getRange()));
                break;
            }
            case 19: {
                clone = TermFactory.instance().createHasValue(((HasValue)c).getOnProperty(), ((HasValue)c).getHasValue());
                break;
            }
            case 12: {
                clone = TermFactory.instance().createIntersect();
                Iterator it = ((Intersection)c).getIntersectOf().iterator();
                while (it.hasNext()) {
                    ((Intersection)clone).addIntersectOf(ReasonerUtil.cloneConcept((Concept)it.next()));
                }
                break;
            }
            case 13: {
                clone = TermFactory.instance().createUnion();
                Iterator it = ((Union)c).getUnionOf().iterator();
                while (it.hasNext()) {
                    ((Union)clone).addUnionOf(ReasonerUtil.cloneConcept((Concept)it.next()));
                }
                break;
            }
            default: {
                clone = c;
            }
        }
        return clone;
    }
}

