/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eodm.examples.rdf;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.eodm.rdf.resource.RDFXMLResourceFactoryImpl;
import org.eclipse.eodm.rdfs.Ontology;

public class LoadAndSaveRDFExample {
    public static void main(String[] args) {
        try {
            Ontology ontology = LoadAndSaveRDFExample.load();
            LoadAndSaveRDFExample.save(ontology);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static Ontology load() throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("rdf", new RDFXMLResourceFactoryImpl());
        URI fileURI = URI.createFileURI((String)new File("testcase/rdf-schema.rdf").getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        resource.load(Collections.EMPTY_MAP);
        return (Ontology)resource.getContents().get(0);
    }

    protected static void save(Ontology ontology) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("rdf", new RDFXMLResourceFactoryImpl());
        URI fileURI = URI.createFileURI((String)new File("testcase/rdfs_output.rdf").getAbsolutePath());
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)ontology);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        resource.save(options);
    }
}

