/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.sequence.draw2d.layouts;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class FillingBorderLayout
extends BorderLayout {
    private IFigure center;
    private IFigure left;
    private IFigure top;
    private IFigure bottom;
    private IFigure right;
    private int vGap = 0;
    private int hGap = 0;

    public void layout(IFigure container) {
        Dimension childSize;
        Rectangle area = container.getClientArea();
        Rectangle rect = new Rectangle();
        if (this.top != null && this.top.isVisible()) {
            childSize = this.top.getPreferredSize(area.width, -1);
            rect.setLocation(area.x, area.y);
            rect.height = childSize.height;
            rect.width = area.width;
            this.top.setBounds(rect);
            area.y += rect.height + this.vGap;
            area.height -= rect.height + this.vGap;
        }
        if (this.bottom != null && this.bottom.isVisible()) {
            childSize = this.bottom.getPreferredSize(area.width, -1);
            rect.height = childSize.height;
            rect.width = area.width;
            rect.setLocation(area.x, area.y + area.height - rect.height);
            this.bottom.setBounds(rect);
            area.height -= rect.height + this.vGap;
        }
        if (this.left != null && this.left.isVisible()) {
            childSize = this.left.getPreferredSize(-1, Math.max(0, area.height));
            rect.setLocation(area.x, area.y);
            rect.width = childSize.width;
            rect.height = Math.max(0, area.height);
            this.left.setBounds(rect);
            area.x += rect.width + this.hGap;
            area.width -= rect.width + this.hGap;
        }
        if (this.right != null && this.right.isVisible()) {
            childSize = this.right.getPreferredSize(-1, Math.max(0, area.height));
            rect.width = childSize.width;
            rect.height = Math.max(0, area.height);
            rect.setLocation(area.x + area.width - rect.width, area.y);
            this.right.setBounds(rect);
            area.width -= rect.width + this.hGap;
        }
        if (this.center != null && this.center.isVisible()) {
            this.center.setBounds(area);
        }
    }

    public void remove(IFigure child) {
        super.remove(child);
        if (this.center == child) {
            this.center = null;
        } else if (this.top == child) {
            this.top = null;
        } else if (this.bottom == child) {
            this.bottom = null;
        } else if (this.right == child) {
            this.right = null;
        } else if (this.left == child) {
            this.left = null;
        }
    }

    public void setConstraint(IFigure child, Object constraint) {
        super.setConstraint(child, constraint);
        if (constraint == null) {
            return;
        }
        switch ((Integer)constraint) {
            case 2: {
                this.center = child;
                break;
            }
            case 8: {
                this.top = child;
                break;
            }
            case 32: {
                this.bottom = child;
                break;
            }
            case 4: {
                this.right = child;
                break;
            }
            case 1: {
                this.left = child;
                break;
            }
        }
    }

    public void setHorizontalSpacing(int gap) {
        super.setHorizontalSpacing(gap);
        this.hGap = gap;
    }

    public void setVerticalSpacing(int gap) {
        super.setVerticalSpacing(gap);
        this.vGap = gap;
    }
}

