/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.lpg;

import java.io.IOException;
import java.io.Reader;
import lpg.lpgjavaruntime.LpgLexStream;
import lpg.lpgjavaruntime.Monitor;
import lpg.lpgjavaruntime.RuleAction;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.ocl.lpg.BasicEnvironment;

public abstract class AbstractLexer
extends LpgLexStream
implements RuleAction {
    protected static final int ECLIPSE_TAB_VALUE = 4;
    private final BasicEnvironment environment;

    public static char[] getInputChars(Reader reader) throws IOException {
        char[] buffer = new char[16384];
        int nextIndex = 0;
        while (reader.ready()) {
            int moreChars;
            if (nextIndex >= buffer.length) {
                char[] newBuffer = new char[2 * buffer.length];
                System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                buffer = newBuffer;
            }
            if ((moreChars = reader.read(buffer, nextIndex, buffer.length - nextIndex)) > 0) {
                nextIndex += moreChars;
                continue;
            }
            if (moreChars < 0) break;
        }
        if (nextIndex != buffer.length) {
            char[] newBuffer = new char[nextIndex];
            System.arraycopy(buffer, 0, newBuffer, 0, nextIndex);
            buffer = newBuffer;
        }
        return buffer;
    }

    public AbstractLexer(BasicEnvironment environment, String filename, int tab) throws IOException {
        super(filename, tab);
        this.environment = environment;
    }

    public AbstractLexer(BasicEnvironment environment, char[] input_chars, String filename, int tab) {
        super(input_chars, filename, tab);
        this.environment = environment;
    }

    public AbstractLexer(BasicEnvironment environment) {
        this.setTab(4);
        this.environment = environment;
    }

    protected int computeErrorCode(int leftToken, int rightToken) {
        if (rightToken >= this.getStreamLength()) {
            return 10;
        }
        if (leftToken == rightToken) {
            return 0;
        }
        return 11;
    }

    public BasicEnvironment getEnvironment() {
        return this.environment;
    }

    public void lexToTokens(AbstractParser parser) {
        this.lexToTokens(null, parser);
    }

    public abstract void lexToTokens(Monitor var1, AbstractParser var2);

    public void reportError(int leftToken, int rightToken) {
        BasicEnvironment environment = this.getEnvironment();
        if (environment != null) {
            environment.lexerError(this.computeErrorCode(leftToken, rightToken), leftToken, rightToken);
        } else {
            super.reportError(leftToken, rightToken);
        }
    }

    public void initialize(char[] inputChars) {
        this.setInputChars(inputChars);
        this.setStreamLength(inputChars.length);
        this.computeLineOffsets();
    }

    public void initialize(Reader reader) throws IOException {
        char[] buffer = AbstractLexer.getInputChars(reader);
        this.initialize(buffer);
    }
}

