/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.edit.internal.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.edit.providers.IHierarchicContentProvider;

public class EClassTreeContentProvider
implements IHierarchicContentProvider {
    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof Collection) {
            return ((Collection)inputElement).toArray();
        }
        if (inputElement instanceof Object[]) {
            return (Object[])inputElement;
        }
        return new Object[0];
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof EPackage) {
            ArrayList<EPackage> returnedValues = new ArrayList<EPackage>();
            EPackage ePackage = (EPackage)parentElement;
            for (EPackage current : ePackage.getESubpackages()) {
                if (!this.isValidValue(current)) continue;
                returnedValues.add(current);
            }
            for (EPackage current : ePackage.getEClassifiers()) {
                if (!this.isValidValue(current)) continue;
                returnedValues.add(current);
            }
            return returnedValues.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof EObject) {
            return ((EObject)element).eContainer();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof EClass) {
            return false;
        }
        return this.isValidValue(element);
    }

    protected final boolean hasEClassInHierarchy(EPackage ePackage) {
        Iterator eClassIter = ePackage.getEClassifiers().iterator();
        boolean isValidValue = false;
        while (eClassIter.hasNext() && !isValidValue) {
            isValidValue = this.isValidValue(eClassIter.next());
        }
        Iterator packIter = ePackage.getESubpackages().iterator();
        while (packIter.hasNext() && !isValidValue) {
            isValidValue = this.hasEClassInHierarchy((EPackage)packIter.next());
        }
        return isValidValue;
    }

    @Override
    public boolean isValidValue(Object element) {
        if (element instanceof EClass) {
            return true;
        }
        if (element instanceof EPackage) {
            return this.hasEClassInHierarchy((EPackage)element);
        }
        return false;
    }
}

