/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.service;

import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IContentChangedListener;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.DiSashModelManager;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.model2doc.odt.internal.listener.OpenCloseODTDocumentListener;

public class OpenCloseODTDocumentService
implements IService {
    private OpenCloseODTDocumentListener sashListener;
    private ServicesRegistry registry;
    private DiSashModelManager pageMngr;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    public void startService() throws ServiceException {
        this.pageMngr = (DiSashModelManager)ServiceUtils.getInstance().getService(DiSashModelManager.class, (Object)this.registry);
        this.sashListener = new OpenCloseODTDocumentListener();
        this.pageMngr.getSashModelContentChangedProvider().addListener((IContentChangedListener)this.sashListener);
    }

    public void disposeService() throws ServiceException {
        if (this.pageMngr.getSashModelContentChangedProvider() != null) {
            this.pageMngr.getSashModelContentChangedProvider().removeListener((IContentChangedListener)this.sashListener);
        }
        this.registry = null;
        this.pageMngr = null;
        this.sashListener = null;
    }
}

