/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.internal.mapping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.model2doc.emf.documentstructure.BodyPart;
import org.eclipse.papyrus.model2doc.emf.documentstructure.Title;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.EClassPartTemplate;
import org.eclipse.papyrus.model2doc.emf.documentstructuretemplate.IBodyPartTemplate;
import org.eclipse.papyrus.model2doc.emf.template2structure.internal.mapping.AbstractEMFTemplateToStructureMapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;

public class EClassPartTemplateMapper
extends AbstractEMFTemplateToStructureMapper<EClassPartTemplate> {
    public EClassPartTemplateMapper() {
        super(TEMPLATE_EPACKAGE.getEClassPartTemplate(), BodyPart.class);
    }

    @Override
    protected <T> List<T> doMap(IMappingService mappingService, EClassPartTemplate eClassPartTemplate, EObject semanticModelElement, Class<T> expectedReturnedClass) {
        if (!eClassPartTemplate.generateBranch(semanticModelElement)) {
            return Collections.emptyList();
        }
        if (!eClassPartTemplate.isMatchingFilterRule(semanticModelElement)) {
            return Collections.emptyList();
        }
        Title title = null;
        ArrayList returnedElements = new ArrayList();
        if (eClassPartTemplate.isGenerate() && eClassPartTemplate.isGenerateTitle()) {
            title = STRUCTURE_EFACTORY.createTitle();
            title.setTitle(eClassPartTemplate.buildPartTemplateTitle(semanticModelElement));
            returnedElements.add(expectedReturnedClass.cast(title));
        }
        for (IBodyPartTemplate currentFeature : eClassPartTemplate.getBodyPartTemplates()) {
            List<BodyPart> result = mappingService.map((EObject)currentFeature, semanticModelElement, BodyPart.class);
            if (result == null) continue;
            if (title != null) {
                title.getSubBodyParts().addAll(result);
                continue;
            }
            result.stream().forEach(a -> {
                boolean bl = returnedElements.add(expectedReturnedClass.cast(a));
            });
        }
        return returnedElements;
    }
}

