/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.documentview.ui.internal.advice;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.documentview.Document;
import org.eclipse.papyrus.model2doc.documentview.ui.internal.message.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ide.undo.DeleteResourcesOperation;

public class DeleteDocumentViewAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        if (request.getElementToDestroy() instanceof Document) {
            final Document document = (Document)request.getElementToDestroy();
            AbstractTransactionalCommand cmd = new AbstractTransactionalCommand(request.getEditingDomain(), null, null){
                DeleteResourcesOperation op;
                {
                    super($anonymous0, $anonymous1, $anonymous2);
                    this.op = null;
                }

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    Path path = new Path(document.getGeneratedDocumentFileURI());
                    IFile fileToDelete = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
                    boolean canNotDeleteFile = false;
                    File file = new File(fileToDelete.getLocation().toString());
                    if (!file.renameTo(file) && file.exists()) {
                        canNotDeleteFile = true;
                    }
                    if (canNotDeleteFile) {
                        MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.DeleteDocumentViewAdvice_DestroyDocumentFile, (String)NLS.bind((String)Messages.DeleteDocumentViewAdvice_DocumentCanNotBeDeletedBecauseFileIsOpened, (Object)fileToDelete.getName()));
                        return CommandResult.newCancelledCommandResult();
                    }
                    List<IFile> resourcesToDelete = Collections.singletonList(fileToDelete);
                    this.op = new DeleteResourcesOperation(resourcesToDelete.toArray(new IResource[resourcesToDelete.size()]), "Delete Resources", false);
                    this.op.execute((IProgressMonitor)new NullProgressMonitor(), null);
                    return CommandResult.newOKCommandResult();
                }

                protected IStatus doRedo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    this.op.redo((IProgressMonitor)new NullProgressMonitor(), null);
                    return super.doRedo(monitor, info);
                }

                protected IStatus doUndo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    this.op.undo((IProgressMonitor)new NullProgressMonitor(), null);
                    return super.doUndo(monitor, info);
                }

                public boolean canUndo() {
                    return this.op != null && this.op.canUndo();
                }

                public boolean canRedo() {
                    return this.op != null && this.op.canRedo();
                }
            };
            return cmd;
        }
        return super.getBeforeDestroyDependentsCommand(request);
    }
}

